/*
 * Decompiled with CFR 0.152.
 */
package jfileupload.transfer.client.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.Insets;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import jfileupload.transfer.client.core.ClientException;
import jfileupload.transfer.client.core.FolderMonitor;
import jfileupload.transfer.client.core.Monitor;
import jfileupload.transfer.client.core.TransferController;
import jfileupload.transfer.client.core.TransferFactory;
import jfileupload.transfer.client.core.TransferUI;
import jfileupload.transfer.client.core.TriggeredInputStream;
import jfileupload.transfer.client.util.Base64;
import jfileupload.transfer.client.util.CustomResourceBundle;
import jfileupload.transfer.client.util.PBE;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Conf {
    private static final Log log = LogFactory.getLog((Class)(class$jfileupload$transfer$client$util$Conf == null ? (class$jfileupload$transfer$client$util$Conf = Conf.class$("jfileupload.transfer.client.util.Conf")) : class$jfileupload$transfer$client$util$Conf));
    public static final String PRODUCT = "JFileUpload";
    public static final String VERSION = "2.7";
    public static final String BUILD = "FINAL.001";
    public static final String HOMEPAGE = "http://www.jfileupload.com";
    public static String CR = "\n";
    public static boolean SAFE = true;
    public static final String INTERNAL = "jfileupload/";
    public static String BASE64BEGIN = "[";
    public static String BASE64END = "]";
    public static String PBEBEGIN = "{";
    public static String PBEEND = "}";
    public static String HTTPUPLOADMODE = "jfileupload.transfer.client.http.HTTPUploadTransfer";
    public static String FTPUPLOADMODE = "jfileupload.transfer.client.ftp.FTPUploadTransfer";
    public static String ARCHIVER = "jfileupload.transfer.client.core.ArchiveFilter";
    public static String SOCKSPROXYPORT = "socksProxyPort";
    public static String SOCKSPROXYHOST = "socksProxyHost";
    public static String PREFERENCESFOLDER = "";
    public static String PREFERENCESFILE = "jfileupload.ini";
    public static String TEMPLATEFILTER = "additionalfilterid";
    public static String TEMPLATEITEM = "item";
    public static String[] PARAMS = new String[]{"base64", "hidebar", "hideprogress", "hideinfo", "resetprogressbar", "startdir", "startfilename", "authentication", "url", "tmpfolder", "whitelist", "maxsize", "minsize", "maxfiles", "regfile", "locale", "resources", "hiddenfile", "fullmaxsize", "ziponfly", "username", "password", "source", "target", "ext", "template", "templatescope", "zipmaxsize", "dirmonitor", "blacklist", "zipignorelist", "zipfolder", "threaded", "freezeui", "monitor", "inputstream", "retry", "retrydelay", "preprocessingfilter", "preprocessingfilterproperties", "preprocessingfilterparam1", "preprocessingfiltervalue1", "preprocessingfilterparam2", "preprocessingfiltervalue2", "preprocessingfilterparam3", "preprocessingfiltervalue3", "preprocessingfilterparam4", "preprocessingfiltervalue4", "preprocessingfilterparam5", "preprocessingfiltervalue5", "preprocessingfilterparam6", "preprocessingfiltervalue6", "preprocessingfilterparam7", "preprocessingfiltervalue7", "preprocessingfilterparam8", "preprocessingfiltervalue8", "preprocessingfilterparam9", "preprocessingfiltervalue9", "preprocessingfilterparam10", "preprocessingfiltervalue10", "preprocessingfilterparam11", "preprocessingfiltervalue11", "preprocessingfilterparam12", "preprocessingfiltervalue12", "preprocessingfilterparam13", "preprocessingfiltervalue13", "preprocessingfilterparam14", "preprocessingfiltervalue14", "preprocessingfilterparam15", "preprocessingfiltervalue15", "preprocessingfilterparam16", "preprocessingfiltervalue16", "filter", "filterproperties", "filterparam1", "filtervalue1", "filterparam2", "filtervalue2", "filterparam3", "filtervalue3", "filterparam4", "filtervalue4", "filterparam5", "filtervalue5", "filterparam6", "filtervalue6", "filterparam7", "filtervalue7", "filterparam8", "filtervalue8", "filterparam9", "filtervalue9", "filterparam10", "filtervalue10", "filterparam11", "filtervalue11", "filterparam12", "filtervalue12", "filterparam13", "filtervalue13", "filterparam14", "filtervalue14", "filterparam15", "filtervalue15", "filterparam16", "filtervalue16", TEMPLATEFILTER, "filterchain", "preferences", "mjv", "mjvforward", "mjvforwardtarget", "mjvmac", "mjvforwardmac", "mjvforwardtargetmac", "menu.color.foreground", "menu.color.background", "browse", "overwrite", "resume", "checksum", "localeresources", "localeresourcesextension", "pbedelimiter", "identifierinit", "metascope", "verbosemode", "transferui", "transferuiresources", "transferuiproperties", "transferuiparam1", "transferuivalue1", "transferuiparam2", "transferuivalue2", "transferuiparam3", "transferuivalue3", "transferuiparam4", "transferuivalue4", "transferuiparam5", "transferuivalue5", "transferuiparam6", "transferuivalue6", "transferuiparam7", "transferuivalue7", "transferuiparam8", "transferuivalue8", "transferuiparam9", "transferuivalue9", "transferuiparam10", "transferuivalue10", "transferuiparam11", "transferuivalue11", "transferuiparam12", "transferuivalue12", "transferuiparam13", "transferuivalue13", "transferuiparam14", "transferuivalue14", "transferuiparam15", "transferuivalue15", "transferuiparam16", "transferuivalue16", "uihelper", "uihelperresources", "uihelperproperties", "uihelperparam1", "uihelpervalue1", "uihelperparam2", "uihelpervalue2", "progress.bar.color.background", "progress.bar.color.foreground", "width", "height", "progress.button.cancel.color.background", "progress.button.cancel.color.foreground", "taskoutput.color.foreground", "taskoutput.color.background", "socksproxyport", "socksproxyhost", "concurrency", "auto", "sm", "encoder", "buffersize", "cancelonstop", "paramfile", "encoding", "chunksize", "chunkmode", "post", "postparameters", "policy", "hidden", "status", "statusparameters", "mode", "splitinfo", "folderdepth", "timeout", "forward", "forwardtarget", "forwardparameters", "param1", "value1", "param2", "value2", "param3", "value3", "param4", "value4", "param5", "value5", "param6", "value6", "param7", "value7", "param8", "value8", "param9", "value9", "param10", "value10", "param11", "value11", "param12", "value12", "param13", "value13", "param14", "value14", "param15", "value15", "param16", "value16"};
    public static String[] TEMPLATEFILTERPARAMS = new String[]{"filter", "filterproperties", "filterparam1", "filtervalue1", "filterparam2", "filtervalue2", "filterparam3", "filtervalue3", "filterparam4", "filtervalue4", "filterparam5", "filtervalue5", "filterparam6", "filtervalue6", "filterparam7", "filtervalue7", "filterparam8", "filtervalue8", "filterparam9", "filtervalue9", "filterparam10", "filtervalue10", "filterparam11", "filtervalue11", "filterparam12", "filtervalue12", "filterparam13", "filtervalue13", "filterparam14", "filtervalue14", "filterparam15", "filtervalue15", "filterparam16", "filtervalue16"};
    public static String REDIRECTPARAMNAME = "filename";
    public static String SIZEPARAMNAME = "filesize";
    public static String DATEPARAMNAME = "filedate";
    public static String STATUSPARAMNAME = "status";
    private Properties props = null;
    private Properties preferences = null;
    private CustomResourceBundle bundle = null;
    private Font font = null;
    private Base64 base64 = null;
    private URL codebase = null;
    private URL documentbase = null;
    private HashMap uistatus = null;
    private Monitor monitor = null;
    private FolderMonitor dirMonitor = null;
    private HashMap shared = null;
    private long identifier = 0L;
    static /* synthetic */ Class class$jfileupload$transfer$client$util$Conf;
    static /* synthetic */ Class class$java$io$InputStream;
    static /* synthetic */ Class class$java$util$List;

    public Conf(String string) {
        if (string != null) {
            this.loadResources(string);
        }
        this.props = new Properties();
        this.preferences = new Properties();
        this.uistatus = new HashMap();
        this.base64 = new Base64();
        this.shared = new HashMap();
    }

    public String getProperty(String string) {
        if (this.props != null && string != null) {
            return this.props.getProperty(string);
        }
        return null;
    }

    public Properties getProperties() {
        return this.props;
    }

    public Properties getPreferences() {
        return this.preferences;
    }

    public HashMap getShared() {
        return this.shared;
    }

    public void initVerboseMode() {
        String string = this.getProperty("verbosemode");
        if (string != null) {
            if (string.equalsIgnoreCase("none")) {
                System.setProperty("org.apache.commons.logging.simplelog.log.jfileupload", "fatal");
            } else if (string.equalsIgnoreCase("debug")) {
                System.setProperty("org.apache.commons.logging.simplelog.log.httpclient.wire.header", "debug");
                System.setProperty("org.apache.commons.logging.simplelog.log.org.apache.commons.httpclient", "debug");
                System.setProperty("org.apache.commons.logging.simplelog.log.jfileupload", "debug");
            } else if (string.equalsIgnoreCase("trace")) {
                System.setProperty("org.apache.commons.logging.simplelog.defaultlog", "debug");
                System.setProperty("org.apache.commons.logging.simplelog.log.httpclient.wire.header", "debug");
                System.setProperty("org.apache.commons.logging.simplelog.log.org.apache.commons.httpclient", "debug");
                System.setProperty("org.apache.commons.logging.simplelog.log.jfileupload", "debug");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadPreferences() {
        File file = this.getPreferencesFile();
        if (file != null && file.exists()) {
            FileInputStream fileInputStream = null;
            try {
                byte[] byArray = new byte[(int)file.length()];
                fileInputStream = new FileInputStream(file);
                fileInputStream.read(byArray);
                if (this.getProperty("preferences").equalsIgnoreCase("pbe")) {
                    byArray = new PBE(this).decipher(null, byArray, 0, byArray.length);
                }
                this.preferences.load(new ByteArrayInputStream(byArray));
                if (this.preferences.getProperty("version") == null) {
                    this.preferences.clear();
                }
            }
            catch (Exception exception) {
                log.error((Object)exception);
            }
            finally {
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException iOException) {
                    log.error((Object)iOException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void savePreferences() {
        File file = this.getPreferencesFile();
        if (file != null && this.getProperty("preferences") != null) {
            FileOutputStream fileOutputStream = null;
            try {
                this.preferences.setProperty("version", VERSION);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                this.preferences.store(byteArrayOutputStream, null);
                byte[] byArray = byteArrayOutputStream.toByteArray();
                if (this.getProperty("preferences").equalsIgnoreCase("pbe")) {
                    byArray = new PBE(this).cipher(null, byArray, 0, byArray.length);
                }
                fileOutputStream = new FileOutputStream(file);
                fileOutputStream.write(byArray);
            }
            catch (Exception exception) {
                log.error((Object)exception);
            }
            finally {
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (IOException iOException) {
                    log.error((Object)iOException);
                }
            }
        }
    }

    private File getPreferencesFile() {
        File file = null;
        String string = System.getProperty("java.io.tmpdir");
        String string2 = System.getProperty("os.name");
        if (string2 != null && string2.toLowerCase().indexOf("mac") != -1) {
            string = System.getProperty("user.home");
        }
        if (string != null && string.length() > 0) {
            if (!(string = string.replace('\\', '/')).endsWith("/")) {
                string = string + "/";
            }
            if (PREFERENCESFOLDER != null && PREFERENCESFOLDER.length() > 0) {
                File file2;
                if (!(string = string + PREFERENCESFOLDER).endsWith("/")) {
                    string = string + "/";
                }
                if (!(file2 = new File(string)).exists()) {
                    file2.mkdirs();
                }
            }
            file = new File(string + PREFERENCESFILE);
        }
        return file;
    }

    public long getNextIdentifier() {
        return this.identifier++;
    }

    public Color getColor(String string) {
        Color color = null;
        if (string != null) {
            try {
                color = new Color(Integer.parseInt(string, 16));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return color;
    }

    public Font loadFont(String string, int n) {
        return this.loadFont(string, n, INTERNAL);
    }

    public Font loadFont(String string, int n, String string2) {
        Font font = null;
        if (string != null) {
            if (n <= 0) {
                n = 12;
            }
            try {
                InputStream inputStream = null;
                inputStream = string2 != null && string.startsWith(string2) ? this.getClass().getClassLoader().getResourceAsStream(string) : (this.getDocumentbase() != null ? new URL(this.getDocumentbase(), string).openStream() : this.getClass().getClassLoader().getResourceAsStream(string));
                font = Font.createFont(0, inputStream);
                font = font.deriveFont((float)n * 1.0f);
            }
            catch (FontFormatException fontFormatException) {
                log.debug((Object)"Cannot load font", (Throwable)fontFormatException);
            }
            catch (IOException iOException) {
                log.debug((Object)"Cannot load font", (Throwable)iOException);
            }
        }
        return font;
    }

    public void loadImageButton(JButton jButton, String string) {
        ImageIcon imageIcon = this.loadIcon(this.getResource(string + ".icon"));
        if (imageIcon != null) {
            ImageIcon imageIcon2;
            if (jButton.getText() == null || jButton.getText().length() == 0) {
                jButton.setFocusPainted(false);
                jButton.setContentAreaFilled(false);
                jButton.setBorder(null);
                jButton.setBorderPainted(false);
                jButton.setMargin(new Insets(0, 0, 0, 0));
            }
            jButton.setIcon(imageIcon);
            ImageIcon imageIcon3 = this.loadIcon(this.getResource(string + ".icon.over"));
            if (imageIcon3 != null) {
                jButton.setPressedIcon(imageIcon3);
                jButton.setRolloverIcon(imageIcon3);
            }
            if ((imageIcon2 = this.loadIcon(this.getResource(string + ".icon.disabled"))) != null) {
                jButton.setDisabledIcon(imageIcon2);
            }
        }
    }

    public void loadFontUIResource(Font font) {
        if (font != null) {
            FontUIResource fontUIResource = new FontUIResource(font);
            Enumeration enumeration = UIManager.getDefaults().keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                Object object = UIManager.get(k);
                if (!(object instanceof FontUIResource)) continue;
                UIManager.put(k, fontUIResource);
            }
        }
    }

    public void loadUIResources() {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        String string7;
        String string8;
        String string9 = this.getResource("lookandfeel");
        if (string9 != null) {
            try {
                if (string9.equalsIgnoreCase("auto")) {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                } else {
                    UIManager.setLookAndFeel(string9);
                }
            }
            catch (Exception exception) {
                log.error((Object)exception);
            }
        }
        if ((string8 = this.getResource("progress.bar.color.selection.background")) != null) {
            UIManager.put("ProgressBar.selectionBackground", this.getColor(string8));
        }
        if ((string7 = this.getResource("progress.bar.color.selection.foreground")) != null) {
            UIManager.put("ProgressBar.selectionForeground", this.getColor(string7));
        }
        if ((string6 = this.getResource("progress.button.cancel.disabled.color")) == null) {
            string6 = this.getResource("progress.button.select.disabled.color");
        }
        if (string6 != null) {
            UIManager.put("Button.disabledText", this.getColor(string6));
        }
        if ((string5 = this.getResource("menu.color.selection.background")) != null) {
            UIManager.put("Menu.selectionBackground", this.getColor(string5));
            UIManager.put("MenuItem.selectionBackground", this.getColor(string5));
        }
        if ((string4 = this.getResource("filechooser.dialog.open.button")) != null) {
            UIManager.put("FileChooser.openButtonText", string4);
        }
        if ((string3 = this.getResource("filechooser.dialog.open.button.tooltip")) != null) {
            UIManager.put("FileChooser.openButtonToolTipText", string3);
        }
        if ((string2 = this.getResource("filechooser.dialog.cancel.button")) != null) {
            UIManager.put("FileChooser.cancelButtonText", string2);
        }
        if ((string = this.getResource("filechooser.dialog.cancel.button.tooltip")) != null) {
            UIManager.put("FileChooser.cancelButtonToolTipText", string);
        }
    }

    public long getLong(String string) {
        long l = -1L;
        if (string != null) {
            try {
                l = Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return l;
    }

    public int getAlignment(String string) {
        int n = 2;
        if (string != null) {
            n = string.equalsIgnoreCase("right") ? 4 : (string.equalsIgnoreCase("center") ? 0 : 2);
        }
        return n;
    }

    public String getErrorMessage(ClientException clientException) {
        String string = null;
        if (clientException != null) {
            Object[] objectArray = new Object[1];
            String string2 = this.getResource("taskoutput.upload.failed");
            if (clientException.getMessage().equals("server error")) {
                string2 = this.getResource("taskoutput.upload.failed.server.error");
                objectArray[0] = clientException.getExtMessage();
            } else if (clientException.getMessage().equals("max size exceeded")) {
                string2 = this.getResource("taskoutput.upload.failed.maxsize.error");
                objectArray[0] = this.getProperty("maxsize");
            } else if (clientException.getMessage().equals("compressed max size exceeded")) {
                string2 = this.getResource("taskoutput.upload.failed.maxsize.error");
                objectArray[0] = this.getProperty("zipmaxsize");
            } else if (clientException.getMessage().equals("full max size exceeded")) {
                string2 = this.getResource("taskoutput.upload.failed.maxsize.error");
                objectArray[0] = this.getProperty("fullmaxsize");
            } else if (clientException.getMessage().equals("min size no reached")) {
                string2 = this.getResource("taskoutput.upload.failed.minsize.error");
                objectArray[0] = this.getProperty("minsize");
            } else if (clientException.getMessage().equals("extension not allowed")) {
                string2 = this.getResource("taskoutput.upload.failed.whitelist.error");
                objectArray[0] = clientException.getExtMessage();
            } else if (clientException.getMessage().equals("hidden file not allowed")) {
                string2 = this.getResource("taskoutput.upload.failed.hidden.error");
                objectArray[0] = clientException.getExtMessage();
            } else if (clientException.getMessage().equals("directories not allowed")) {
                string2 = this.getResource("taskoutput.upload.failed.filesonly.error");
                objectArray[0] = clientException.getExtMessage();
            } else if (clientException.getMessage().equals("max files exceeded")) {
                string2 = this.getResource("taskoutput.upload.failed.maxfiles.error");
                objectArray[0] = clientException.getExtMessage();
            } else if (clientException.getMessage().equals("overwrite not allowed")) {
                string2 = this.getResource("taskoutput.upload.failed.overwrite.error");
                objectArray[0] = clientException.getExtMessage();
            } else {
                objectArray[0] = clientException.getMessage();
            }
            if (string2 != null) {
                string = MessageFormat.format(string2, objectArray);
            }
        }
        return string;
    }

    public String getResource(String string) {
        String string2 = null;
        try {
            string2 = this.bundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return string2;
    }

    public Font getFont() {
        return this.font;
    }

    public void loadResources(String string) {
        String string2;
        String string3 = this.getProperty("localeresources");
        if (string3 != null && string3.equalsIgnoreCase("true")) {
            this.bundle = new CustomResourceBundle(true);
        } else {
            this.bundle = new CustomResourceBundle(false);
            string2 = this.getProperty("localeresourcesextension");
            if (string2 != null) {
                this.bundle.setExtension(string2);
            }
            this.bundle.setBaseURL(this.getDocumentbase());
        }
        this.bundle.getBundle(string);
        if (this.bundle != null) {
            this.font = this.loadFont(this.getResource("font.face"), (int)this.getLong(this.getResource("font.size")));
            this.loadFontUIResource(this.font);
            this.loadUIResources();
            string2 = this.getResource("redirect.paramname");
            if (string2 != null) {
                REDIRECTPARAMNAME = string2;
            }
        }
    }

    public ImageIcon loadIcon(String string) {
        return this.loadIcon(string, INTERNAL);
    }

    public ImageIcon loadIcon(String string, String string2) {
        ImageIcon imageIcon = null;
        if (string != null) {
            URL uRL = null;
            if (string2 != null && string.startsWith(string2)) {
                uRL = this.getClass().getResource("/" + string);
            } else if (this.getDocumentbase() != null) {
                try {
                    uRL = new URL(this.getDocumentbase(), string);
                }
                catch (MalformedURLException malformedURLException) {
                    log.error((Object)malformedURLException);
                }
            } else {
                uRL = this.getClass().getResource("/" + string);
            }
            if (uRL != null) {
                imageIcon = new ImageIcon(uRL);
            }
        }
        return imageIcon;
    }

    public CustomResourceBundle getBundle() {
        return this.bundle;
    }

    public Base64 getBase64() {
        return this.base64;
    }

    public synchronized TransferController getTransferController(String string) {
        String string2;
        int n;
        String string3;
        String string4;
        String string5;
        String string6;
        String string7;
        String string8;
        String string9;
        String string10;
        String string11;
        String string12;
        String string13;
        String string14;
        Object object;
        ArrayList<String> arrayList;
        ArrayList<String> arrayList2;
        Object object2;
        Object object3;
        String string15;
        String string16;
        String string17 = this.getProperty("pbedelimiter");
        if (string17 != null && string17.length() == 2) {
            PBEBEGIN = string17.substring(0, 1);
            PBEEND = string17.substring(1, 2);
        }
        String string18 = this.getProperty("socksproxyhost");
        String string19 = this.getProperty("socksproxyport");
        if (string18 != null) {
            if (string18.equals("")) {
                System.getProperties().remove(SOCKSPROXYHOST);
            } else {
                System.setProperty(SOCKSPROXYHOST, string18);
            }
        }
        if (string19 != null) {
            if (string19.equals("")) {
                System.getProperties().remove(SOCKSPROXYPORT);
            } else {
                System.setProperty(SOCKSPROXYPORT, string19);
            }
        }
        if ((string16 = this.getProperty("resources")) != null) {
            this.loadResources(string16);
        }
        if ((string15 = this.getProperty("preferences")) != null) {
            this.loadPreferences();
        }
        Object object4 = null;
        if (string == null) {
            object4 = HTTPUPLOADMODE;
            object3 = this.getProperty("mode");
            if (object3 != null) {
                object4 = ((String)object3).equalsIgnoreCase("ftp") ? FTPUPLOADMODE : (((String)object3).equalsIgnoreCase("ftps") ? FTPUPLOADMODE : (((String)object3).equalsIgnoreCase("http") ? HTTPUPLOADMODE : (((String)object3).equalsIgnoreCase("https") ? HTTPUPLOADMODE : object3)));
            }
        } else {
            object4 = string;
        }
        object3 = TransferFactory.getInstance();
        TransferController transferController = ((TransferFactory)object3).getTransferController((String)object4);
        transferController.setRawConf(this);
        String string20 = this.getProperty("url");
        if (string20 == null) {
            string20 = this.getResource("url");
        }
        String string21 = this.getProperty("source");
        String string22 = this.getProperty("target");
        String string23 = this.getProperty("ext");
        String string24 = this.getProperty("username");
        String string25 = this.getProperty("password");
        if (string24 == null) {
            string24 = this.getResource("username");
        }
        if (string25 == null) {
            string25 = this.getResource("password");
        }
        String string26 = this.getProperty("tmpfolder");
        String string27 = this.getProperty("whitelist");
        String string28 = this.getProperty("blacklist");
        String string29 = this.getProperty("zipignorelist");
        String string30 = this.getProperty("zipfolder");
        String string31 = this.getProperty("policy");
        String string32 = this.getProperty("hiddenfile");
        String string33 = this.getProperty("ziponfly");
        String string34 = this.getProperty("preprocessingfilter");
        if (string34 != null && string34.equalsIgnoreCase("archiver")) {
            string34 = ARCHIVER;
        }
        String string35 = this.getProperty("filter");
        String string36 = this.getProperty(TEMPLATEFILTER);
        String string37 = this.getProperty("filterchain");
        String string38 = this.getProperty("template");
        String string39 = this.getProperty("templatescope");
        String string40 = this.getProperty("overwrite");
        String string41 = this.getProperty("resume");
        String string42 = this.getProperty("authentication");
        String string43 = this.getProperty("metascope");
        try {
            object2 = this.decodeBase64(this.decodePBE(string20));
            if (object2 != null && ((String)object2).toLowerCase().startsWith("ftps://")) {
                object2 = "ftp://" + ((String)object2).substring(7, ((String)object2).length());
            }
            if (object2 != null && ((String)object2).toLowerCase().startsWith("sftp://")) {
                object2 = "ftp://" + ((String)object2).substring(7, ((String)object2).length());
            }
            if (object2 != null && ((String)object2).toLowerCase().startsWith("scp://")) {
                object2 = "ftp://" + ((String)object2).substring(6, ((String)object2).length());
            }
            arrayList2 = new URL((String)object2);
            transferController.setServerUrl((URL)((Object)arrayList2));
        }
        catch (MalformedURLException malformedURLException) {
            log.error((Object)malformedURLException);
        }
        object2 = new ArrayList();
        if (string22 != null) {
            arrayList2 = new StringTokenizer(string22, ",");
            while (((StringTokenizer)((Object)arrayList2)).hasMoreTokens()) {
                arrayList = ((StringTokenizer)((Object)arrayList2)).nextToken().trim();
                ((ArrayList)object2).add(this.decodeBase64(this.decodePBE((String)((Object)arrayList))));
            }
        } else {
            ((ArrayList)object2).add(this.decodeBase64(this.decodePBE(string20)));
        }
        transferController.setTarget((List)object2);
        arrayList2 = new ArrayList<String>();
        if (string21 != null) {
            arrayList = new StringTokenizer(string21, ",");
            while (((StringTokenizer)((Object)arrayList)).hasMoreTokens()) {
                object = ((StringTokenizer)((Object)arrayList)).nextToken().trim();
                arrayList2.add(this.decodeBase64(this.decodePBE(string20)) + (String)object);
            }
            transferController.setSource(arrayList2);
        }
        transferController.setExt(this.decodeBase64(this.decodePBE(string23)));
        transferController.setUsername(this.decodeBase64(string24));
        transferController.setPassword(this.decodeBase64(string25));
        transferController.setTmpDir(string26);
        transferController.setWhiteList(string27);
        transferController.setBlackList(string28);
        transferController.setZipIgnoreList(string29);
        transferController.setZipFolder(string30);
        transferController.setPolicy(string31);
        transferController.setTemplate(string38);
        transferController.setTemplateScope(string39);
        transferController.setOverwrite(string40);
        transferController.setResume(string41);
        transferController.setAuthentication(string42);
        transferController.setHidden(string32);
        transferController.setZipOnFly(string33);
        transferController.setMetaScope(string43);
        transferController.setPreProcessingFilterImpl(string34);
        transferController.setFilterImpl(string35);
        arrayList = new ArrayList<String>();
        if (string35 != null) {
            arrayList.add("");
        }
        if (string36 != null) {
            object = new StringTokenizer(string36, ",");
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string44;
                string14 = ((StringTokenizer)object).nextToken().trim();
                if (string14 == null || string14.length() <= 0 || (string44 = this.getProperty(string14 + "filter")) == null) continue;
                arrayList.add(string14);
                transferController.setFilterImpl(string44, string14);
            }
        }
        transferController.setFilterIDs(arrayList);
        transferController.setFilterChain(string37);
        object = this.getProperty("threaded");
        if (object != null && ((String)object).equalsIgnoreCase("false")) {
            transferController.setThreaded(false);
        }
        if ((string14 = this.getProperty("maxsize")) != null) {
            long l = this.getLong(string14);
            transferController.setMaxSize(l);
        }
        if ((string13 = this.getProperty("minsize")) != null) {
            long l = this.getLong(string13);
            transferController.setMinSize(l);
        }
        if ((string12 = this.getProperty("fullmaxsize")) != null) {
            long l = this.getLong(string12);
            transferController.setFullMaxSize(l);
        }
        if ((string11 = this.getProperty("maxfiles")) != null) {
            long l = this.getLong(string11);
            transferController.setMaxFiles(l);
        }
        if ((string10 = this.getProperty("folderdepth")) != null) {
            long l = this.getLong(string10);
            transferController.setMaxDepth(l);
        } else {
            transferController.setMaxDepth(0L);
        }
        String string45 = this.getProperty("chunksize");
        if (string45 != null) {
            long l = this.getLong(string45);
            transferController.setChunkSize(l);
        }
        if ((string9 = this.getProperty("timeout")) != null) {
            long l = this.getLong(string9);
            transferController.setTimeOut(l);
        }
        if ((string8 = this.getProperty("retry")) != null) {
            int n2 = (int)this.getLong(string8);
            transferController.setRetry(n2);
        }
        if ((string7 = this.getProperty("retrydelay")) != null) {
            int n3 = (int)this.getLong(string7);
            transferController.setRetryDelay(n3);
        }
        if ((string6 = this.getProperty("zipmaxsize")) != null) {
            long l = this.getLong(string6);
            transferController.setZipMaxSize(l);
        }
        if ((string5 = this.getProperty("identifierinit")) != null) {
            this.identifier = this.getLong(string5);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 1; i <= 16; ++i) {
            string4 = this.getProperty("param" + i);
            string3 = this.getProperty("value" + i);
            if (string4 == null || string3 == null) continue;
            hashMap.put(string4, this.decodeBase64(this.decodePBE(string3)));
        }
        transferController.setParameters(hashMap);
        String string46 = this.getProperty("paramfile");
        if (string46 != null) {
            transferController.setParamFile(string46);
        }
        if ((string4 = this.getProperty("encoding")) != null) {
            transferController.setEncoding(string4);
        }
        try {
            transferController.init();
        }
        catch (ClientException clientException) {
            log.error((Object)clientException);
        }
        string3 = this.getProperty("monitor");
        if (string3 != null && (n = (int)this.getLong(string3)) > 0) {
            this.monitor = new Monitor(transferController, n);
            new Thread(this.monitor).start();
        }
        if (!SAFE && (string2 = this.getProperty("dirmonitor")) != null) {
            int n4 = (int)this.getLong(string2);
            if (n4 > 0) {
                this.dirMonitor = new FolderMonitor(transferController, n4);
                new Thread(this.dirMonitor).start();
            } else if (n4 < 0) {
                this.dirMonitor = new FolderMonitor(transferController, -n4);
            }
        }
        return transferController;
    }

    public FolderMonitor getFolderMonitor() {
        return this.dirMonitor;
    }

    public TransferUI getTransferUI(String string) {
        TransferUI transferUI = null;
        if (string != null) {
            try {
                Class<?> clazz = Class.forName(string);
                Class[] classArray = new Class[]{};
                Constructor<?> constructor = clazz.getConstructor(classArray);
                transferUI = (TransferUI)constructor.newInstance(null);
                log.info((Object)("TransferUI instantiated : " + string));
            }
            catch (Exception exception) {
                log.error((Object)exception);
            }
        }
        return transferUI;
    }

    public TriggeredInputStream getTriggeredInputStream(InputStream inputStream, List list) {
        TriggeredInputStream triggeredInputStream = null;
        String string = this.getProperty("inputstream");
        if (string != null) {
            try {
                Class<?> clazz = Class.forName(string);
                Class[] classArray = new Class[]{class$java$io$InputStream == null ? (class$java$io$InputStream = Conf.class$("java.io.InputStream")) : class$java$io$InputStream, class$java$util$List == null ? (class$java$util$List = Conf.class$("java.util.List")) : class$java$util$List};
                Constructor<?> constructor = clazz.getConstructor(classArray);
                Object[] objectArray = new Object[]{inputStream, list};
                triggeredInputStream = (TriggeredInputStream)constructor.newInstance(objectArray);
                log.debug((Object)("TriggeredInputStream instantiated : " + string));
            }
            catch (Exception exception) {
                log.error((Object)exception);
            }
        } else {
            triggeredInputStream = new TriggeredInputStream(inputStream, list);
        }
        return triggeredInputStream;
    }

    public void freezeUI(Container container, String string) {
        if (string != null) {
            if (string.equalsIgnoreCase("true")) {
                this.freezeUI(container, true, false);
            } else if (string.equalsIgnoreCase("false")) {
                this.freezeUI(container, false, false);
            }
        } else if (this.getProperty("freezeui") != null) {
            if (this.uistatus.isEmpty()) {
                this.freezeUI(container, true, true);
            }
            if (this.getProperty("freezeui").equalsIgnoreCase("true")) {
                this.freezeUI(container, true, false);
            } else if (this.getProperty("freezeui").equalsIgnoreCase("false")) {
                this.freezeUI(container, false, false);
            }
        }
    }

    public void freezeUI(Container container, boolean bl, boolean bl2) {
        if (container != null) {
            Component[] componentArray;
            if (bl2) {
                this.uistatus.put(container, new Boolean(container.isEnabled()));
            } else if (bl) {
                container.setEnabled(false);
            } else {
                componentArray = (Component[])this.uistatus.get(container);
                if (componentArray != null) {
                    container.setEnabled(componentArray.booleanValue());
                }
            }
            componentArray = container.getComponents();
            if (componentArray != null) {
                for (int i = 0; i < componentArray.length; ++i) {
                    if (!(componentArray[i] instanceof Container)) continue;
                    this.freezeUI((Container)componentArray[i], bl, bl2);
                }
            }
        }
    }

    public String decodeBase64(String string) {
        String string2 = null;
        if (string != null) {
            string2 = string.startsWith(BASE64BEGIN) && string.endsWith(BASE64END) && this.getProperty("base64") == null ? (string.startsWith(BASE64BEGIN + BASE64BEGIN) && string.endsWith(BASE64END + BASE64END) ? this.getBase64().decode(string.substring(3, string.length() - 3)) : this.getBase64().decode(string.substring(1, string.length() - 1))) : string;
        }
        return string2;
    }

    public String decodePBE(String string) {
        String string2 = string;
        if (string != null && string.startsWith(PBEBEGIN) && string.endsWith(PBEEND)) {
            string2 = new PBE(this).decipherHexString(string.substring(1, string.length() - 1));
        }
        return string2;
    }

    public String encodeBase64(String string) {
        String string2 = this.getBase64().encodeBase64(string);
        if (string2.endsWith("\r\n")) {
            string2 = string2.substring(0, string2.length() - 2);
        }
        return string2;
    }

    public boolean checkJREVersion(String string) {
        boolean bl = false;
        String string2 = System.getProperty("java.version");
        if (string2 != null && string != null) {
            long l;
            long l2;
            int n;
            string2 = string2.replaceAll("[^0-9]", "");
            string = string.replaceAll("[^0-9]", "");
            int n2 = string2.length() - string.length();
            if (n2 > 0) {
                for (n = 0; n < n2; ++n) {
                    string = string + "0";
                }
            } else if (n2 < 0) {
                for (n = 0; n < -n2; ++n) {
                    string2 = string2 + "0";
                }
            }
            if ((l2 = this.getLong(string2)) >= (l = this.getLong(string))) {
                bl = true;
            } else {
                log.debug((Object)("Current JRE version is " + l2 + ", minimum JRE version required is " + l));
            }
        }
        return bl;
    }

    public URL getCodebase() {
        return this.codebase;
    }

    public void setCodebase(URL uRL) {
        this.codebase = uRL;
    }

    public URL getDocumentbase() {
        return this.documentbase;
    }

    public void setDocumentbase(URL uRL) {
        this.documentbase = uRL;
    }

    public Monitor getMonitor() {
        return this.monitor;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

