/*
 * Decompiled with CFR 0.152.
 */
package jfileupload.upload.client;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.JApplet;
import jfileupload.transfer.client.core.ClientException;
import jfileupload.transfer.client.core.TransferController;
import jfileupload.transfer.client.core.TransferListener;
import jfileupload.transfer.client.core.TransferUI;
import jfileupload.transfer.client.mdesign.InfoPanel;
import jfileupload.transfer.client.mdesign.MenuBar;
import jfileupload.transfer.client.mdesign.ProgressPanel;
import jfileupload.transfer.client.util.Conf;
import jfileupload.transfer.client.util.CustomSM;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MApplet
extends JApplet
implements TransferListener {
    private static final Log log = LogFactory.getLog((Class)(class$jfileupload$upload$client$MApplet == null ? (class$jfileupload$upload$client$MApplet = MApplet.class$("jfileupload.upload.client.MApplet")) : class$jfileupload$upload$client$MApplet));
    protected Conf conf = new Conf(null);
    protected TransferController transfer = null;
    private Properties state = null;
    private String current = null;
    private boolean currentfullfilename = false;
    private boolean jsbase64 = false;
    protected InfoPanel info = null;
    protected ProgressPanel progress = null;
    protected TransferUI ui = null;
    protected TransferUI uihelper = null;
    static /* synthetic */ Class class$jfileupload$upload$client$MApplet;

    public MApplet() {
        log.info((Object)this.getVersion());
    }

    public String getVersion() {
        return "JFileUpload 2.7 Build FINAL.001";
    }

    protected void loadResources() {
        this.conf.loadResources("jfileupload/transfer/client/util/resources");
    }

    public void init() {
        this.conf.setCodebase(this.getCodeBase());
        this.conf.setDocumentbase(this.getDocumentBase());
        this.loadParameters(this.conf.getProperties());
        this.conf.initVerboseMode();
        this.loadResources();
        this.setSM(this.conf.getProperty("sm"));
        this.transfer = this.conf.getTransferController(null);
        this.loadUI(null, this.transfer);
    }

    protected void setSM(String string) {
        if (string != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            if (string.equalsIgnoreCase("enabled")) {
                arrayList.add("A:/");
            } else {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken().trim();
                    arrayList.add(string2);
                }
            }
            try {
                log.info((Object)"CustomSM enabled");
                System.setSecurityManager(new CustomSM(arrayList));
            }
            catch (AccessControlException accessControlException) {
                log.error((Object)accessControlException);
            }
        }
    }

    public String getExtra(String string) {
        return (String)this.transfer.getParameters("dynamic").get(string);
    }

    public void setExtra(String string, String string2) {
        this.setParameter(string, string2);
    }

    public void setParameter(String string, String string2) {
        if (string != null && string2 != null) {
            if (string.equalsIgnoreCase("jsfullfilename")) {
                this.currentfullfilename = string2.equalsIgnoreCase("true");
            } else if (string.equalsIgnoreCase("jsbase64")) {
                this.jsbase64 = string2.equalsIgnoreCase("true");
            } else {
                log.debug((Object)("setParameter('" + string + "','" + string2 + "')"));
                if (this.jsbase64) {
                    this.transfer.getParameters("dynamic").put(string, this.conf.encodeBase64(string2));
                } else {
                    this.transfer.getParameters("dynamic").put(string, string2);
                }
            }
        }
    }

    public String getRegular(String string) {
        return (String)this.conf.getProperties().get(string);
    }

    public void setRegular(String string, String string2) {
        this.setProperty(string, string2);
    }

    public void setProperty(String string, String string2) {
        if (string != null && string2 != null) {
            log.debug((Object)("setProperty('" + string + "','" + string2 + "')"));
            this.conf.getProperties().put(string, string2);
            if (string.equalsIgnoreCase("freezeui")) {
                this.conf.freezeUI(this.getRootPane(), string2);
                if (this.info != null) {
                    if (string2.equalsIgnoreCase("true")) {
                        this.info.setLock(true);
                    } else {
                        this.info.setLock(false);
                    }
                }
            }
        }
    }

    public String getState(String string) {
        String string2 = "";
        if (this.state != null && string != null && string.length() > 0 && (string2 = this.state.getProperty(string)) == null) {
            string2 = "";
        }
        return string2;
    }

    public String getFilenames() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.state != null) {
            Iterator<Object> iterator = this.state.keySet().iterator();
            while (iterator.hasNext()) {
                stringBuffer.append((String)iterator.next());
                if (!iterator.hasNext()) continue;
                stringBuffer.append("|");
            }
        }
        return stringBuffer.toString();
    }

    public void cancel() {
        if (this.transfer != null) {
            this.transfer.cancel();
        }
    }

    public void loadParameters(Properties properties) {
        String string;
        String string2;
        Object object;
        for (int i = 0; i < Conf.PARAMS.length; ++i) {
            object = this.getParameter(Conf.PARAMS[i]);
            if (object == null) continue;
            properties.setProperty(Conf.PARAMS[i], this.conf.decodeBase64((String)object));
        }
        String string3 = this.getParameter(Conf.TEMPLATEFILTER);
        if (string3 != null) {
            object = new StringTokenizer(string3, ",");
            while (((StringTokenizer)object).hasMoreTokens()) {
                string2 = ((StringTokenizer)object).nextToken().trim();
                if (string2 == null || string2.length() <= 0) continue;
                for (int i = 0; i < Conf.TEMPLATEFILTERPARAMS.length; ++i) {
                    String string4 = this.getParameter(string2 + Conf.TEMPLATEFILTERPARAMS[i]);
                    if (string4 == null) continue;
                    properties.setProperty(string2 + Conf.TEMPLATEFILTERPARAMS[i], this.conf.decodeBase64(string4));
                }
            }
        }
        int n = 1;
        while ((string = this.getParameter(string2 = Conf.TEMPLATEITEM + n)) != null) {
            properties.setProperty(string2, this.conf.decodeBase64(string));
            ++n;
        }
    }

    public void loadUI(Locale locale, TransferController transferController) {
        this.progress = null;
        this.info = null;
        MenuBar menuBar = null;
        this.ui = null;
        this.uihelper = null;
        if (transferController != null) {
            transferController.setParentContainer(this);
        }
        if (this.conf.getProperty("transferui") != null) {
            this.ui = this.conf.getTransferUI(this.conf.getProperty("transferui"));
        }
        if (this.ui != null && this.ui.init(this, this.conf, transferController)) {
            this.conf.getShared().put("transferui", this.ui);
            String string = this.conf.getProperty("hidebar");
            if (string != null && string.equalsIgnoreCase("false")) {
                menuBar = new MenuBar(this.conf);
                transferController.addTransferListener(menuBar);
                transferController.addFilterListener(menuBar);
                menuBar.setController(transferController);
                this.setJMenuBar(menuBar);
            }
        } else {
            this.getContentPane().setLayout(new BorderLayout());
            this.progress = new ProgressPanel(this.conf);
            transferController.addTransferListener(this.progress);
            transferController.addSplitListener(this.progress);
            transferController.addCompressListener(this.progress);
            transferController.addFilterListener(this.progress);
            transferController.addChecksumListener(this.progress);
            this.progress.setController(transferController);
            this.info = new InfoPanel(this.conf);
            transferController.addTransferListener(this.info);
            transferController.addSplitListener(this.info);
            transferController.addCompressListener(this.info);
            transferController.addFilterListener(this.info);
            transferController.addProtocolListener(this.info);
            this.info.setController(transferController);
            String string = this.conf.getProperty("hidebar");
            if (string != null && string.equalsIgnoreCase("true")) {
                log.debug((Object)"Menu bar hidden");
            } else {
                menuBar = new MenuBar(this.conf);
                transferController.addTransferListener(menuBar);
                transferController.addFilterListener(menuBar);
                menuBar.setController(transferController);
                this.setJMenuBar(menuBar);
            }
            String string2 = this.conf.getProperty("hideinfo");
            if (string2 != null && string2.equalsIgnoreCase("true")) {
                log.debug((Object)"Info panel hidden");
                this.getContentPane().add((Component)this.progress, "South");
            } else {
                this.getContentPane().add((Component)this.info, "Center");
                this.getContentPane().add((Component)this.progress, "South");
            }
        }
        if (this.conf.getProperty("uihelper") != null) {
            this.uihelper = this.conf.getTransferUI(this.conf.getProperty("uihelper"));
        }
        if (this.uihelper != null) {
            this.uihelper.init(this, this.conf, transferController);
            this.conf.getShared().put("uihelper", this.uihelper);
        }
        transferController.addTransferListener(this);
        this.setVisible(true);
        this.conf.freezeUI(this.getRootPane(), null);
        if (this.conf.getProperty("freezeui") != null && this.info != null) {
            if (this.conf.getProperty("freezeui").equalsIgnoreCase("true")) {
                this.info.setLock(true);
            } else {
                this.info.setLock(false);
            }
        }
    }

    public void start() {
        String string;
        super.start();
        if (this.ui != null) {
            this.ui.start();
        }
        if (this.uihelper != null) {
            this.uihelper.start();
        }
        if ((string = this.conf.getProperty("mjv")) != null) {
            String string2;
            String string3 = "";
            String string4 = "mac";
            String string5 = this.conf.getProperty("mjv" + string4);
            if (string5 != null && (string2 = System.getProperty("os.name")) != null && string2.toLowerCase().indexOf(string4) > -1) {
                string = string5;
                string3 = string4;
            }
            this.checkJREVersion(string, string3);
        }
    }

    public void stop() {
        super.stop();
        if (this.ui != null) {
            this.ui.stop();
        }
        if (this.uihelper != null) {
            this.uihelper.stop();
        }
        if (this.conf != null) {
            String string = this.conf.getProperty("cancelonstop");
            if (string != null && string.equalsIgnoreCase("true") && this.transfer != null) {
                this.transfer.cancel();
            }
            if (this.conf.getProperty("preferences") != null) {
                this.conf.savePreferences();
            }
        }
    }

    public void redirect(String string, String string2, String string3) {
        if (string != null && !string.equals("")) {
            try {
                log.info((Object)"Forwarding");
                if (string3 != null) {
                    string = string + string3;
                }
                URL uRL = new URL(this.getDocumentBase(), string);
                if (string2 != null) {
                    this.getAppletContext().showDocument(uRL, string2);
                } else {
                    this.getAppletContext().showDocument(uRL);
                }
            }
            catch (MalformedURLException malformedURLException) {
                log.info((Object)malformedURLException);
            }
        }
    }

    private void checkJREVersion(String string, String string2) {
        String string3 = this.conf.getProperty("mjvforward" + string2);
        if (!this.conf.checkJREVersion(string) && string3 != null) {
            this.redirect(string3, this.conf.getProperty("mjvforwardtarget" + string2), null);
        }
    }

    public void transferTriggered(List list, int n) {
        if (list != null && list.size() > 0 && n == 1) {
            this.state = new Properties();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof File)) continue;
                File file = (File)e;
                if (!this.currentfullfilename) {
                    this.state.setProperty(file.getName(), "WAITING");
                    continue;
                }
                this.state.setProperty(file.getAbsolutePath(), "WAITING");
            }
        }
    }

    public void transferStarted(Object object, long l) {
        if (this.state != null && object != null && object instanceof File) {
            File file = (File)object;
            this.current = !this.currentfullfilename ? file.getName() : file.getAbsolutePath();
            this.state.setProperty(this.current, "INPROGRESS");
        }
    }

    public void dataRead(long l) {
    }

    public void transferCompleted(Object object, byte[] byArray) {
        if (this.state != null && object != null && object instanceof File && this.current != null) {
            this.state.setProperty(this.current, "COMPLETED");
        }
        this.sendStatus(object, "completed");
    }

    public void transferCancelled() {
        if (this.current != null) {
            this.state.setProperty(this.current, "CANCELLED");
        }
    }

    public void transferFailed(ClientException clientException) {
        if (this.current != null) {
            this.state.setProperty(this.current, "FAILED");
        }
    }

    public void transferDone(List list) {
        String string;
        String string2;
        String string3;
        String string4 = this.conf.getProperty("post");
        if (string4 != null && !string4.equals("")) {
            string3 = this.conf.getProperty("postparameters");
            string2 = null;
            string = this.transfer.getMetaScope();
            if (string != null && string.equalsIgnoreCase("post")) {
                string2 = this.buildMetaProperties(string2);
            }
            string3 = this.formatParameters(string3, list, string2);
            this.post(string4, string3);
        }
        string3 = this.conf.getProperty("forward");
        string2 = this.conf.getProperty("forwardtarget");
        string = this.conf.getProperty("forwardparameters");
        String string5 = null;
        String string6 = this.transfer.getMetaScope();
        if (string6 != null && string6.equalsIgnoreCase("forward")) {
            string5 = this.buildMetaProperties(string5);
        }
        if ((string = this.formatParameters(string, list, string5)) != null && !string.equals("")) {
            int n = string3.indexOf("?");
            string = n != -1 ? "&" + string : "?" + string;
        }
        this.redirect(string3, string2, string);
    }

    public String formatParameters(String string, List list, String string2) {
        String string3 = null;
        if (string != null) {
            if (string.equalsIgnoreCase("true")) {
                if (list != null && !list.isEmpty()) {
                    String string4 = "";
                    string3 = "";
                    int n = 0;
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        File file = (File)iterator.next();
                        string3 = string3 + string4 + Conf.REDIRECTPARAMNAME + ++n + "=" + this.encode(file.getName());
                        string4 = "&";
                    }
                }
            } else if (string.equalsIgnoreCase("long")) {
                if (list != null && !list.isEmpty()) {
                    String string5 = "";
                    string3 = "";
                    int n = 0;
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        File file = (File)iterator.next();
                        string3 = string3 + string5 + Conf.REDIRECTPARAMNAME + ++n + "=" + this.encode(file.getAbsolutePath());
                        string5 = "&";
                    }
                }
            } else if (string.equalsIgnoreCase("longer")) {
                if (list != null && !list.isEmpty()) {
                    String string6 = "";
                    string3 = "";
                    int n = 0;
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        File file = (File)iterator.next();
                        string3 = string3 + string6 + Conf.REDIRECTPARAMNAME + ++n + "=" + this.encode(file.getAbsolutePath());
                        string6 = "&";
                        string3 = string3 + string6 + Conf.SIZEPARAMNAME + n + "=" + this.encode(String.valueOf(file.length()));
                    }
                }
            } else if (string.startsWith("extra")) {
                String string7;
                Object object;
                Iterator<Object> iterator;
                String string8 = "";
                if (list != null && !list.isEmpty()) {
                    string3 = "";
                    int n = 0;
                    iterator = list.iterator();
                    while (iterator.hasNext()) {
                        object = (File)iterator.next();
                        string7 = "";
                        string7 = string.equalsIgnoreCase("extrarelative") ? ((File)object).getPath() : ((File)object).getAbsolutePath();
                        string3 = string3 + string8 + Conf.REDIRECTPARAMNAME + ++n + "=" + this.encode(string7);
                        string8 = "&";
                        if (!string.equalsIgnoreCase("extra")) continue;
                        string3 = string3 + string8 + Conf.SIZEPARAMNAME + n + "=" + this.encode(String.valueOf(((File)object).length())) + string8 + Conf.DATEPARAMNAME + n + "=" + this.encode(String.valueOf(((File)object).lastModified()));
                    }
                }
                HashMap hashMap = this.transfer.getParameters("dynamic");
                iterator = hashMap.keySet().iterator();
                while (iterator.hasNext()) {
                    object = (String)iterator.next();
                    string7 = (String)hashMap.get(object);
                    string3 = string3 + string8 + (String)object + "=" + this.encode(string7);
                }
            } else if (string.equalsIgnoreCase("short")) {
                if (list != null && !list.isEmpty()) {
                    String string9 = Conf.REDIRECTPARAMNAME + "=";
                    string3 = "";
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        File file = (File)iterator.next();
                        string3 = string3 + string9 + this.encode(file.getName());
                        string9 = ";";
                    }
                }
            } else if (string.equalsIgnoreCase("false")) {
                string3 = "";
            }
            if (string2 != null && !string2.equals("")) {
                string3 = string3 != null && string3.length() > 0 ? string3 + "&" + string2 : string2;
            }
        }
        return string3;
    }

    public String encode(String string) {
        String string2 = null;
        String string3 = null;
        if (this.transfer != null) {
            string2 = this.transfer.getEncoding();
        }
        String string4 = this.conf.getProperty("encoder");
        String string5 = System.getProperty("java.version");
        if (string4 != null && string4.equalsIgnoreCase("simple") || string5 != null && string5.startsWith("1.3")) {
            string3 = URLEncoder.encode(string);
            StringTokenizer stringTokenizer = new StringTokenizer(string3, "+");
            String string6 = "";
            if (stringTokenizer.hasMoreTokens()) {
                int n = stringTokenizer.countTokens();
                for (int i = 0; i < n; ++i) {
                    String string7 = stringTokenizer.nextToken();
                    string6 = i + 1 == n ? string6 + string7 : string6 + string7 + "%20";
                }
            } else {
                string6 = string3;
            }
            return string6;
        }
        if (string2 == null) {
            string3 = URLEncoder.encode(string);
        } else {
            try {
                string3 = URLEncoder.encode(string, string2);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                log.error((Object)"Cannot encode URL", (Throwable)unsupportedEncodingException);
            }
        }
        String string8 = string3.replaceAll("[+]", "%20");
        return string8;
    }

    protected void post(String string, String string2) {
        try {
            CharSequence charSequence;
            Object object;
            Object object2;
            log.info((Object)"Posting");
            URL uRL = new URL(string);
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setUseCaches(false);
            uRLConnection.setDoOutput(true);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintWriter printWriter = null;
            String string3 = this.conf.getProperty("encoding");
            printWriter = string3 == null ? new PrintWriter(byteArrayOutputStream, true) : new PrintWriter((Writer)new OutputStreamWriter((OutputStream)byteArrayOutputStream, string3), true);
            if (string2 != null) {
                printWriter.print(string2);
            }
            printWriter.flush();
            String string4 = String.valueOf(byteArrayOutputStream.size());
            uRLConnection.setRequestProperty("Content-Length", string4);
            uRLConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            String string5 = this.transfer.getUsername();
            String string6 = this.transfer.getPassword();
            if (string5 != null && string6 != null) {
                object2 = string5 + ":" + string6;
                object2 = this.conf.getBase64().encodeBase64((String)object2);
                if (((String)object2).endsWith("\r\n")) {
                    object2 = ((String)object2).substring(0, ((String)object2).length() - 2);
                }
                uRLConnection.setRequestProperty("Authorization", "Basic " + (String)object2);
            }
            if ((object2 = this.transfer.getParameters(null)) != null) {
                object = "";
                int n = 1;
                while (true) {
                    charSequence = (String)((HashMap)object2).get("cookiename" + (String)object);
                    String string7 = (String)((HashMap)object2).get("cookievalue" + (String)object);
                    if (charSequence == null || string7 == null) break;
                    uRLConnection.addRequestProperty("Cookie", (String)charSequence + "=" + string7);
                    object = String.valueOf(n++);
                }
            }
            byteArrayOutputStream.writeTo(uRLConnection.getOutputStream());
            object = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
            String string8 = null;
            charSequence = new StringBuffer();
            while ((string8 = ((BufferedReader)object).readLine()) != null) {
                ((StringBuffer)charSequence).append(string8).append(Conf.CR);
            }
            log.debug((Object)((StringBuffer)charSequence).toString());
            ((BufferedReader)object).close();
        }
        catch (MalformedURLException malformedURLException) {
            log.error((Object)malformedURLException);
        }
        catch (IOException iOException) {
            log.error((Object)iOException);
        }
    }

    protected void sendStatus(Object object, String string) {
        String string2 = this.conf.getProperty("status");
        if (string2 != null && !string2.equals("")) {
            log.debug((Object)("Send status : " + string));
            String string3 = this.conf.getProperty("statusparameters");
            ArrayList<Object> arrayList = new ArrayList<Object>(1);
            arrayList.add(object);
            String string4 = Conf.STATUSPARAMNAME + "=" + string;
            String string5 = this.transfer.getMetaScope();
            if (string5 != null && string5.equalsIgnoreCase("status")) {
                string4 = this.buildMetaProperties(string4);
            }
            string3 = this.formatParameters(string3, arrayList, string4);
            this.post(string2, string3);
        }
    }

    protected String buildMetaProperties(String string) {
        String string2 = string;
        HashMap hashMap = this.transfer.getMetaProperties();
        if (hashMap != null) {
            if (string2 == null) {
                string2 = "";
            }
            Iterator iterator = hashMap.keySet().iterator();
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                String string4 = (String)hashMap.get(string3);
                string2 = string2 + "&" + string3 + "=" + this.encode(string4);
            }
        }
        return string2;
    }

    public void notifyJS(String string, List list, String string2) {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

