/*
 * Decompiled with CFR 0.152.
 */
package jfileupload.upload.client;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import jfileupload.transfer.client.core.ClientException;
import jfileupload.transfer.client.core.TransferController;
import jfileupload.transfer.client.core.TransferListener;
import jfileupload.transfer.client.core.TransferUI;
import jfileupload.transfer.client.mdesign.InfoPanel;
import jfileupload.transfer.client.mdesign.MenuBar;
import jfileupload.transfer.client.mdesign.ProgressPanel;
import jfileupload.transfer.client.util.Conf;
import jfileupload.transfer.client.util.CustomSM;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MApplication
extends JFrame
implements TransferListener {
    private static final Log log = LogFactory.getLog((Class)(class$jfileupload$upload$client$MApplication == null ? (class$jfileupload$upload$client$MApplication = MApplication.class$("jfileupload.upload.client.MApplication")) : class$jfileupload$upload$client$MApplication));
    private Conf conf = new Conf(null);
    private String[] args = null;
    protected TransferController transfer = null;
    protected TransferUI ui = null;
    protected TransferUI uihelper = null;
    static /* synthetic */ Class class$jfileupload$upload$client$MApplication;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$net$URL;

    public MApplication(String[] stringArray) {
        log.info((Object)"JFileUpload 2.7 Build FINAL.001");
        this.args = stringArray;
    }

    protected void loadResources() {
        this.conf.loadResources("jfileupload/transfer/client/util/resources");
    }

    public void init() {
        this.loadParameters(this.conf.getProperties());
        this.conf.initVerboseMode();
        this.loadResources();
        this.setSM(this.conf.getProperty("sm"));
        this.transfer = this.conf.getTransferController(null);
        this.loadUI(null, this.transfer);
    }

    protected void setSM(String string) {
        if (string != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            if (string.equalsIgnoreCase("enabled")) {
                arrayList.add("A:/");
            } else {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken().trim();
                    arrayList.add(string2);
                }
            }
            try {
                log.info((Object)"CustomSM enabled");
                System.setSecurityManager(new CustomSM(arrayList));
            }
            catch (AccessControlException accessControlException) {
                log.error((Object)accessControlException);
            }
        }
    }

    public void loadParameters(Properties properties) {
        String string;
        String string2;
        Object object;
        for (int i = 0; i < Conf.PARAMS.length; ++i) {
            object = this.getParameter(Conf.PARAMS[i]);
            if (object == null) continue;
            properties.setProperty(Conf.PARAMS[i], this.conf.decodeBase64((String)object));
        }
        String string3 = this.getParameter(Conf.TEMPLATEFILTER);
        if (string3 != null) {
            object = new StringTokenizer(string3, ",");
            while (((StringTokenizer)object).hasMoreTokens()) {
                string2 = ((StringTokenizer)object).nextToken().trim();
                if (string2 == null || string2.length() <= 0) continue;
                for (int i = 0; i < Conf.TEMPLATEFILTERPARAMS.length; ++i) {
                    String string4 = this.getParameter(string2 + Conf.TEMPLATEFILTERPARAMS[i]);
                    if (string4 == null) continue;
                    properties.setProperty(string2 + Conf.TEMPLATEFILTERPARAMS[i], this.conf.decodeBase64(string4));
                }
            }
        }
        int n = 1;
        while ((string = this.getParameter(string2 = Conf.TEMPLATEITEM + n)) != null) {
            properties.setProperty(string2, this.conf.decodeBase64(string));
            ++n;
        }
    }

    public String getParameter(String string) {
        String string2 = "-" + string;
        String string3 = null;
        if (this.args != null) {
            for (int i = 0; i < this.args.length; ++i) {
                if (!this.args[i].equalsIgnoreCase(string2) || i >= this.args.length) continue;
                string3 = this.args[i + 1];
                break;
            }
        }
        return string3;
    }

    public void loadUI(Locale locale, TransferController transferController) {
        String string;
        ProgressPanel progressPanel = null;
        InfoPanel infoPanel = null;
        MenuBar menuBar = null;
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                MApplication.this.stopApplication();
                System.exit(0);
            }
        });
        int n = (int)this.conf.getLong(this.conf.getProperty("width"));
        int n2 = (int)this.conf.getLong(this.conf.getProperty("height"));
        if (n < 0) {
            n = 250;
        }
        if (n2 < 0) {
            n2 = 250;
        }
        this.setSize(n, n2);
        String string2 = this.conf.getResource("frame.title");
        if (string2 == null) {
            string2 = "JFileUpload 2.7";
        }
        this.setTitle(string2);
        ImageIcon imageIcon = this.conf.loadIcon(this.conf.getResource("frame.icon"));
        if (imageIcon != null) {
            this.setIconImage(imageIcon.getImage());
        }
        transferController.addTransferListener(this);
        this.ui = null;
        this.uihelper = null;
        if (transferController != null) {
            transferController.setParentContainer(this);
        }
        if (this.conf.getProperty("transferui") != null) {
            this.ui = this.conf.getTransferUI(this.conf.getProperty("transferui"));
        }
        if (this.ui != null && this.ui.init(this, this.conf, transferController)) {
            this.conf.getShared().put("transferui", this.ui);
            string = this.conf.getProperty("hidebar");
            if (string != null && string.equalsIgnoreCase("false")) {
                menuBar = new MenuBar(this.conf);
                transferController.addTransferListener(menuBar);
                transferController.addFilterListener(menuBar);
                menuBar.setController(transferController);
                this.setJMenuBar(menuBar);
            }
        } else {
            this.getContentPane().setLayout(new BorderLayout());
            progressPanel = new ProgressPanel(this.conf);
            transferController.addTransferListener(progressPanel);
            transferController.addSplitListener(progressPanel);
            transferController.addCompressListener(progressPanel);
            transferController.addFilterListener(progressPanel);
            transferController.addChecksumListener(progressPanel);
            progressPanel.setController(transferController);
            infoPanel = new InfoPanel(this.conf);
            transferController.addTransferListener(infoPanel);
            transferController.addSplitListener(infoPanel);
            transferController.addCompressListener(infoPanel);
            transferController.addFilterListener(infoPanel);
            transferController.addProtocolListener(infoPanel);
            infoPanel.setController(transferController);
            string = this.conf.getProperty("hidebar");
            if (string != null && string.equalsIgnoreCase("true")) {
                log.debug((Object)"Menu bar hidden");
            } else {
                menuBar = new MenuBar(this.conf);
                transferController.addTransferListener(menuBar);
                transferController.addFilterListener(menuBar);
                menuBar.setController(transferController);
                this.setJMenuBar(menuBar);
            }
            String string3 = this.conf.getProperty("hideinfo");
            if (string3 != null && string3.equalsIgnoreCase("true")) {
                log.debug((Object)"Info panel hidden");
                this.getContentPane().add((Component)progressPanel, "South");
            } else {
                this.getContentPane().add((Component)infoPanel, "Center");
                this.getContentPane().add((Component)progressPanel, "South");
            }
        }
        if (this.conf.getProperty("uihelper") != null) {
            this.uihelper = this.conf.getTransferUI(this.conf.getProperty("uihelper"));
        }
        if (this.uihelper != null) {
            this.uihelper.init(this, this.conf, transferController);
            this.conf.getShared().put("uihelper", this.uihelper);
        }
        if (this.conf.getProperty("preferences") != null) {
            int n3 = (int)this.conf.getLong(this.conf.getPreferences().getProperty("location.x"));
            int n4 = (int)this.conf.getLong(this.conf.getPreferences().getProperty("location.y"));
            if (n3 > 0 && n4 > 0) {
                this.setLocation(n3, n4);
            }
        }
        this.setVisible(true);
        this.conf.freezeUI(this.getRootPane(), null);
        if (this.conf.getProperty("freezeui") != null && infoPanel != null) {
            if (this.conf.getProperty("freezeui").equalsIgnoreCase("true")) {
                infoPanel.setLock(true);
            } else {
                infoPanel.setLock(false);
            }
        }
        if (this.ui != null) {
            this.ui.start();
        }
    }

    protected void stopApplication() {
        if (this.ui != null) {
            this.ui.stop();
        }
        if (this.uihelper != null) {
            this.uihelper.stop();
        }
        if (this.conf != null) {
            String string = this.conf.getProperty("cancelonstop");
            if (string != null && string.equalsIgnoreCase("true") && this.transfer != null) {
                this.transfer.cancel();
            }
            if (this.conf.getProperty("preferences") != null) {
                this.conf.getPreferences().setProperty("location.x", String.valueOf(this.getLocation().x));
                this.conf.getPreferences().setProperty("location.y", String.valueOf(this.getLocation().y));
                this.conf.savePreferences();
            }
        }
    }

    public void transferTriggered(List list, int n) {
    }

    public void transferStarted(Object object, long l) {
    }

    public void dataRead(long l) {
    }

    public void transferCompleted(Object object, byte[] byArray) {
        this.sendStatus(object, "completed");
    }

    public void transferCancelled() {
    }

    public void transferFailed(ClientException clientException) {
    }

    public void transferDone(List list) {
        String string;
        String string2;
        String string3;
        String string4 = this.conf.getProperty("post");
        if (string4 != null && !string4.equals("")) {
            string3 = this.conf.getProperty("postparameters");
            string2 = null;
            string = this.transfer.getMetaScope();
            if (string != null && string.equalsIgnoreCase("post")) {
                string2 = this.buildMetaProperties(string2);
            }
            string3 = this.formatParameters(string3, list, string2);
            this.post(string4, string3);
        }
        string3 = this.conf.getProperty("forward");
        string2 = this.conf.getProperty("forwardparameters");
        string = null;
        String string5 = this.transfer.getMetaScope();
        if (string5 != null && string5.equalsIgnoreCase("forward")) {
            string = this.buildMetaProperties(string);
        }
        if ((string2 = this.formatParameters(string2, list, string)) != null && !string2.equals("")) {
            int n = string3.indexOf("?");
            string2 = n != -1 ? "&" + string2 : "?" + string2;
        }
        this.redirect(string3, null, string2);
    }

    public void redirect(String string, String string2, String string3) {
        if (string != null && !string.equals("")) {
            try {
                log.info((Object)"Forwarding");
                if (string3 != null) {
                    string = string + string3;
                }
                URL uRL = new URL(string);
                Class<?> clazz = Class.forName("javax.jnlp.ServiceManager");
                Class[] classArray = new Class[]{class$java$lang$String == null ? (class$java$lang$String = MApplication.class$("java.lang.String")) : class$java$lang$String};
                Method method = clazz.getMethod("lookup", classArray);
                Object object = method.invoke(null, "javax.jnlp.BasicService");
                classArray[0] = class$java$net$URL == null ? (class$java$net$URL = MApplication.class$("java.net.URL")) : class$java$net$URL;
                method = object.getClass().getMethod("showDocument", classArray);
                method.invoke(object, uRL);
            }
            catch (Exception exception) {
                log.error((Object)exception);
            }
        }
    }

    public String formatParameters(String string, List list, String string2) {
        String string3 = null;
        if (string != null) {
            if (string.equalsIgnoreCase("true")) {
                if (list != null && !list.isEmpty()) {
                    String string4 = "";
                    string3 = "";
                    int n = 0;
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        File file = (File)iterator.next();
                        string3 = string3 + string4 + Conf.REDIRECTPARAMNAME + ++n + "=" + this.encode(file.getName());
                        string4 = "&";
                    }
                }
            } else if (string.equalsIgnoreCase("long")) {
                if (list != null && !list.isEmpty()) {
                    String string5 = "";
                    string3 = "";
                    int n = 0;
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        File file = (File)iterator.next();
                        string3 = string3 + string5 + Conf.REDIRECTPARAMNAME + ++n + "=" + this.encode(file.getAbsolutePath());
                        string5 = "&";
                    }
                }
            } else if (string.equalsIgnoreCase("longer")) {
                if (list != null && !list.isEmpty()) {
                    String string6 = "";
                    string3 = "";
                    int n = 0;
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        File file = (File)iterator.next();
                        string3 = string3 + string6 + Conf.REDIRECTPARAMNAME + ++n + "=" + this.encode(file.getAbsolutePath());
                        string6 = "&";
                        string3 = string3 + string6 + Conf.SIZEPARAMNAME + n + "=" + this.encode(String.valueOf(file.length()));
                    }
                }
            } else if (string.startsWith("extra")) {
                String string7;
                Object object;
                Iterator<Object> iterator;
                String string8 = "";
                if (list != null && !list.isEmpty()) {
                    string3 = "";
                    int n = 0;
                    iterator = list.iterator();
                    while (iterator.hasNext()) {
                        object = (File)iterator.next();
                        string7 = "";
                        string7 = string.equalsIgnoreCase("extrarelative") ? ((File)object).getPath() : ((File)object).getAbsolutePath();
                        string3 = string3 + string8 + Conf.REDIRECTPARAMNAME + ++n + "=" + this.encode(string7);
                        string8 = "&";
                        if (!string.equalsIgnoreCase("extra")) continue;
                        string3 = string3 + string8 + Conf.SIZEPARAMNAME + n + "=" + this.encode(String.valueOf(((File)object).length())) + string8 + Conf.DATEPARAMNAME + n + "=" + this.encode(String.valueOf(((File)object).lastModified()));
                    }
                }
                HashMap hashMap = this.transfer.getParameters("dynamic");
                iterator = hashMap.keySet().iterator();
                while (iterator.hasNext()) {
                    object = (String)iterator.next();
                    string7 = (String)hashMap.get(object);
                    string3 = string3 + string8 + (String)object + "=" + this.encode(string7);
                }
            } else if (string.equalsIgnoreCase("short")) {
                if (list != null && !list.isEmpty()) {
                    String string9 = Conf.REDIRECTPARAMNAME + "=";
                    string3 = "";
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        File file = (File)iterator.next();
                        string3 = string3 + string9 + this.encode(file.getName());
                        string9 = ";";
                    }
                }
            } else if (string.equalsIgnoreCase("false")) {
                string3 = "";
            }
            if (string2 != null && !string2.equals("")) {
                string3 = string3 != null && string3.length() > 0 ? string3 + "&" + string2 : string2;
            }
        }
        return string3;
    }

    public String encode(String string) {
        String string2 = null;
        String string3 = null;
        if (this.transfer != null) {
            string2 = this.transfer.getEncoding();
        }
        String string4 = this.conf.getProperty("encoder");
        String string5 = System.getProperty("java.version");
        if (string4 != null && string4.equalsIgnoreCase("simple") || string5 != null && string5.startsWith("1.3")) {
            string3 = URLEncoder.encode(string);
            StringTokenizer stringTokenizer = new StringTokenizer(string3, "+");
            String string6 = "";
            if (stringTokenizer.hasMoreTokens()) {
                int n = stringTokenizer.countTokens();
                for (int i = 0; i < n; ++i) {
                    String string7 = stringTokenizer.nextToken();
                    string6 = i + 1 == n ? string6 + string7 : string6 + string7 + "%20";
                }
            } else {
                string6 = string3;
            }
            return string6;
        }
        if (string2 == null) {
            string3 = URLEncoder.encode(string);
        } else {
            try {
                string3 = URLEncoder.encode(string, string2);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                log.error((Object)"Cannot encode URL", (Throwable)unsupportedEncodingException);
            }
        }
        String string8 = string3.replaceAll("[+]", "%20");
        return string8;
    }

    public void post(String string, String string2) {
        try {
            CharSequence charSequence;
            Object object;
            Object object2;
            log.info((Object)"Posting");
            URL uRL = new URL(string);
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setUseCaches(false);
            uRLConnection.setDoOutput(true);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintWriter printWriter = null;
            String string3 = this.conf.getProperty("encoding");
            printWriter = string3 == null ? new PrintWriter(byteArrayOutputStream, true) : new PrintWriter((Writer)new OutputStreamWriter((OutputStream)byteArrayOutputStream, string3), true);
            if (string2 != null) {
                printWriter.print(string2);
            }
            printWriter.flush();
            String string4 = String.valueOf(byteArrayOutputStream.size());
            uRLConnection.setRequestProperty("Content-Length", string4);
            uRLConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            String string5 = this.transfer.getUsername();
            String string6 = this.transfer.getPassword();
            if (string5 != null && string6 != null) {
                object2 = string5 + ":" + string6;
                object2 = this.conf.getBase64().encodeBase64((String)object2);
                if (((String)object2).endsWith("\r\n")) {
                    object2 = ((String)object2).substring(0, ((String)object2).length() - 2);
                }
                uRLConnection.setRequestProperty("Authorization", "Basic " + (String)object2);
            }
            if ((object2 = this.transfer.getParameters(null)) != null) {
                object = "";
                int n = 1;
                while (true) {
                    charSequence = (String)((HashMap)object2).get("cookiename" + (String)object);
                    String string7 = (String)((HashMap)object2).get("cookievalue" + (String)object);
                    if (charSequence == null || string7 == null) break;
                    uRLConnection.addRequestProperty("Cookie", (String)charSequence + "=" + string7);
                    object = String.valueOf(n++);
                }
            }
            byteArrayOutputStream.writeTo(uRLConnection.getOutputStream());
            object = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
            String string8 = null;
            charSequence = new StringBuffer();
            while ((string8 = ((BufferedReader)object).readLine()) != null) {
                ((StringBuffer)charSequence).append(string8).append(Conf.CR);
            }
            log.debug((Object)((StringBuffer)charSequence).toString());
            ((BufferedReader)object).close();
        }
        catch (MalformedURLException malformedURLException) {
            log.error((Object)malformedURLException);
        }
        catch (IOException iOException) {
            log.error((Object)iOException);
        }
    }

    protected void sendStatus(Object object, String string) {
        String string2 = this.conf.getProperty("status");
        if (string2 != null && !string2.equals("")) {
            log.debug((Object)("Send status : " + string));
            String string3 = this.conf.getProperty("statusparameters");
            ArrayList<Object> arrayList = new ArrayList<Object>(1);
            arrayList.add(object);
            String string4 = Conf.STATUSPARAMNAME + "=" + string;
            String string5 = this.transfer.getMetaScope();
            if (string5 != null && string5.equalsIgnoreCase("status")) {
                string4 = this.buildMetaProperties(string4);
            }
            string3 = this.formatParameters(string3, arrayList, string4);
            this.post(string2, string3);
        }
    }

    protected String buildMetaProperties(String string) {
        String string2 = string;
        HashMap hashMap = this.transfer.getMetaProperties();
        if (hashMap != null) {
            if (string2 == null) {
                string2 = "";
            }
            Iterator iterator = hashMap.keySet().iterator();
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                String string4 = (String)hashMap.get(string3);
                string2 = string2 + "&" + string3 + "=" + this.encode(string4);
            }
        }
        return string2;
    }

    public static void main(String[] stringArray) {
        MApplication mApplication = new MApplication(stringArray);
        mApplication.init();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

