/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.Buffer;
import com.jcraft.jsch.Cipher;
import com.jcraft.jsch.HASH;
import com.jcraft.jsch.Identity;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SignatureDSA;
import com.jcraft.jsch.SignatureRSA;
import com.jcraft.jsch.Util;
import java.io.File;
import java.io.FileInputStream;

class IdentityFile
implements Identity {
    String identity;
    byte[] key;
    byte[] iv;
    private JSch jsch;
    private HASH hash;
    private byte[] encoded_data;
    private Cipher cipher;
    private byte[] P_array;
    private byte[] Q_array;
    private byte[] G_array;
    private byte[] pub_array;
    private byte[] prv_array;
    private byte[] n_array;
    private byte[] e_array;
    private byte[] d_array;
    private String algname;
    private static final int ERROR = 0;
    private static final int RSA = 1;
    private static final int DSS = 2;
    private static final int UNKNOWN = 3;
    private static final int OPENSSH = 0;
    private static final int FSECURE = 1;
    private static final int PUTTY = 2;
    private int type;
    private int keytype;
    private byte[] publickeyblob;
    private boolean encrypted;

    static IdentityFile newInstance(String prvfile, String pubfile, JSch jsch) throws JSchException {
        byte[] pubkey;
        byte[] prvkey;
        block15: {
            prvkey = null;
            pubkey = null;
            File file = null;
            FileInputStream fis = null;
            try {
                int i;
                file = new File(prvfile);
                fis = new FileInputStream(prvfile);
                prvkey = new byte[(int)file.length()];
                int len = 0;
                while ((i = fis.read(prvkey, len, prvkey.length - len)) > 0) {
                    len += i;
                }
                fis.close();
            }
            catch (Exception e) {
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (Exception i) {
                    // empty catch block
                }
                if (e instanceof Throwable) {
                    throw new JSchException(e.toString(), e);
                }
                throw new JSchException(e.toString());
            }
            String _pubfile = pubfile;
            if (pubfile == null) {
                _pubfile = String.valueOf(prvfile) + ".pub";
            }
            try {
                int i;
                file = new File(_pubfile);
                fis = new FileInputStream(_pubfile);
                pubkey = new byte[(int)file.length()];
                int len = 0;
                while ((i = fis.read(pubkey, len, pubkey.length - len)) > 0) {
                    len += i;
                }
                fis.close();
            }
            catch (Exception e) {
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (pubfile == null) break block15;
                if (e instanceof Throwable) {
                    throw new JSchException(e.toString(), e);
                }
                throw new JSchException(e.toString());
            }
        }
        return IdentityFile.newInstance(prvfile, prvkey, pubkey, jsch);
    }

    static IdentityFile newInstance(String name, byte[] prvkey, byte[] pubkey, JSch jsch) throws JSchException {
        IdentityFile identityFile;
        try {
            identityFile = new IdentityFile(name, prvkey, pubkey, jsch);
            Object var4_5 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            Util.bzero(prvkey);
            throw throwable;
        }
        Util.bzero(prvkey);
        return identityFile;
    }

    /*
     * Unable to fully structure code
     */
    private IdentityFile(String name, byte[] prvkey, byte[] pubkey, JSch jsch) throws JSchException {
        block51: {
            super();
            this.algname = "ssh-rsa";
            this.type = 0;
            this.keytype = 0;
            this.publickeyblob = null;
            this.encrypted = true;
            this.identity = name;
            this.jsch = jsch;
            try {
                block52: {
                    c = Class.forName(JSch.getConfig("3des-cbc"));
                    this.cipher = (Cipher)c.newInstance();
                    this.key = new byte[this.cipher.getBlockSize()];
                    this.iv = new byte[this.cipher.getIVSize()];
                    c = Class.forName(JSch.getConfig("md5"));
                    this.hash = (HASH)c.newInstance();
                    this.hash.init();
                    buf = prvkey;
                    len = buf.length;
                    i = 0;
                    while (i < len) {
                        if (buf[i] == 45 && i + 4 < len && buf[i + 1] == 45 && buf[i + 2] == 45 && buf[i + 3] == 45 && buf[i + 4] == 45) break;
                        ++i;
                    }
                    while (i < len) {
                        if (buf[i] == 66 && i + 3 < len && buf[i + 1] == 69 && buf[i + 2] == 71 && buf[i + 3] == 73) {
                            if (buf[i += 6] == 68 && buf[i + 1] == 83 && buf[i + 2] == 65) {
                                this.type = 2;
                            } else if (buf[i] == 82 && buf[i + 1] == 83 && buf[i + 2] == 65) {
                                this.type = 1;
                            } else if (buf[i] == 83 && buf[i + 1] == 83 && buf[i + 2] == 72) {
                                this.type = 3;
                                this.keytype = 1;
                            } else {
                                throw new JSchException("invalid privatekey: " + this.identity);
                            }
                            i += 3;
                            continue;
                        }
                        if (buf[i] == 65 && i + 7 < len && buf[i + 1] == 69 && buf[i + 2] == 83 && buf[i + 3] == 45 && buf[i + 4] == 50 && buf[i + 5] == 53 && buf[i + 6] == 54 && buf[i + 7] == 45) {
                            i += 8;
                            if (Session.checkCipher(JSch.getConfig("aes256-cbc"))) {
                                c = Class.forName(JSch.getConfig("aes256-cbc"));
                                this.cipher = (Cipher)c.newInstance();
                                this.key = new byte[this.cipher.getBlockSize()];
                                this.iv = new byte[this.cipher.getIVSize()];
                                continue;
                            }
                            throw new JSchException("privatekey: aes256-cbc is not available " + this.identity);
                        }
                        if (buf[i] == 67 && i + 3 < len && buf[i + 1] == 66 && buf[i + 2] == 67 && buf[i + 3] == 44) {
                            i += 4;
                            ii = 0;
                            while (ii < this.iv.length) {
                                this.iv[ii] = (byte)((this.a2b(buf[i++]) << 4 & 240) + (this.a2b(buf[i++]) & 15));
                                ++ii;
                            }
                            continue;
                        }
                        if (buf[i] == 13 && i + 1 < len && buf[i + 1] == 10) {
                            ++i;
                            continue;
                        }
                        if (buf[i] == 10 && i + 1 < len) {
                            if (buf[i + 1] == 10) {
                                i += 2;
                                break;
                            }
                            if (buf[i + 1] == 13 && i + 2 < len && buf[i + 2] == 10) {
                                i += 3;
                                break;
                            }
                            inheader = false;
                            j = i + 1;
                            while (j < len) {
                                if (buf[j] == 10) break;
                                if (buf[j] == 58) {
                                    inheader = true;
                                    break;
                                }
                                ++j;
                            }
                            if (!inheader) {
                                ++i;
                                this.encrypted = false;
                                break;
                            }
                        }
                        ++i;
                    }
                    if (this.type == 0) {
                        throw new JSchException("invalid privatekey: " + this.identity);
                    }
                    start = i;
                    while (i < len) {
                        if (buf[i] == 10) {
                            xd = buf[i - 1] == 13;
                            System.arraycopy(buf, i + 1, buf, i - (xd != false ? 1 : 0), len - i - 1 - (xd != false ? 1 : 0));
                            if (xd) {
                                --len;
                            }
                            --len;
                            continue;
                        }
                        if (buf[i] == 45) break;
                        ++i;
                    }
                    this.encoded_data = Util.fromBase64(buf, start, i - start);
                    if (this.encoded_data.length > 4 && this.encoded_data[0] == 63 && this.encoded_data[1] == 111 && this.encoded_data[2] == -7 && this.encoded_data[3] == -21) {
                        _buf = new Buffer(this.encoded_data);
                        _buf.getInt();
                        _buf.getInt();
                        _type = _buf.getString();
                        _cipher = _buf.getString();
                        cipher = Util.byte2str(_cipher);
                        if (cipher.equals("3des-cbc")) {
                            _buf.getInt();
                            foo = new byte[this.encoded_data.length - _buf.getOffSet()];
                            _buf.getByte(foo);
                            this.encoded_data = foo;
                            this.encrypted = true;
                            throw new JSchException("unknown privatekey format: " + this.identity);
                        }
                        if (cipher.equals("none")) {
                            _buf.getInt();
                            this.encrypted = false;
                            foo = new byte[this.encoded_data.length - _buf.getOffSet()];
                            _buf.getByte(foo);
                            this.encoded_data = foo;
                        }
                    }
                    if (pubkey == null) {
                        return;
                    }
                    buf = pubkey;
                    len = buf.length;
                    if (buf.length <= 4 || buf[0] != 45 || buf[1] != 45 || buf[2] != 45 || buf[3] != 45) break block52;
                    i = 0;
                    while (len > ++i && buf[i] != 10) {
                    }
                    if (len > i) ** GOTO lbl144
                    return;
lbl-1000:
                    // 1 sources

                    {
                        if (buf[i] == 10) {
                            inheader = false;
                            j = i + 1;
                            while (j < len) {
                                if (buf[j] == 10) break;
                                if (buf[j] == 58) {
                                    inheader = true;
                                    break;
                                }
                                ++j;
                            }
                            if (!inheader) {
                                ++i;
                                break;
                            }
                        }
                        ++i;
lbl144:
                        // 2 sources

                        ** while (i < len)
                    }
lbl145:
                    // 2 sources

                    if (len <= i) {
                        return;
                    }
                    start = i;
                    while (i < len) {
                        if (buf[i] == 10) {
                            System.arraycopy(buf, i + 1, buf, i, len - i - 1);
                            --len;
                            continue;
                        }
                        if (buf[i] == 45) break;
                        ++i;
                    }
                    this.publickeyblob = Util.fromBase64(buf, start, i - start);
                    if (this.type == 3 && this.publickeyblob.length > 8) {
                        if (this.publickeyblob[8] == 100) {
                            this.type = 2;
                        } else if (this.publickeyblob[8] == 114) {
                            this.type = 1;
                        }
                    }
                    break block51;
                }
                if (buf[0] != 115 || buf[1] != 115 || buf[2] != 104 || buf[3] != 45) {
                    return;
                }
                i = 0;
                while (i < len) {
                    if (buf[i] == 32) break;
                    ++i;
                }
                if (++i >= len) {
                    return;
                }
                start = i;
                while (i < len) {
                    if (buf[i] == 32 || buf[i] == 10) break;
                    ++i;
                }
                this.publickeyblob = Util.fromBase64(buf, start, i - start);
                if (this.publickeyblob.length < 11) {
                    if (JSch.getLogger().isEnabled(2)) {
                        JSch.getLogger().log(2, "failed to parse the public key");
                    }
                    this.publickeyblob = null;
                }
            }
            catch (Exception e) {
                if (e instanceof JSchException) {
                    throw (JSchException)e;
                }
                if (e instanceof Throwable) {
                    throw new JSchException(e.toString(), e);
                }
                throw new JSchException(e.toString());
            }
        }
    }

    public String getAlgName() {
        if (this.type == 1) {
            return "ssh-rsa";
        }
        return "ssh-dss";
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean setPassphrase(byte[] _passphrase) throws JSchException {
        try {
            if (this.encrypted) {
                if (_passphrase == null) {
                    return false;
                }
                byte[] passphrase = _passphrase;
                int hsize = this.hash.getBlockSize();
                byte[] hn = new byte[this.key.length / hsize * hsize + (this.key.length % hsize == 0 ? 0 : hsize)];
                byte[] tmp = null;
                if (this.keytype == 0) {
                    int index = 0;
                    while (index + hsize <= hn.length) {
                        if (tmp != null) {
                            this.hash.update(tmp, 0, tmp.length);
                        }
                        this.hash.update(passphrase, 0, passphrase.length);
                        this.hash.update(this.iv, 0, this.iv.length > 8 ? 8 : this.iv.length);
                        tmp = this.hash.digest();
                        System.arraycopy(tmp, 0, hn, index, tmp.length);
                        index += tmp.length;
                    }
                    System.arraycopy(hn, 0, this.key, 0, this.key.length);
                } else if (this.keytype == 1) {
                    int index = 0;
                    while (index + hsize <= hn.length) {
                        if (tmp != null) {
                            this.hash.update(tmp, 0, tmp.length);
                        }
                        this.hash.update(passphrase, 0, passphrase.length);
                        tmp = this.hash.digest();
                        System.arraycopy(tmp, 0, hn, index, tmp.length);
                        index += tmp.length;
                    }
                    System.arraycopy(hn, 0, this.key, 0, this.key.length);
                }
                Util.bzero(passphrase);
            }
            if (this.decrypt()) {
                this.encrypted = false;
                return true;
            }
            this.prv_array = null;
            this.pub_array = null;
            this.G_array = null;
            this.Q_array = null;
            this.P_array = null;
            return false;
        }
        catch (Exception e) {
            if (e instanceof JSchException) {
                throw (JSchException)e;
            }
            if (e instanceof Throwable) {
                throw new JSchException(e.toString(), e);
            }
            throw new JSchException(e.toString());
        }
    }

    public byte[] getPublicKeyBlob() {
        if (this.publickeyblob != null) {
            return this.publickeyblob;
        }
        if (this.type == 1) {
            return this.getPublicKeyBlob_rsa();
        }
        return this.getPublicKeyBlob_dss();
    }

    byte[] getPublicKeyBlob_rsa() {
        if (this.e_array == null) {
            return null;
        }
        Buffer buf = new Buffer("ssh-rsa".length() + 4 + this.e_array.length + 4 + this.n_array.length + 4);
        buf.putString(Util.str2byte("ssh-rsa"));
        buf.putString(this.e_array);
        buf.putString(this.n_array);
        return buf.buffer;
    }

    byte[] getPublicKeyBlob_dss() {
        if (this.P_array == null) {
            return null;
        }
        Buffer buf = new Buffer("ssh-dss".length() + 4 + this.P_array.length + 4 + this.Q_array.length + 4 + this.G_array.length + 4 + this.pub_array.length + 4);
        buf.putString(Util.str2byte("ssh-dss"));
        buf.putString(this.P_array);
        buf.putString(this.Q_array);
        buf.putString(this.G_array);
        buf.putString(this.pub_array);
        return buf.buffer;
    }

    public byte[] getSignature(byte[] data) {
        if (this.type == 1) {
            return this.getSignature_rsa(data);
        }
        return this.getSignature_dss(data);
    }

    byte[] getSignature_rsa(byte[] data) {
        try {
            Class<?> c = Class.forName(JSch.getConfig("signature.rsa"));
            SignatureRSA rsa = (SignatureRSA)c.newInstance();
            rsa.init();
            rsa.setPrvKey(this.d_array, this.n_array);
            rsa.update(data);
            byte[] sig = rsa.sign();
            Buffer buf = new Buffer("ssh-rsa".length() + 4 + sig.length + 4);
            buf.putString(Util.str2byte("ssh-rsa"));
            buf.putString(sig);
            return buf.buffer;
        }
        catch (Exception exception) {
            return null;
        }
    }

    byte[] getSignature_dss(byte[] data) {
        try {
            Class<?> c = Class.forName(JSch.getConfig("signature.dss"));
            SignatureDSA dsa = (SignatureDSA)c.newInstance();
            dsa.init();
            dsa.setPrvKey(this.prv_array, this.P_array, this.Q_array, this.G_array);
            dsa.update(data);
            byte[] sig = dsa.sign();
            Buffer buf = new Buffer("ssh-dss".length() + 4 + sig.length + 4);
            buf.putString(Util.str2byte("ssh-dss"));
            buf.putString(sig);
            return buf.buffer;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean decrypt() {
        if (this.type == 1) {
            return this.decrypt_rsa();
        }
        return this.decrypt_dss();
    }

    /*
     * Unable to fully structure code
     */
    boolean decrypt_rsa() {
        block34: {
            block33: {
                block31: {
                    block32: {
                        block30: {
                            block29: {
                                block36: {
                                    block35: {
                                        if (!this.encrypted) break block29;
                                        if (this.keytype != 0) break block35;
                                        this.cipher.init(1, this.key, this.iv);
                                        plain = new byte[this.encoded_data.length];
                                        this.cipher.update(this.encoded_data, 0, this.encoded_data.length, plain, 0);
                                        ** GOTO lbl28
                                    }
                                    if (this.keytype != 1) break block36;
                                    i = 0;
                                    while (i < this.iv.length) {
                                        this.iv[i] = 0;
                                        ++i;
                                    }
                                    this.cipher.init(1, this.key, this.iv);
                                    plain = new byte[this.encoded_data.length];
                                    this.cipher.update(this.encoded_data, 0, this.encoded_data.length, plain, 0);
                                    ** GOTO lbl28
                                }
                                return false;
                            }
                            if (this.n_array == null) break block30;
                            return true;
                        }
                        plain = this.encoded_data;
lbl28:
                        // 3 sources

                        if (this.keytype != 1) break block31;
                        buf = new Buffer(plain);
                        foo = buf.getInt();
                        if (plain.length == foo + 4) break block32;
                        return false;
                    }
                    this.e_array = buf.getMPIntBits();
                    this.d_array = buf.getMPIntBits();
                    this.n_array = buf.getMPIntBits();
                    u_array = buf.getMPIntBits();
                    p_array = buf.getMPIntBits();
                    q_array = buf.getMPIntBits();
                    return true;
                }
                index = 0;
                length = 0;
                if (plain[index] == 48) break block33;
                return false;
            }
            v0 = ++index;
            ++index;
            length = plain[v0] & 255;
            if ((length & 128) != 0) {
                foo = length & 127;
                length = 0;
                while (foo-- > 0) {
                    length = (length << 8) + (plain[index++] & 255);
                }
            }
            if (plain[index] == 2) break block34;
            return false;
        }
        try {
            v1 = ++index;
            ++index;
            length = plain[v1] & 255;
            if ((length & 128) != 0) {
                foo = length & 127;
                length = 0;
                while (foo-- > 0) {
                    length = (length << 8) + (plain[index++] & 255);
                }
            }
            index += length;
            v2 = ++index;
            ++index;
            length = plain[v2] & 255;
            if ((length & 128) != 0) {
                foo = length & 127;
                length = 0;
                while (foo-- > 0) {
                    length = (length << 8) + (plain[index++] & 255);
                }
            }
            this.n_array = new byte[length];
            System.arraycopy(plain, index, this.n_array, 0, length);
            index += length;
            v3 = ++index;
            ++index;
            length = plain[v3] & 255;
            if ((length & 128) != 0) {
                foo = length & 127;
                length = 0;
                while (foo-- > 0) {
                    length = (length << 8) + (plain[index++] & 255);
                }
            }
            this.e_array = new byte[length];
            System.arraycopy(plain, index, this.e_array, 0, length);
            index += length;
            v4 = ++index;
            ++index;
            length = plain[v4] & 255;
            if ((length & 128) != 0) {
                foo = length & 127;
                length = 0;
                while (foo-- > 0) {
                    length = (length << 8) + (plain[index++] & 255);
                }
            }
            this.d_array = new byte[length];
            System.arraycopy(plain, index, this.d_array, 0, length);
            index += length;
            v5 = ++index;
            ++index;
            length = plain[v5] & 255;
            if ((length & 128) != 0) {
                foo = length & 127;
                length = 0;
                while (foo-- > 0) {
                    length = (length << 8) + (plain[index++] & 255);
                }
            }
            p_array = new byte[length];
            System.arraycopy(plain, index, p_array, 0, length);
            index += length;
            v6 = ++index;
            ++index;
            length = plain[v6] & 255;
            if ((length & 128) != 0) {
                foo = length & 127;
                length = 0;
                while (foo-- > 0) {
                    length = (length << 8) + (plain[index++] & 255);
                }
            }
            q_array = new byte[length];
            System.arraycopy(plain, index, q_array, 0, length);
            index += length;
            v7 = ++index;
            ++index;
            length = plain[v7] & 255;
            if ((length & 128) != 0) {
                foo = length & 127;
                length = 0;
                while (foo-- > 0) {
                    length = (length << 8) + (plain[index++] & 255);
                }
            }
            dmp1_array = new byte[length];
            System.arraycopy(plain, index, dmp1_array, 0, length);
            index += length;
            v8 = ++index;
            ++index;
            length = plain[v8] & 255;
            if ((length & 128) != 0) {
                foo = length & 127;
                length = 0;
                while (foo-- > 0) {
                    length = (length << 8) + (plain[index++] & 255);
                }
            }
            dmq1_array = new byte[length];
            System.arraycopy(plain, index, dmq1_array, 0, length);
            index += length;
            v9 = ++index;
            ++index;
            length = plain[v9] & 255;
            if ((length & 128) != 0) {
                foo = length & 127;
                length = 0;
                while (foo-- > 0) {
                    length = (length << 8) + (plain[index++] & 255);
                }
            }
            iqmp_array = new byte[length];
            System.arraycopy(plain, index, iqmp_array, 0, length);
            index += length;
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    boolean decrypt_dss() {
        block28: {
            block27: {
                block25: {
                    block26: {
                        block24: {
                            block23: {
                                block30: {
                                    block29: {
                                        if (!this.encrypted) break block23;
                                        if (this.keytype != 0) break block29;
                                        this.cipher.init(1, this.key, this.iv);
                                        plain = new byte[this.encoded_data.length];
                                        this.cipher.update(this.encoded_data, 0, this.encoded_data.length, plain, 0);
                                        ** GOTO lbl28
                                    }
                                    if (this.keytype != 1) break block30;
                                    i = 0;
                                    while (i < this.iv.length) {
                                        this.iv[i] = 0;
                                        ++i;
                                    }
                                    this.cipher.init(1, this.key, this.iv);
                                    plain = new byte[this.encoded_data.length];
                                    this.cipher.update(this.encoded_data, 0, this.encoded_data.length, plain, 0);
                                    ** GOTO lbl28
                                }
                                return false;
                            }
                            if (this.P_array == null) break block24;
                            return true;
                        }
                        plain = this.encoded_data;
lbl28:
                        // 3 sources

                        if (this.keytype != 1) break block25;
                        buf = new Buffer(plain);
                        foo = buf.getInt();
                        if (plain.length == foo + 4) break block26;
                        return false;
                    }
                    this.P_array = buf.getMPIntBits();
                    this.G_array = buf.getMPIntBits();
                    this.Q_array = buf.getMPIntBits();
                    this.pub_array = buf.getMPIntBits();
                    this.prv_array = buf.getMPIntBits();
                    return true;
                }
                index = 0;
                length = 0;
                if (plain[index] == 48) break block27;
                return false;
            }
            v0 = ++index;
            ++index;
            length = plain[v0] & 255;
            if ((length & 128) != 0) {
                foo = length & 127;
                length = 0;
                while (foo-- > 0) {
                    length = (length << 8) + (plain[index++] & 255);
                }
            }
            if (plain[index] == 2) break block28;
            return false;
        }
        try {
            v1 = ++index;
            ++index;
            length = plain[v1] & 255;
            if ((length & 128) != 0) {
                foo = length & 127;
                length = 0;
                while (foo-- > 0) {
                    length = (length << 8) + (plain[index++] & 255);
                }
            }
            index += length;
            v2 = ++index;
            ++index;
            length = plain[v2] & 255;
            if ((length & 128) != 0) {
                foo = length & 127;
                length = 0;
                while (foo-- > 0) {
                    length = (length << 8) + (plain[index++] & 255);
                }
            }
            this.P_array = new byte[length];
            System.arraycopy(plain, index, this.P_array, 0, length);
            index += length;
            v3 = ++index;
            ++index;
            length = plain[v3] & 255;
            if ((length & 128) != 0) {
                foo = length & 127;
                length = 0;
                while (foo-- > 0) {
                    length = (length << 8) + (plain[index++] & 255);
                }
            }
            this.Q_array = new byte[length];
            System.arraycopy(plain, index, this.Q_array, 0, length);
            index += length;
            v4 = ++index;
            ++index;
            length = plain[v4] & 255;
            if ((length & 128) != 0) {
                foo = length & 127;
                length = 0;
                while (foo-- > 0) {
                    length = (length << 8) + (plain[index++] & 255);
                }
            }
            this.G_array = new byte[length];
            System.arraycopy(plain, index, this.G_array, 0, length);
            index += length;
            v5 = ++index;
            ++index;
            length = plain[v5] & 255;
            if ((length & 128) != 0) {
                foo = length & 127;
                length = 0;
                while (foo-- > 0) {
                    length = (length << 8) + (plain[index++] & 255);
                }
            }
            this.pub_array = new byte[length];
            System.arraycopy(plain, index, this.pub_array, 0, length);
            index += length;
            v6 = ++index;
            ++index;
            length = plain[v6] & 255;
            if ((length & 128) != 0) {
                foo = length & 127;
                length = 0;
                while (foo-- > 0) {
                    length = (length << 8) + (plain[index++] & 255);
                }
            }
            this.prv_array = new byte[length];
            System.arraycopy(plain, index, this.prv_array, 0, length);
            index += length;
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean isEncrypted() {
        return this.encrypted;
    }

    public String getName() {
        return this.identity;
    }

    private byte a2b(byte c) {
        if (48 <= c && c <= 57) {
            return (byte)(c - 48);
        }
        if (97 <= c && c <= 122) {
            return (byte)(c - 97 + 10);
        }
        return (byte)(c - 65 + 10);
    }

    public boolean equals(Object o) {
        if (!(o instanceof IdentityFile)) {
            return super.equals(o);
        }
        IdentityFile foo = (IdentityFile)o;
        return this.getName().equals(foo.getName());
    }

    public void clear() {
        Util.bzero(this.encoded_data);
        Util.bzero(this.prv_array);
        Util.bzero(this.d_array);
        Util.bzero(this.key);
        Util.bzero(this.iv);
    }

    public void finalize() {
        this.clear();
    }
}

