/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core;

import com.sun.jimi.core.JimiControl;
import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.JimiFactoryManager;
import com.sun.jimi.core.JimiImage;
import com.sun.jimi.core.JimiImageFactory;
import com.sun.jimi.core.JimiProExtension;
import com.sun.jimi.core.JimiReader;
import com.sun.jimi.core.JimiWriter;
import com.sun.jimi.core.raster.JimiRasterImage;
import com.sun.jimi.core.raster.JimiRasterImageImporter;
import com.sun.jimi.core.util.JimiImageFactoryProxy;
import com.sun.jimi.core.util.JimiUtil;
import com.sun.jimi.core.util.QueuedImageProducerProxy;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ImageProducer;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;

public class Jimi {
    public static final int ASYNCHRONOUS = 1;
    public static final int SYNCHRONOUS = 2;
    public static final int IN_MEMORY = 4;
    public static final int VIRTUAL_MEMORY = 8;
    public static final int ONE_SHOT = 16;
    protected static int defaultFlags;
    protected static JimiImageFactory memoryFactory;
    protected static JimiImageFactory vmemFactory;
    protected static JimiImageFactory oneshotFactory;
    static boolean limited;
    static boolean crippled;
    static boolean demoversion;
    static /* synthetic */ Class class$com$sun$jimi$core$Jimi;

    private Jimi() {
    }

    public static ImageProducer getImageProducer(String filename) {
        return Jimi.getImageProducer(filename, defaultFlags);
    }

    public static ImageProducer getImageProducer(String filename, int flags) {
        try {
            JimiReader reader = new JimiReader(Jimi.getFactory(flags), filename);
            reader.setBlocking(JimiUtil.flagSet(flags, 2));
            return reader.getImageProducer();
        }
        catch (JimiException e) {
            return JimiUtil.getErrorImageProducer();
        }
    }

    public static Image getImage(String filename) {
        return Jimi.getImage(filename, defaultFlags);
    }

    public static Image getImage(String filename, int flags) {
        return Toolkit.getDefaultToolkit().createImage(Jimi.getImageProducer(filename, flags));
    }

    public static JimiRasterImage getRasterImage(String filename) throws JimiException {
        return Jimi.getRasterImage(filename, defaultFlags);
    }

    public static JimiRasterImage getRasterImage(String filename, int flags) throws JimiException {
        JimiReader reader = new JimiReader(Jimi.getFactory(flags), filename);
        reader.setBlocking(JimiUtil.flagSet(flags, 2));
        return reader.getRasterImage();
    }

    public static ImageProducer getImageProducer(InputStream in) {
        return Jimi.getImageProducer(in, defaultFlags);
    }

    public static ImageProducer getImageProducer(InputStream in, int flags) {
        try {
            JimiReader reader = new JimiReader(Jimi.getFactory(flags), in);
            reader.setBlocking(JimiUtil.flagSet(flags, 2));
            return reader.getImageProducer();
        }
        catch (JimiException e) {
            return JimiUtil.getErrorImageProducer();
        }
    }

    public static ImageProducer getImageProducer(InputStream in, String typeID) {
        return Jimi.getImageProducer(in, typeID, defaultFlags);
    }

    public static ImageProducer getImageProducer(InputStream in, String typeID, int flags) {
        try {
            JimiReader reader = new JimiReader(Jimi.getFactory(flags), in, typeID);
            reader.setBlocking(JimiUtil.flagSet(flags, 2));
            return reader.getImageProducer();
        }
        catch (JimiException e) {
            return JimiUtil.getErrorImageProducer();
        }
    }

    public static ImageProducer getImageProducer(String filename, String typeID) {
        return Jimi.getImageProducer(filename, typeID, defaultFlags);
    }

    public static ImageProducer getImageProducer(String filename, String typeID, int flags) {
        try {
            JimiReader reader = new JimiReader(Jimi.getFactory(flags), filename, typeID);
            reader.setBlocking(JimiUtil.flagSet(flags, 2));
            return reader.getImageProducer();
        }
        catch (JimiException e) {
            return JimiUtil.getErrorImageProducer();
        }
    }

    public static Image getImage(InputStream in) {
        return Jimi.getImage(in, defaultFlags);
    }

    public static Image getImage(InputStream in, int flags) {
        return Toolkit.getDefaultToolkit().createImage(Jimi.getImageProducer(in, flags));
    }

    public static Image getImage(InputStream in, String typeID) {
        return Jimi.getImage(in, typeID, defaultFlags);
    }

    public static Image getImage(InputStream in, String typeID, int flags) {
        return Toolkit.getDefaultToolkit().createImage(Jimi.getImageProducer(in, typeID, flags));
    }

    public static Image getImage(String filename, String typeID, int flags) {
        return Toolkit.getDefaultToolkit().createImage(Jimi.getImageProducer(filename, typeID, flags));
    }

    public static Image getImage(String filename, String typeID) {
        return Jimi.getImage(filename, typeID, defaultFlags);
    }

    public static ImageProducer getImageProducer(URL location) {
        return Jimi.getImageProducer(location, defaultFlags);
    }

    public static ImageProducer getImageProducer(URL location, int flags) {
        try {
            JimiReader reader = new JimiReader(Jimi.getFactory(flags), location);
            return reader.getImageProducer();
        }
        catch (JimiException e) {
            return JimiUtil.getErrorImageProducer();
        }
    }

    public static ImageProducer getImageProducer(URL location, String typeID, int flags) {
        try {
            JimiReader reader = new JimiReader(Jimi.getFactory(flags), location, typeID);
            return reader.getImageProducer();
        }
        catch (JimiException e) {
            return JimiUtil.getErrorImageProducer();
        }
    }

    public static ImageProducer getImageProducer(URL location, String typeID) {
        return Jimi.getImageProducer(location, typeID, defaultFlags);
    }

    public static Image getImage(URL location, String typeID, int flags) {
        return Toolkit.getDefaultToolkit().createImage(Jimi.getImageProducer(location, typeID, flags));
    }

    public static Image getImage(URL location, String typeID) {
        return Jimi.getImage(location, typeID, defaultFlags);
    }

    public static Image getImage(URL location) {
        return Jimi.getImage(location, defaultFlags);
    }

    public static Image getImage(URL location, int flags) {
        return Toolkit.getDefaultToolkit().createImage(Jimi.getImageProducer(location, flags));
    }

    public static JimiRasterImage getRasterImage(URL location) throws JimiException {
        return Jimi.getRasterImage(location, defaultFlags);
    }

    public static JimiRasterImage getRasterImage(URL location, int flags) throws JimiException {
        JimiReader reader = new JimiReader(Jimi.getFactory(flags), location);
        return reader.getRasterImage();
    }

    public static JimiRasterImage getRasterImage(URL location, String typeID) throws JimiException {
        return Jimi.getRasterImage(location, typeID, defaultFlags);
    }

    public static JimiRasterImage getRasterImage(URL location, String typeID, int flags) throws JimiException {
        JimiReader reader = new JimiReader(Jimi.getFactory(flags), location, typeID);
        return reader.getRasterImage();
    }

    public static JimiRasterImage getRasterImage(InputStream input, String typeID) throws JimiException {
        return Jimi.getRasterImage(input, typeID, defaultFlags);
    }

    public static JimiRasterImage getRasterImage(InputStream input, String typeID, int flags) throws JimiException {
        JimiReader reader = new JimiReader(Jimi.getFactory(flags), input, typeID);
        return reader.getRasterImage();
    }

    public static JimiRasterImage getRasterImage(InputStream input) throws JimiException {
        return Jimi.getRasterImage(input, defaultFlags);
    }

    public static JimiRasterImage getRasterImage(InputStream input, int flags) throws JimiException {
        JimiReader reader = new JimiReader(Jimi.getFactory(flags), input);
        return reader.getRasterImage();
    }

    public static void putImage(Image image, String filename) throws JimiException {
        Jimi.putImage(image.getSource(), filename);
    }

    public static void putImage(ImageProducer producer, String filename) throws JimiException {
        Jimi.putImage(Jimi.createRasterImage(producer), filename);
    }

    public static void putImage(JimiImage ji, String filename) throws JimiException {
        JimiWriter jw = new JimiWriter(filename);
        jw.setSource(ji);
        jw.putImage(filename);
    }

    public static void putImage(String id, Image image, OutputStream output) throws JimiException {
        Jimi.putImage(id, image.getSource(), output);
    }

    public static void putImage(String id, ImageProducer producer, OutputStream output) throws JimiException {
        Jimi.putImage(id, (JimiImage)Jimi.createRasterImage(producer), output);
    }

    public static void putImage(String id, JimiImage ji, OutputStream output) throws JimiException {
        JimiWriter jw = new JimiWriter(output, id);
        jw.setSource(ji);
        jw.putImage(output);
    }

    public static void putImage(String id, JimiImage image, String filename) throws JimiException {
        JimiWriter jw = new JimiWriter(filename, id);
        jw.setSource(image);
        jw.putImage(filename);
    }

    public static void putImage(String id, Image image, String filename) throws JimiException {
        JimiWriter jw = new JimiWriter(filename, id);
        jw.setSource(image);
        jw.putImage(filename);
    }

    public static void putImage(String id, ImageProducer image, String filename) throws JimiException {
        JimiWriter jw = new JimiWriter(filename, id);
        jw.setSource(image);
        jw.putImage(filename);
    }

    public static JimiRasterImage createRasterImage(ImageProducer producer) throws JimiException {
        return Jimi.createRasterImage(producer, 4);
    }

    public static JimiRasterImage createRasterImage(ImageProducer producer, int flags) throws JimiException {
        if (producer instanceof QueuedImageProducerProxy) {
            producer = ((QueuedImageProducerProxy)producer).getImageProducer();
        }
        if (producer instanceof JimiRasterImage) {
            return (JimiRasterImage)((Object)producer);
        }
        return Jimi.createRasterImage(producer, Jimi.getFactory(flags));
    }

    public static JimiReader createTypedJimiReader(String typeID) throws JimiException {
        return Jimi.createTypedJimiReader(typeID, defaultFlags);
    }

    public static JimiReader createTypedJimiReader(String typeID, int flags) throws JimiException {
        JimiReader jr = new JimiReader(Jimi.getFactory(flags));
        jr.setMimeType(typeID);
        return jr;
    }

    public static JimiReader createJimiReader(String filename) throws JimiException {
        return Jimi.createJimiReader(filename, defaultFlags);
    }

    public static JimiReader createJimiReader(InputStream input) throws JimiException {
        return Jimi.createJimiReader(input, defaultFlags);
    }

    public static JimiReader createTypedJimiReader(InputStream input, String typeID) throws JimiException {
        return Jimi.createTypedJimiReader(input, typeID);
    }

    public static JimiReader createTypedJimiReader(InputStream input, String typeID, int flags) throws JimiException {
        return new JimiReader(Jimi.getFactory(flags), input, typeID);
    }

    public static JimiWriter createTypedJimiWriter(String typeID) throws JimiException {
        return new JimiWriter((OutputStream)null, typeID);
    }

    public static JimiReader createJimiReader(URL location) throws JimiException {
        return Jimi.createJimiReader(location, defaultFlags);
    }

    public static JimiReader createJimiReader(String filename, int flags) throws JimiException {
        return new JimiReader(Jimi.getFactory(flags), filename);
    }

    public static JimiReader createJimiReader(InputStream input, int flags) throws JimiException {
        return new JimiReader(Jimi.getFactory(flags), input);
    }

    public static JimiReader createJimiReader(URL location, int flags) throws JimiException {
        return new JimiReader(Jimi.getFactory(flags), location);
    }

    public static JimiWriter createJimiWriter(String filename) throws JimiException {
        return new JimiWriter(filename);
    }

    public static JimiWriter createJimiWriter(String id, OutputStream output) throws JimiException {
        return new JimiWriter(output, id);
    }

    public static void setDefaultFlags(int flags) {
        defaultFlags = flags;
    }

    public static String[] getEncoderTypes() {
        String[] types = new String[JimiControl.mimeToEncoderMap.size()];
        Enumeration enumeration = JimiControl.mimeToEncoderMap.keys();
        for (int i = 0; i < types.length && enumeration.hasMoreElements(); ++i) {
            types[i] = (String)enumeration.nextElement();
        }
        return types;
    }

    public static String[] getDecoderTypes() {
        String[] types = new String[JimiControl.mimeToDecoderMap.size()];
        Enumeration enumeration = JimiControl.mimeToDecoderMap.keys();
        for (int i = 0; i < types.length && enumeration.hasMoreElements(); ++i) {
            types[i] = (String)enumeration.nextElement();
        }
        return types;
    }

    protected static JimiRasterImage createRasterImage(ImageProducer producer, JimiImageFactory factory) throws JimiException {
        while (factory instanceof JimiImageFactoryProxy) {
            factory = ((JimiImageFactoryProxy)factory).getProxiedFactory();
        }
        return JimiRasterImageImporter.importImage(producer, factory);
    }

    public static JimiImageFactory getFactory(int flags) {
        if ((flags & 0x10) != 0) {
            return oneshotFactory;
        }
        if ((flags & 8) != 0) {
            if (vmemFactory == null) {
                if (limited) {
                    vmemFactory = memoryFactory;
                }
                try {
                    Class<?> vmemFactoryClass = Class.forName("com.sun.jimi.core.VMemJimiImageFactory");
                    vmemFactory = (JimiImageFactory)vmemFactoryClass.newInstance();
                }
                catch (Exception e) {
                    vmemFactory = memoryFactory;
                }
            }
            return vmemFactory;
        }
        return memoryFactory;
    }

    public static void main(String[] args) {
        block6: {
            block7: {
                block5: {
                    if (args.length == 0) {
                        System.err.println("Usage: Jimi <-version | -encoders | -decoders>");
                    }
                    if (!args[0].equals("-version")) break block5;
                    try {
                        Properties props = new Properties();
                        props.load((class$com$sun$jimi$core$Jimi == null ? (class$com$sun$jimi$core$Jimi = Jimi.class$("com.sun.jimi.core.Jimi")) : class$com$sun$jimi$core$Jimi).getResourceAsStream("version"));
                        System.out.println("Jimi version: " + props.getProperty("jimi.version") + " (build " + props.getProperty("jimi.build") + ")");
                    }
                    catch (Exception e) {
                        System.err.println("Unable to read version information: " + e.toString());
                    }
                    break block6;
                }
                if (!args[0].equals("-encoders")) break block7;
                System.out.println("Supported encoder mimetypes:");
                String[] types = Jimi.getEncoderTypes();
                for (int i = 0; i < types.length; ++i) {
                    System.out.println(types[i]);
                }
                break block6;
            }
            if (!args[0].equals("-decoders")) break block6;
            System.out.println("Supported decoder mimetypes:");
            String[] types = Jimi.getDecoderTypes();
            for (int i = 0; i < types.length; ++i) {
                System.out.println(types[i]);
            }
        }
    }

    static void init() {
    }

    static {
        if (System.getSecurityManager() == null) {
            System.runFinalizersOnExit((boolean)true);
        }
        defaultFlags = 5;
        limited = false;
        crippled = false;
        demoversion = false;
        JimiControl.addExtension(new JimiProExtension());
        memoryFactory = JimiFactoryManager.getMemoryFactory();
        oneshotFactory = JimiFactoryManager.getOneshotFactory();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

