/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core;

import com.sun.jimi.core.JimiDecoderFactory;
import com.sun.jimi.core.JimiEncoderFactory;
import com.sun.jimi.core.JimiExtension;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.PushbackInputStream;
import java.util.Hashtable;
import java.util.Vector;

public class JimiControl {
    protected static Hashtable mimeToDecoderMap = new Hashtable();
    protected static Hashtable mimeToEncoderMap = new Hashtable();
    protected static Hashtable fileExtensionToDecoderMap = new Hashtable();
    protected static Hashtable fileExtensionToEncoderMap = new Hashtable();
    protected static Vector decoderFactories = new Vector();
    protected static Vector encoderFactories = new Vector();
    protected static Vector extensions = new Vector();
    protected static boolean extensionsAllowed = true;

    public static synchronized void addExtension(JimiExtension extension) {
        if (!extensionsAllowed) {
            throw new RuntimeException("This JIMI license does not permit extensions.");
        }
        extensions.addElement(extension);
        JimiDecoderFactory[] decoders = extension.getDecoders();
        for (int i = 0; i < decoders.length; ++i) {
            JimiControl.addDecoder(decoders[i]);
        }
        JimiEncoderFactory[] encoders = extension.getEncoders();
        for (int i = 0; i < encoders.length; ++i) {
            JimiControl.addEncoder(encoders[i]);
        }
    }

    protected static JimiDecoderFactory getDecoderByType(String mimeType) {
        return (JimiDecoderFactory)mimeToDecoderMap.get(mimeType);
    }

    protected static JimiDecoderFactory getDecoderByFileExtension(String filename) {
        String extension = filename;
        if (extension.lastIndexOf(".") != -1) {
            extension = extension.substring(extension.lastIndexOf(".") + 1);
        }
        return (JimiDecoderFactory)fileExtensionToDecoderMap.get(extension.toLowerCase());
    }

    protected static synchronized JimiDecoderFactory getDecoderForInputStream(PushbackInputStream input) {
        byte[] inputData = new byte[16];
        try {
            DataInputStream dis = new DataInputStream(input);
            dis.readFully(inputData);
            input.unread(inputData);
            int numberOfDecoders = decoderFactories.size();
            for (int formatIndex = 0; formatIndex < numberOfDecoders; ++formatIndex) {
                JimiDecoderFactory decoder = (JimiDecoderFactory)decoderFactories.elementAt(formatIndex);
                byte[][] formatSignatures = decoder.getFormatSignatures();
                if (formatSignatures == null) continue;
                for (int sig = 0; sig < formatSignatures.length; ++sig) {
                    int i = 0;
                    int signatureLength = Math.min(formatSignatures[sig].length, inputData.length);
                    if (i >= signatureLength || formatSignatures[sig][i] != inputData[i]) continue;
                    return decoder;
                }
            }
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    protected static JimiEncoderFactory getEncoderByType(String mimeType) {
        return (JimiEncoderFactory)mimeToEncoderMap.get(mimeType);
    }

    protected static JimiEncoderFactory getEncoderByFileExtension(String filename) {
        String extension = filename;
        if (extension.lastIndexOf(".") != -1) {
            extension = extension.substring(extension.lastIndexOf(".") + 1);
        }
        return (JimiEncoderFactory)fileExtensionToEncoderMap.get(extension.toLowerCase());
    }

    protected static void addDecoder(JimiDecoderFactory decoder) {
        decoderFactories.addElement(decoder);
        String[] mimeTypes = decoder.getMimeTypes();
        for (int i = 0; i < mimeTypes.length; ++i) {
            mimeToDecoderMap.put(mimeTypes[i], decoder);
            if (mimeTypes[i].indexOf(47) <= 0) continue;
            String xifiedType = mimeTypes[i].substring(0, mimeTypes[i].indexOf(47) + 1) + "x-" + mimeTypes[i].substring(mimeTypes[i].indexOf(47) + 1);
            mimeToDecoderMap.put(xifiedType, decoder);
        }
        String[] fileExtensions = decoder.getFilenameExtensions();
        for (int i = 0; i < fileExtensions.length; ++i) {
            fileExtensionToDecoderMap.put(fileExtensions[i], decoder);
        }
    }

    protected static void addEncoder(JimiEncoderFactory encoder) {
        encoderFactories.addElement(encoder);
        String[] mimeTypes = encoder.getMimeTypes();
        for (int i = 0; i < mimeTypes.length; ++i) {
            mimeToEncoderMap.put(mimeTypes[i], encoder);
            if (mimeTypes[i].indexOf(47) <= 0) continue;
            String xifiedType = mimeTypes[i].substring(0, mimeTypes[i].indexOf(47) + 1) + "x-" + mimeTypes[i].substring(mimeTypes[i].indexOf(47) + 1);
            mimeToEncoderMap.put(xifiedType, encoder);
        }
        String[] fileExtensions = encoder.getFilenameExtensions();
        for (int i = 0; i < fileExtensions.length; ++i) {
            fileExtensionToEncoderMap.put(fileExtensions[i], encoder);
        }
    }

    protected static void disableExtensions() {
        extensionsAllowed = false;
    }
}

