/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core;

import com.sun.jimi.core.JimiImageFactory;
import com.sun.jimi.core.MemoryJimiImageFactory;

public class JimiFactoryManager {
    protected static JimiImageFactory memoryFactory;
    protected static JimiImageFactory oneshotFactory;
    protected static JimiImageFactory vmemFactory;
    protected static boolean stampingAvailable;
    protected static boolean vmemInitialized;
    protected static final String ONESHOT_FACTORY_NAME = "com.sun.jimi.core.OneshotJimiImageFactory";
    protected static final String VMEM_FACTORY_NAME = "com.sun.jimi.core.VMemJimiImageFactory";

    public static JimiImageFactory getMemoryFactory() {
        return memoryFactory;
    }

    public static JimiImageFactory getVMemFactory() {
        if (!vmemInitialized) {
            JimiFactoryManager.initVMemFactory();
        }
        return vmemFactory;
    }

    public static JimiImageFactory getOneshotFactory() {
        return oneshotFactory;
    }

    protected static void initVMemFactory() {
        vmemInitialized = true;
        try {
            Class<?> vmem_class = Class.forName(VMEM_FACTORY_NAME);
            vmemFactory = (JimiImageFactory)vmem_class.newInstance();
        }
        catch (Exception e) {
            vmemFactory = memoryFactory;
        }
    }

    static {
        try {
            memoryFactory = new MemoryJimiImageFactory();
            try {
                Class<?> oneshot_class = Class.forName(ONESHOT_FACTORY_NAME);
                oneshotFactory = (JimiImageFactory)oneshot_class.newInstance();
            }
            catch (Exception e) {
                oneshotFactory = memoryFactory;
            }
            stampingAvailable = false;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

