/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core;

import com.sun.jimi.core.Jimi;
import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.JimiImage;
import com.sun.jimi.core.options.FormatOptionSet;
import java.awt.Image;
import java.awt.image.ImageProducer;

public class JimiImageEnumeration {
    protected static final int MODE_JIMIIMAGE = 0;
    protected static final int MODE_IMAGEPRODUCER = 1;
    protected int mode;
    protected ImageProducer[] producers;
    protected JimiImage[] jimiImages;
    protected int imageCount;
    protected int imageIndex = 0;
    protected FormatOptionSet options;

    public JimiImageEnumeration(Image[] images) {
        ImageProducer[] producers = new ImageProducer[images.length];
        for (int i = 0; i < images.length; ++i) {
            producers[i] = images[i].getSource();
        }
        this.producers = producers;
        this.mode = 1;
        this.imageCount = producers.length;
    }

    public JimiImageEnumeration(ImageProducer[] producers) {
        this.producers = producers;
        this.mode = 1;
        this.imageCount = producers.length;
    }

    public JimiImageEnumeration(JimiImage[] jimiImages) {
        this.jimiImages = jimiImages;
        this.mode = 0;
        this.imageCount = jimiImages.length;
    }

    public JimiImageEnumeration(Image image) {
        this(new Image[]{image});
    }

    public JimiImageEnumeration(ImageProducer image) {
        this(new ImageProducer[]{image});
    }

    public JimiImageEnumeration(JimiImage image) {
        this(new JimiImage[]{image});
    }

    public int countImages() {
        return this.imageCount;
    }

    public JimiImage getNextImage() throws JimiException {
        JimiImage result;
        if (!this.hasMoreImages()) {
            return null;
        }
        if (this.mode == 1) {
            result = Jimi.createRasterImage(this.producers[this.imageIndex]);
            this.producers[this.imageIndex] = null;
        } else {
            result = this.jimiImages[this.imageIndex];
            this.jimiImages[this.imageIndex] = null;
        }
        result.waitFinished();
        if (this.options != null) {
            result.setOptions(this.options);
        }
        ++this.imageIndex;
        return result;
    }

    public boolean hasMoreImages() {
        return this.imageIndex < this.imageCount;
    }

    public void setOptions(FormatOptionSet options) {
        this.options = options;
    }
}

