/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core;

import com.sun.jimi.core.ImageSeriesDecodingController;
import com.sun.jimi.core.JimiDecodingController;
import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.JimiImageFactory;
import com.sun.jimi.core.JimiImageHandle;
import com.sun.jimi.core.JimiMultiImageRasterDecoderRunner;
import com.sun.jimi.core.JimiRasterDecoderSupport;
import com.sun.jimi.core.MImageSeriesDecodingController;
import com.sun.jimi.core.raster.MutableJimiRasterImage;
import java.io.IOException;
import java.io.InputStream;

public abstract class JimiMultiImageRasterDecoder
extends JimiRasterDecoderSupport {
    protected JimiDecodingController currentDecodingController;
    protected JimiImageHandle currentHandle;
    protected MImageSeriesDecodingController controller;
    protected boolean error;
    protected boolean busy = false;

    public ImageSeriesDecodingController initDecoding(JimiImageFactory factory, InputStream input) {
        super.init(factory, input);
        this.controller = new MImageSeriesDecodingController(this);
        return this.controller;
    }

    protected JimiDecodingController initNextDecoding() {
        this.waitReady();
        this.currentHandle = new JimiImageHandle();
        this.currentDecodingController = new JimiDecodingController(this.currentHandle);
        JimiMultiImageRasterDecoderRunner r = new JimiMultiImageRasterDecoderRunner(this);
        new Thread(r).start();
        return this.currentDecodingController;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void driveDecoding() {
        try {
            if (this.progressListener != null) {
                this.progressListener.setStarted();
            }
            this.setJimiImage(this.doInitNextDecoding(this.getJimiImageFactory(), this.getInput()));
            this.doNextImageDecode();
            if (this.progressListener != null) {
                this.progressListener.setFinished();
            }
        }
        catch (JimiException je) {
            if (this.progressListener != null) {
                this.progressListener.setAbort(je.getMessage());
            }
        }
        catch (IOException ioe) {
            if (this.progressListener != null) {
                this.progressListener.setAbort();
            }
        }
        finally {
            this.progressListener = null;
            this.setBusy(false);
            if (this.noMoreRequests) {
                this.cleanup();
            }
        }
    }

    public abstract MutableJimiRasterImage doInitNextDecoding(JimiImageFactory var1, InputStream var2) throws JimiException, IOException;

    public abstract void doNextImageDecode() throws JimiException, IOException;

    public abstract void doSkipNextImage() throws JimiException, IOException;

    public abstract boolean hasMoreImages();

    protected synchronized void setJimiImage(MutableJimiRasterImage jimiImage) {
        jimiImage.setDecodingController(this.currentDecodingController);
        this.currentHandle.setJimiImage(jimiImage);
        this.currentDecodingController.waitDecodingRequest();
    }

    public JimiImageFactory getJimiImageFactory() {
        return this.factory;
    }

    public void setProgress(int progressLevel) {
        super.setProgress(progressLevel);
    }

    public InputStream getInput() {
        return this.input;
    }

    protected synchronized void setBusy(boolean busy) {
        this.busy = busy;
        this.notifyAll();
    }

    protected synchronized void waitReady() {
        while (this.busy) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

