/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core;

import com.sun.jimi.core.JimiDecoderFactory;
import com.sun.jimi.core.JimiEncoderFactory;
import com.sun.jimi.core.JimiExtension;
import java.util.Vector;

public class JimiProExtension
implements JimiExtension {
    private static final String VENDOR = "Sun Microsystems, Inc.";
    private static final String DESCRIPTION = "Jimi Professional formats";
    private static final String VERSION = "2.0";
    private static JimiDecoderFactory[] DECODERS;
    private static String[] decoderNames;
    private static JimiEncoderFactory[] ENCODERS;
    private static String[] encoderNames;

    public String getVendor() {
        return VENDOR;
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public String getVersionString() {
        return VERSION;
    }

    public JimiDecoderFactory[] getDecoders() {
        return DECODERS;
    }

    public JimiEncoderFactory[] getEncoders() {
        return ENCODERS;
    }

    static {
        decoderNames = new String[]{"com.sun.jimi.core.decoder.bmp.BMPDecoderFactory", "com.sun.jimi.core.decoder.cur.CURDecoderFactory", "com.sun.jimi.core.decoder.gif.GIFDecoderFactory", "com.sun.jimi.core.decoder.ico.ICODecoderFactory", "com.sun.jimi.core.decoder.png.PNGDecoderFactory", "com.sun.jimi.core.decoder.sunraster.SunRasterDecoderFactory", "com.sun.jimi.core.decoder.tga.TGADecoderFactory", "com.sun.jimi.core.decoder.tiff.TIFDecoderFactory", "com.sun.jimi.core.decoder.pcx.PCXDecoderFactory", "com.sun.jimi.core.decoder.pict.PICTDecoderFactory", "com.sun.jimi.core.decoder.psd.PSDDecoderFactory", "com.sun.jimi.core.decoder.xbm.XBMDecoderFactory", "com.sun.jimi.core.decoder.xpm.XPMDecoderFactory", "com.sun.jimi.core.decoder.builtin.BuiltinDecoderFactory"};
        encoderNames = new String[]{"com.sun.jimi.core.encoder.xpm.XPMEncoderFactory", "com.sun.jimi.core.encoder.xbm.XBMEncoderFactory", "com.sun.jimi.core.encoder.png.PNGEncoderFactory", "com.sun.jimi.core.encoder.sunraster.SunRasterEncoderFactory", "com.sun.jimi.core.encoder.bmp.BMPEncoderFactory", "com.sun.jimi.core.encoder.psd.PSDEncoderFactory", "com.sun.jimi.core.encoder.pict.PICTEncoderFactory", "com.sun.jimi.core.encoder.pcx.PCXEncoderFactory", "com.sun.jimi.core.encoder.tga.TGAEncoderFactory", null};
        JimiProExtension.encoderNames[JimiProExtension.encoderNames.length - 1] = "com.sun.jimi.core.encoder.jpg.JPGEncoderFactory";
        Vector<JimiDecoderFactory> decoders = new Vector<JimiDecoderFactory>();
        for (int i = 0; i < decoderNames.length; ++i) {
            try {
                Class<?> klass = Class.forName(decoderNames[i]);
                JimiDecoderFactory factory = (JimiDecoderFactory)klass.newInstance();
                decoders.addElement(factory);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        DECODERS = new JimiDecoderFactory[decoders.size()];
        decoders.copyInto(DECODERS);
        Vector<JimiEncoderFactory> encoders = new Vector<JimiEncoderFactory>();
        for (int i = 0; i < encoderNames.length; ++i) {
            try {
                Class<?> klass = Class.forName(encoderNames[i]);
                JimiEncoderFactory factory = (JimiEncoderFactory)klass.newInstance();
                encoders.addElement(factory);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        ENCODERS = new JimiEncoderFactory[encoders.size()];
        encoders.copyInto(ENCODERS);
    }
}

