/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core;

import com.sun.jimi.core.ImageSeriesDecodingController;
import com.sun.jimi.core.ImageSeriesEnumerator;
import com.sun.jimi.core.Jimi;
import com.sun.jimi.core.JimiControl;
import com.sun.jimi.core.JimiDecoder;
import com.sun.jimi.core.JimiDecoderFactory;
import com.sun.jimi.core.JimiDecodingController;
import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.JimiImage;
import com.sun.jimi.core.JimiImageFactory;
import com.sun.jimi.core.raster.JimiRasterImage;
import com.sun.jimi.core.util.FreeFormat;
import com.sun.jimi.core.util.GraphicsUtils;
import com.sun.jimi.core.util.JimiUtil;
import com.sun.jimi.core.util.ProgressListener;
import com.sun.jimi.core.util.StampImageFilter;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageProducer;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;

public class JimiReader {
    public static final int UNKNOWN = -1;
    protected static final int STREAM_BUFFER_SIZE = 10240;
    protected JimiDecoderFactory decoderFactory;
    protected JimiDecoder decoder;
    protected JimiImageFactory imageFactory;
    protected InputStream input;
    protected JimiRasterImage cacheJimiImage;
    protected ImageProducer cacheImageProducer;
    protected Image cacheImage;
    protected int cacheIndex = -1;
    protected int seriesIndex = 0;
    protected ImageSeriesDecodingController series;
    protected boolean synchronous;
    protected boolean builtinJPEG;
    protected ImageProducer jpegProducer;
    protected URL location;
    protected String filename;
    protected ProgressListener listener;
    protected Runnable cleanupCommand;

    protected JimiReader(JimiImageFactory imageFactory, JimiDecoderFactory decoderFactory, InputStream input) throws JimiException {
        this.initReader(imageFactory, decoderFactory, input);
    }

    protected JimiReader(JimiImageFactory imageFactory, InputStream input, String typeID) throws JimiException {
        JimiDecoderFactory decoderFactory = JimiControl.getDecoderByType(typeID);
        if (decoderFactory == null) {
            throw new JimiException("No decoder available for " + typeID);
        }
        this.initReader(imageFactory, decoderFactory, input);
    }

    protected JimiReader(JimiImageFactory factory, String filename, String typeID) throws JimiException {
        this.cleanupCommand = new StreamCloseCommand();
        JimiDecoderFactory decoderFactory = JimiControl.getDecoderByType(typeID);
        if (decoderFactory == null) {
            throw new JimiException("No decoder available for " + typeID);
        }
        try {
            InputStream input = new FileInputStream(filename);
            input = new BufferedInputStream(input, 10240);
            this.initReader(this.imageFactory, decoderFactory, input);
        }
        catch (IOException e) {
            throw new JimiException(e.getMessage());
        }
    }

    protected JimiReader(JimiImageFactory imageFactory, URL location) throws JimiException {
        this.cleanupCommand = new StreamCloseCommand();
        this.location = location;
        try {
            JimiDecoderFactory decoderFactory = JimiControl.getDecoderByFileExtension(location.toString());
            URLConnection conn = location.openConnection();
            InputStream input = location.openStream();
            if (decoderFactory == null) {
                decoderFactory = JimiControl.getDecoderByType(conn.getContentType());
            }
            if (decoderFactory == null) {
                PushbackInputStream stream = new PushbackInputStream(input, 128);
                decoderFactory = JimiControl.getDecoderForInputStream(stream);
                input = stream;
            }
            if (decoderFactory == null) {
                throw new JimiException("No decoder available for location: " + location);
            }
            input = new BufferedInputStream(input, 10240);
            this.initReader(imageFactory, decoderFactory, input);
        }
        catch (IOException e) {
            throw new JimiException(e.toString());
        }
    }

    protected JimiReader(JimiImageFactory imageFactory, URL location, String typeID) throws JimiException {
        this.cleanupCommand = new StreamCloseCommand();
        this.location = location;
        try {
            JimiDecoderFactory decoderFactory = JimiControl.getDecoderByType(typeID);
            if (decoderFactory == null) {
                throw new JimiException("No decoder available for file: " + location);
            }
            InputStream input = location.openStream();
            input = new BufferedInputStream(input, 10240);
            this.initReader(imageFactory, decoderFactory, input);
        }
        catch (IOException e) {
            throw new JimiException(e.toString());
        }
    }

    protected JimiReader(JimiImageFactory imageFactory, String filename) throws JimiException {
        this.cleanupCommand = new StreamCloseCommand();
        this.filename = filename;
        try {
            JimiDecoderFactory decoderFactory = JimiControl.getDecoderByFileExtension(filename);
            if (decoderFactory == null) {
                throw new JimiException("No decoder available for file: " + filename);
            }
            InputStream input = new FileInputStream(filename);
            input = new BufferedInputStream(input, 10240);
            this.initReader(imageFactory, decoderFactory, input);
        }
        catch (IOException e) {
            throw new JimiException(e.toString());
        }
    }

    protected JimiReader(JimiImageFactory imageFactory, InputStream input) throws JimiException {
        PushbackInputStream stream = new PushbackInputStream(input, 128);
        JimiDecoderFactory decoderFactory = JimiControl.getDecoderForInputStream(stream);
        if (decoderFactory == null) {
            throw new JimiException("Cannot find decoder for stream");
        }
        this.initReader(imageFactory, decoderFactory, stream);
    }

    protected JimiReader(JimiImageFactory imageFactory) throws JimiException {
        this.initReader(imageFactory);
    }

    public int getNumberOfImages() {
        return -1;
    }

    public void setProgressListener(ProgressListener listener) {
        this.listener = listener;
        if (this.decoder != null) {
            this.decoder.setProgressListener(listener);
        }
    }

    public void setMimeType(String typeID) throws JimiException {
        JimiDecoderFactory decoderFactory = JimiControl.getDecoderByType(typeID);
        if (decoderFactory == null) {
            throw new JimiException("Cannot find decoder for type: " + typeID);
        }
        if (this.input != null) {
            this.initReader(this.imageFactory, decoderFactory, this.input);
        } else {
            this.initReader(this.imageFactory, decoderFactory);
        }
    }

    protected void initReader(JimiImageFactory imageFactory, JimiDecoderFactory decoderFactory, InputStream input) {
        if (decoderFactory instanceof FreeFormat) {
            imageFactory = JimiUtil.stripStamping(imageFactory);
        }
        this.imageFactory = imageFactory;
        this.decoderFactory = decoderFactory;
        this.decoder = decoderFactory.createDecoder();
        if (this.listener != null && this.decoder != null) {
            this.decoder.setProgressListener(this.listener);
        }
        this.input = input;
        if (decoderFactory.getClass().getName().equals("com.sun.jimi.core.decoder.builtin.BuiltinDecoderFactory")) {
            this.builtinJPEG = true;
        } else {
            if (this.cleanupCommand != null) {
                this.decoder.addCleanupCommand(this.cleanupCommand);
            }
            this.series = this.decoder.initDecoding(imageFactory, input);
        }
    }

    protected void initReader(JimiImageFactory imageFactory, JimiDecoderFactory decoderFactory) {
        if (decoderFactory instanceof FreeFormat) {
            imageFactory = JimiUtil.stripStamping(imageFactory);
        }
        this.initReader(imageFactory);
        this.decoderFactory = decoderFactory;
        this.decoder = decoderFactory.createDecoder();
        if (this.listener != null) {
            this.decoder.setProgressListener(this.listener);
        }
        if (decoderFactory.getClass().getName().equals("com.sun.jimi.core.decoder.builtin.BuiltinDecoderFactory")) {
            this.builtinJPEG = true;
        } else if (this.cleanupCommand != null) {
            this.decoder.addCleanupCommand(this.cleanupCommand);
        }
    }

    protected void initReader(JimiImageFactory factory) {
        this.imageFactory = factory;
    }

    public void setSource(InputStream input) throws JimiException {
        this.initReader(this.imageFactory, this.decoderFactory, input);
    }

    public void setSource(String filename) throws JimiException {
        InputStream input;
        try {
            input = new FileInputStream(filename);
            this.filename = filename;
            input = new BufferedInputStream(input, 10240);
        }
        catch (Exception e) {
            throw new JimiException("Unable to open source file.");
        }
        this.initReader(this.imageFactory, this.decoderFactory, input);
    }

    public void setSource(URL location) throws JimiException {
        try {
            InputStream input = location.openStream();
            this.location = location;
            input = new BufferedInputStream(input, 10240);
        }
        catch (IOException e) {
            throw new JimiException("Unable to open source URL.");
        }
    }

    public void setBlocking(boolean synchronous) {
        this.synchronous = synchronous;
    }

    public Dimension getSize() throws JimiException {
        JimiRasterImage image = this.getRasterImage();
        image.waitInfoAvailable();
        return new Dimension(image.getWidth(), image.getHeight());
    }

    public JimiRasterImage getRasterImage() throws JimiException {
        if (this.cacheIndex == 0) {
            if (this.cacheJimiImage != null) {
                return this.cacheJimiImage;
            }
            return Jimi.createRasterImage(this.cacheImageProducer);
        }
        if (this.seriesIndex == 0) {
            JimiRasterImage img = this.getNextJimiImage();
            if (this.decoder != null) {
                this.decoder.setFinished();
            }
            return img;
        }
        throw new JimiException();
    }

    public ImageProducer getImageProducer() {
        try {
            if (this.cacheIndex == 0) {
                return this.cacheImageProducer;
            }
            if (this.seriesIndex == 0) {
                ImageProducer img = this.getNextImageProducer();
                if (this.decoder != null) {
                    this.decoder.setFinished();
                }
                return img;
            }
        }
        catch (JimiException jimiException) {
            // empty catch block
        }
        return JimiUtil.getErrorImageProducer();
    }

    public Image getImage() {
        if (this.cacheIndex == 0) {
            if (this.cacheImage != null) {
                return this.cacheImage;
            }
            Image img = Toolkit.getDefaultToolkit().createImage(this.cacheImageProducer);
            GraphicsUtils.waitForImage(img);
            this.cacheImage = img;
            return img;
        }
        try {
            Image img = this.getNextImage();
            if (this.decoder != null) {
                this.decoder.setFinished();
            }
            return img;
        }
        catch (Exception e) {
            return JimiUtil.getErrorImage();
        }
    }

    public Enumeration getRasterImageEnumeration() {
        return new ImageSeriesEnumerator(this, 1);
    }

    public Enumeration getImageEnumeration() {
        return new ImageSeriesEnumerator(this, 0);
    }

    public Enumeration getImageProducerEnumeration() {
        return new ImageSeriesEnumerator(this, 2);
    }

    public void skipNextImage() throws JimiException {
        if (!this.series.hasMoreImages()) {
            this.series.skipNextImage();
            ++this.seriesIndex;
        } else {
            throw new JimiException("Attemping to move beyond last image.");
        }
    }

    public ImageProducer getImageProducer(int n) throws JimiException {
        if (n < this.seriesIndex) {
            throw new JimiException("Unable to access image number " + n);
        }
        while (this.seriesIndex < n) {
            this.skipNextImage();
        }
        return this.getNextImageProducer();
    }

    public Image getImage(int n) throws JimiException {
        if (n == this.cacheIndex && this.cacheImage != null) {
            return this.cacheImage;
        }
        ImageProducer prod = this.getImageProducer(n);
        Image i = Toolkit.getDefaultToolkit().createImage(prod);
        if (this.synchronous) {
            GraphicsUtils.waitForImage(i);
        }
        return i;
    }

    public void close() {
        if (this.decoder != null) {
            this.decoder.setFinished();
        }
    }

    protected JimiRasterImage getNextJimiImage() throws JimiException {
        return this.getNextJimiImage(true);
    }

    protected JimiRasterImage getNextJimiImage(boolean allowSynchronous) throws JimiException {
        JimiRasterImage rasterImage;
        if (this.builtinJPEG) {
            if (this.cacheIndex == 0) {
                return this.cacheJimiImage;
            }
            if (this.seriesIndex == 0) {
                Image image;
                this.cacheImage = image = this.getBuiltinJPEG();
                this.cacheImageProducer = null;
                this.cacheJimiImage = null;
                this.cacheIndex = 0;
                ++this.seriesIndex;
                return Jimi.createRasterImage(image.getSource());
            }
            throw new JimiException();
        }
        JimiDecodingController controller = this.series.getNextController();
        JimiImage ji = controller.getJimiImage();
        if (allowSynchronous && this.synchronous) {
            controller.requestDecoding();
            ji.waitFinished();
        }
        if ((rasterImage = JimiUtil.asJimiRasterImage(ji)) == null) {
            throw new JimiException();
        }
        this.cacheJimiImage = rasterImage;
        this.cacheImageProducer = rasterImage.getImageProducer();
        this.cacheImage = null;
        this.cacheIndex = this.seriesIndex++;
        return rasterImage;
    }

    protected ImageProducer getNextImageProducer() throws JimiException {
        JimiRasterImage image;
        if (this.builtinJPEG) {
            if (this.cacheIndex == 0) {
                return this.cacheImageProducer;
            }
            if (this.seriesIndex == 0) {
                Image image2 = this.getBuiltinJPEG();
                this.cacheIndex = 0;
                this.cacheImage = image2;
                this.cacheImageProducer = image2.getSource();
                ++this.seriesIndex;
                return image2.getSource();
            }
            throw new JimiException();
        }
        this.cacheJimiImage = image = this.getNextJimiImage(false);
        this.cacheImageProducer = image.getImageProducer();
        this.cacheIndex = this.seriesIndex;
        return image.getImageProducer();
    }

    protected Image getNextImage() throws JimiException {
        Image image;
        if (this.builtinJPEG) {
            if (this.cacheIndex == 0) {
                if (this.cacheImage != null) {
                    return this.cacheImage;
                }
                Image image2 = Toolkit.getDefaultToolkit().createImage(this.cacheImageProducer);
                GraphicsUtils.waitForImage(image2);
                return image2;
            }
            if (this.seriesIndex == 0) {
                Image image3 = this.getBuiltinJPEG();
                this.cacheIndex = 0;
                this.cacheImage = image3;
                this.cacheImageProducer = image3.getSource();
                ++this.seriesIndex;
                GraphicsUtils.waitForImage(image3);
                return image3;
            }
            throw new JimiException();
        }
        ImageProducer producer = this.getNextImageProducer();
        this.cacheImage = image = Toolkit.getDefaultToolkit().createImage(producer);
        GraphicsUtils.waitForImage(image);
        return image;
    }

    protected boolean hasMoreElements() {
        if (this.builtinJPEG) {
            return this.seriesIndex == 0;
        }
        return this.series.hasMoreImages();
    }

    protected JimiDecodingController getNextController() {
        JimiDecodingController controller = this.series.getNextController();
        return controller;
    }

    protected Image getBuiltinImage() {
        JimiRasterImage rasterImage = null;
        try {
            rasterImage = this.getBuiltinJimiImage();
        }
        catch (JimiException e) {
            return JimiUtil.getErrorImage();
        }
        this.cacheJimiImage = rasterImage;
        this.cacheImageProducer = rasterImage.getImageProducer();
        Image image = Toolkit.getDefaultToolkit().createImage(rasterImage.getImageProducer());
        return image;
    }

    protected JimiRasterImage getBuiltinJimiImage() throws JimiException {
        Image image = this.getBuiltinJPEG();
        JimiRasterImage rasterImage = Jimi.createRasterImage(image.getSource(), this.imageFactory);
        return rasterImage;
    }

    protected Image getBuiltinJPEG() {
        Image awtimage = null;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        if (this.location != null) {
            awtimage = toolkit.getImage(this.location);
        } else if (this.filename != null) {
            awtimage = toolkit.getImage(this.filename);
        } else {
            try {
                ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
                byte[] buf = new byte[10240];
                int read_len = 0;
                while ((read_len = this.input.read(buf)) != -1) {
                    byteOut.write(buf, 0, read_len);
                }
                this.input.close();
                byte[] data = byteOut.toByteArray();
                awtimage = toolkit.createImage(data);
            }
            catch (IOException e) {
                awtimage = JimiUtil.getErrorImage();
            }
        }
        if (Jimi.crippled) {
            StampImageFilter filter = new StampImageFilter();
            FilteredImageSource prod = new FilteredImageSource(awtimage.getSource(), filter);
            awtimage = Toolkit.getDefaultToolkit().createImage(prod);
        }
        return awtimage;
    }

    class StreamCloseCommand
    implements Runnable {
        StreamCloseCommand() {
        }

        public void run() {
            try {
                JimiReader.this.input.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

