/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core;

import com.sun.jimi.core.JimiEncoder;
import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.JimiImage;
import com.sun.jimi.core.JimiImageEnumeration;
import com.sun.jimi.core.util.ProgressListener;
import java.io.IOException;
import java.io.OutputStream;

public abstract class JimiSingleImageEncoder
implements JimiEncoder {
    protected ProgressListener progressListener;

    public void encodeImage(JimiImage jimiImage, OutputStream output) throws JimiException {
        try {
            jimiImage.waitFinished();
            this.doEncodeImage(jimiImage, output);
        }
        catch (IOException ioe) {
            throw new JimiException(ioe.toString());
        }
    }

    public void encodeImage(JimiImage jimiImage, OutputStream output, ProgressListener listener) throws JimiException {
        this.progressListener = listener;
        try {
            jimiImage.waitFinished();
            this.progressListener.setStarted();
            this.doEncodeImage(jimiImage, output);
            this.progressListener.setFinished();
        }
        catch (JimiException je) {
            this.progressListener.setAbort(je.getMessage());
            throw je;
        }
        catch (IOException ioe) {
            this.progressListener.setAbort();
            throw new JimiException(ioe.toString());
        }
    }

    public abstract void doEncodeImage(JimiImage var1, OutputStream var2) throws JimiException, IOException;

    public void setProgress(int progressLevel) {
        if (this.progressListener != null) {
            this.progressListener.setProgressLevel(progressLevel);
        }
    }

    public void encodeImages(JimiImageEnumeration jimiImages, OutputStream output) throws JimiException {
        this.encodeImage(jimiImages.getNextImage(), output);
    }

    public void encodeImages(JimiImageEnumeration jimiImages, OutputStream output, ProgressListener listener) throws JimiException {
        this.encodeImage(jimiImages.getNextImage(), output, listener);
    }

    public abstract /* synthetic */ void setProgressListener(ProgressListener var1);
}

