/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core;

import com.sun.jimi.core.ImageSeriesDecodingController;
import com.sun.jimi.core.JimiDecodingController;
import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.JimiImageFactory;
import com.sun.jimi.core.JimiImageHandle;
import com.sun.jimi.core.JimiRasterDecoderSupport;
import com.sun.jimi.core.SingleImageSeriesDecodingController;
import com.sun.jimi.core.raster.MutableJimiRasterImage;
import java.io.IOException;
import java.io.InputStream;

public abstract class JimiSingleImageRasterDecoder
extends JimiRasterDecoderSupport {
    private JimiDecodingController controller;
    private JimiImageHandle handle;
    private boolean error;

    public ImageSeriesDecodingController initDecoding(JimiImageFactory factory, InputStream input) {
        super.init(factory, input);
        this.handle = new JimiImageHandle();
        this.controller = new JimiDecodingController(this.handle);
        Runnable r = new Runnable(){

            public void run() {
                JimiSingleImageRasterDecoder.this.driveDecoding();
            }
        };
        new Thread(r).start();
        return new SingleImageSeriesDecodingController(this.controller);
    }

    public void driveDecoding() {
        block6: {
            try {
                if (this.progressListener != null) {
                    this.progressListener.setStarted();
                }
                this.setJimiImage(this.doInitDecoding(this.getJimiImageFactory(), this.getInput()));
                this.doImageDecode();
                if (this.progressListener != null) {
                    this.progressListener.setFinished();
                }
            }
            catch (JimiException je) {
                if (this.progressListener != null) {
                    this.progressListener.setAbort(je.getMessage());
                }
            }
            catch (IOException ioe) {
                if (this.progressListener == null) break block6;
                this.progressListener.setAbort();
            }
        }
        this.cleanup();
    }

    public abstract MutableJimiRasterImage doInitDecoding(JimiImageFactory var1, InputStream var2) throws JimiException, IOException;

    public abstract void doImageDecode() throws JimiException, IOException;

    public void setProgress(int progressLevel) {
        if (this.controller.hasProgressListener()) {
            this.controller.getProgressListener().setProgressLevel(progressLevel);
        }
    }

    private synchronized void setJimiImage(MutableJimiRasterImage jimiImage) {
        jimiImage.setDecodingController(this.controller);
        this.handle.setJimiImage(jimiImage);
        this.controller.waitDecodingRequest();
    }

    public JimiImageFactory getJimiImageFactory() {
        return this.factory;
    }

    public InputStream getInput() {
        return this.input;
    }
}

