/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core;

import com.sun.jimi.core.Jimi;
import com.sun.jimi.core.filters.AspectAdjustReplicateScaleFilter;
import com.sun.jimi.core.filters.AspectReplicateScaleFilter;
import com.sun.jimi.core.raster.JimiRasterImage;
import com.sun.jimi.core.util.JimiUtil;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageProducer;
import java.io.InputStream;
import java.net.URL;

public class JimiUtils {
    public static ImageProducer aspectAdjust(JimiRasterImage image) {
        if (image == null) {
            return JimiUtil.getErrorImageProducer();
        }
        image.waitInfoAvailable();
        if (image.getProperties() == null) {
            return image.getImageProducer();
        }
        if (image.getProperties().get("fixedaspect") != null) {
            return image.getImageProducer();
        }
        Object xresProperty = image.getProperties().get("xres");
        Object yresProperty = image.getProperties().get("yres");
        if (xresProperty != null && yresProperty != null && xresProperty instanceof Number && yresProperty instanceof Number) {
            double yres;
            double xres = ((Number)xresProperty).doubleValue();
            if (xres == (yres = ((Number)yresProperty).doubleValue())) {
                return image.getImageProducer();
            }
            AspectAdjustReplicateScaleFilter filter = new AspectAdjustReplicateScaleFilter(xres, yres);
            FilteredImageSource prod = new FilteredImageSource(image.getImageProducer(), filter);
            return prod;
        }
        return image.getImageProducer();
    }

    public static Image getThumbnail(String filename, int width, int height, int flags) {
        return Toolkit.getDefaultToolkit().createImage(JimiUtils.getThumbnailProducer(filename, width, height, flags));
    }

    public static ImageProducer getThumbnailProducer(String filename, int width, int height, int flags) {
        ImageProducer producer = Jimi.getImageProducer(filename, flags);
        AspectReplicateScaleFilter filter = new AspectReplicateScaleFilter(width, height);
        FilteredImageSource source = new FilteredImageSource(producer, filter);
        return source;
    }

    public static Image getThumbnail(URL location, int width, int height, int flags) {
        return Toolkit.getDefaultToolkit().createImage(JimiUtils.getThumbnailProducer(location, width, height, flags));
    }

    public static ImageProducer getThumbnailProducer(URL location, int width, int height, int flags) {
        ImageProducer producer = Jimi.getImageProducer(location, flags);
        AspectReplicateScaleFilter filter = new AspectReplicateScaleFilter(width, height);
        FilteredImageSource source = new FilteredImageSource(producer, filter);
        return source;
    }

    public static Image getThumbnail(InputStream input, int width, int height, int flags) {
        return Toolkit.getDefaultToolkit().createImage(JimiUtils.getThumbnailProducer(input, width, height, flags));
    }

    public static ImageProducer getThumbnailProducer(InputStream input, int width, int height, int flags) {
        ImageProducer producer = Jimi.getImageProducer(input, flags);
        AspectReplicateScaleFilter filter = new AspectReplicateScaleFilter(width, height);
        FilteredImageSource source = new FilteredImageSource(producer, filter);
        return source;
    }

    public static Image getThumbnail(InputStream input, int width, int height, int flags, String typeID) {
        return Toolkit.getDefaultToolkit().createImage(JimiUtils.getThumbnailProducer(input, width, height, flags, typeID));
    }

    public static ImageProducer getThumbnailProducer(InputStream input, int width, int height, int flags, String typeID) {
        ImageProducer producer = Jimi.getImageProducer(input, typeID, flags);
        AspectReplicateScaleFilter filter = new AspectReplicateScaleFilter(width, height);
        FilteredImageSource source = new FilteredImageSource(producer, filter);
        return source;
    }
}

