/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core;

import com.sun.jimi.core.InvalidOptionException;
import com.sun.jimi.core.Jimi;
import com.sun.jimi.core.JimiControl;
import com.sun.jimi.core.JimiEncoder;
import com.sun.jimi.core.JimiEncoderFactory;
import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.JimiImage;
import com.sun.jimi.core.JimiImageEnumeration;
import com.sun.jimi.core.MutableJimiImage;
import com.sun.jimi.core.options.BasicFormatOptionSet;
import com.sun.jimi.core.options.FormatOption;
import com.sun.jimi.core.options.FormatOptionSet;
import com.sun.jimi.core.options.OptionException;
import com.sun.jimi.core.util.FreeFormat;
import com.sun.jimi.core.util.JimiUtil;
import com.sun.jimi.core.util.ProgressListener;
import java.awt.Image;
import java.awt.image.ImageProducer;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;

public class JimiWriter {
    protected JimiEncoder encoder;
    protected JimiImage sourceImage;
    protected JimiImageEnumeration sourceImageEnumeration;
    protected FormatOptionSet options = new BasicFormatOptionSet();
    protected FormatOptionSet overrideOptions;
    protected ProgressListener listener;

    protected JimiWriter(String filename, String mimeType) throws JimiException {
        JimiEncoderFactory factory = JimiControl.getEncoderByType(mimeType);
        if (factory == null) {
            throw new JimiException("Cannot find encoder for type: " + mimeType);
        }
        this.initJimiWriter(factory);
    }

    protected JimiWriter(String filename) throws JimiException {
        JimiEncoderFactory factory = JimiControl.getEncoderByFileExtension(filename);
        if (factory == null) {
            throw new JimiException("Cannot find encoder for " + filename);
        }
        this.initJimiWriter(factory);
    }

    protected JimiWriter(OutputStream output, String mimeType) throws JimiException {
        JimiEncoderFactory factory = JimiControl.getEncoderByType(mimeType);
        if (factory == null) {
            throw new JimiException("Cannot find encoder for type: " + mimeType);
        }
        this.initJimiWriter(factory);
    }

    protected JimiWriter() {
    }

    protected void setMimeType(String typeID) throws JimiException {
        JimiEncoderFactory factory = JimiControl.getEncoderByType(typeID);
        if (factory == null) {
            throw new JimiException("Cannot find encoder for type: " + typeID);
        }
        this.initJimiWriter(factory);
    }

    protected void initJimiWriter(JimiEncoderFactory factory) throws JimiException {
        if (Jimi.crippled) {
            throw new JimiException("Keyless operations does not permit saving.");
        }
        if (Jimi.limited && !(factory instanceof FreeFormat)) {
            throw new JimiException("This format requires a JIMI Pro license.");
        }
        this.encoder = factory.createEncoder();
        if (this.listener != null) {
            this.encoder.setProgressListener(this.listener);
        }
    }

    public void setOptions(FormatOptionSet options) {
        this.options = options;
        this.overrideOptions = options;
    }

    public void setProgressListener(ProgressListener listener) {
        this.listener = listener;
        if (this.encoder != null) {
            this.encoder.setProgressListener(listener);
        }
    }

    public void setSource(JimiImage ji) throws JimiException {
        this.sourceImage = JimiUtil.asJimiRasterImage(ji);
        if (this.overrideOptions != null) {
            ((MutableJimiImage)this.sourceImage).setOptions(this.overrideOptions);
        }
    }

    public void setSource(Image image) throws JimiException {
        this.setSource(image.getSource());
    }

    public void setSource(ImageProducer producer) throws JimiException {
        try {
            this.sourceImage = Jimi.createRasterImage(producer);
        }
        catch (JimiException jimiException) {
            // empty catch block
        }
    }

    public void setSource(JimiImage[] images) throws JimiException {
        this.sourceImageEnumeration = new JimiImageEnumeration(images);
    }

    public void setSource(ImageProducer[] producers) throws JimiException {
        this.sourceImageEnumeration = new JimiImageEnumeration(producers);
    }

    public void setSource(Image[] images) throws JimiException {
        this.sourceImageEnumeration = new JimiImageEnumeration(images);
    }

    public void setSource(Object[] images) throws JimiException {
        if (images instanceof JimiImage[]) {
            this.setSource((JimiImage[])images);
        } else if (images instanceof ImageProducer[]) {
            this.setSource((ImageProducer[])images);
        } else if (images instanceof Image[]) {
            this.setSource((Image[])images);
        } else {
            throw new JimiException("Invalid source.");
        }
    }

    public void putImage(String filename) throws JimiException {
        try {
            OutputStream output = new FileOutputStream(filename);
            output = new BufferedOutputStream(output);
            this.putImage(output);
            output.close();
        }
        catch (IOException e) {
            throw new JimiException();
        }
    }

    public void putImage(OutputStream output) throws JimiException {
        if (this.sourceImage != null) {
            this.sourceImage.setOptions(this.options);
            this.encoder.encodeImages(new JimiImageEnumeration(this.sourceImage), output);
        } else if (this.sourceImageEnumeration != null) {
            this.sourceImageEnumeration.setOptions(this.options);
            this.encoder.encodeImages(this.sourceImageEnumeration, output);
        } else {
            throw new JimiException("No source image set.");
        }
    }

    public Object getPossibleValuesForProperty(String name) throws InvalidOptionException {
        try {
            return this.options.getOption(name).getPossibleValues();
        }
        catch (OptionException e) {
            throw new InvalidOptionException(e.getMessage());
        }
    }

    public String getPropertyDescription(String name) throws InvalidOptionException {
        try {
            return this.options.getOption(name).getDescription();
        }
        catch (OptionException e) {
            throw new InvalidOptionException(e.getMessage());
        }
    }

    public void clearProperties() {
        this.options = new BasicFormatOptionSet();
    }

    public Object getProperty(String name) {
        try {
            return this.options.getOption(name).getValue();
        }
        catch (OptionException e) {
            return null;
        }
    }

    public Enumeration getPropertyNames() {
        final FormatOption[] formatOptions = this.options.getOptions();
        return new Enumeration(){
            int index = 0;

            public boolean hasMoreElements() {
                return this.index < formatOptions.length;
            }

            public Object nextElement() {
                return formatOptions[this.index++];
            }
        };
    }

    public void setProperty(String name, Object value) throws InvalidOptionException {
        try {
            this.options.getOption(name).setValue(value);
        }
        catch (OptionException e) {
            throw new InvalidOptionException(e.getMessage());
        }
    }
}

