/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core;

import com.sun.jimi.core.JimiImageFactory;
import com.sun.jimi.core.MemoryJimiImageFactory;
import com.sun.jimi.core.VMMControl;
import com.sun.jimi.core.raster.BitRasterImage;
import com.sun.jimi.core.raster.ByteRasterImage;
import com.sun.jimi.core.raster.ChanneledIntRasterImage;
import com.sun.jimi.core.raster.IntRasterImage;
import com.sun.jimi.core.raster.VMemByteRasterImage;
import com.sun.jimi.core.raster.VMemChanneledIntRasterImage;
import com.sun.jimi.core.raster.VMemIntRasterImage;
import com.sun.jimi.util.FileRandomAccessStorage;
import com.sun.jimi.util.RandomAccessStorage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.File;
import java.io.IOException;

public class VMemJimiImageFactory
implements JimiImageFactory {
    protected static long id;
    protected JimiImageFactory memoryFactory = new MemoryJimiImageFactory();

    public IntRasterImage createIntRasterImage(int w, int h, ColorModel cm) {
        try {
            if (w * h * 4 < VMMControl.threshold) {
                return this.memoryFactory.createIntRasterImage(w, h, cm);
            }
            return new VMemIntRasterImage(VMemJimiImageFactory.createNextStorage(VMMControl.getDirectory()), w, h, cm);
        }
        catch (Exception e) {
            return null;
        }
    }

    public ByteRasterImage createByteRasterImage(int w, int h, ColorModel cm) {
        try {
            if (w * h < VMMControl.threshold) {
                return this.memoryFactory.createByteRasterImage(w, h, cm);
            }
            return new VMemByteRasterImage(VMemJimiImageFactory.createNextStorage(VMMControl.getDirectory()), w, h, cm);
        }
        catch (Exception e) {
            return null;
        }
    }

    public BitRasterImage createBitRasterImage(int w, int h, ColorModel cm) {
        try {
            if (w * h / 8 < VMMControl.threshold) {
                return this.memoryFactory.createBitRasterImage(w, h, cm);
            }
            int color0 = cm.getRGB(0);
            int color1 = cm.getRGB(1);
            byte[] alphas = new byte[]{(byte)(color0 >> 24 & 0xFF), (byte)(color1 >> 24 & 0xFF)};
            byte[] reds = new byte[]{(byte)(color0 >> 16 & 0xFF), (byte)(color1 >> 16 & 0xFF)};
            byte[] greens = new byte[]{(byte)(color0 >> 8 & 0xFF), (byte)(color1 >> 8 & 0xFF)};
            byte[] blues = new byte[]{(byte)(color0 >> 0 & 0xFF), (byte)(color1 >> 0 & 0xFF)};
            cm = new IndexColorModel(8, 2, reds, greens, blues, alphas);
            return (BitRasterImage)this.createByteRasterImage(w, h, cm);
        }
        catch (Exception e) {
            return null;
        }
    }

    public ChanneledIntRasterImage createChanneledIntRasterImage(int w, int h, ColorModel cm) {
        try {
            if (w * h * 4 < VMMControl.threshold) {
                return this.memoryFactory.createChanneledIntRasterImage(w, h, cm);
            }
            return new VMemChanneledIntRasterImage(VMemJimiImageFactory.createNextStorage(VMMControl.getDirectory()), w, h, cm);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected static synchronized RandomAccessStorage createNextStorage(File directory) throws IOException {
        String filename;
        File file = null;
        while ((file = new File(filename = directory + "/" + "jimidat." + ++id)).exists() && !file.delete()) {
        }
        FileRandomAccessStorage storage = new FileRandomAccessStorage(file);
        return storage;
    }
}

