/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.compat;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.JimiImageFactory;
import com.sun.jimi.core.compat.JimiDecoderBase;
import com.sun.jimi.core.options.FormatOptionSet;
import com.sun.jimi.core.raster.BitRasterImage;
import com.sun.jimi.core.raster.ByteRasterImage;
import com.sun.jimi.core.raster.ChanneledIntRasterImage;
import com.sun.jimi.core.raster.IntRasterImage;
import com.sun.jimi.core.raster.JimiRasterImage;
import com.sun.jimi.core.raster.MutableJimiRasterImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.util.Enumeration;
import java.util.Hashtable;

public class AdaptiveRasterImage {
    public static final int CHANNEL_ALPHA = 24;
    public static final int CHANNEL_RED = 16;
    public static final int CHANNEL_GREEN = 8;
    public static final int CHANNEL_BLUE = 0;
    public static final int NO_ALPHA = 0;
    public static final int ALPHA_DATA = 1;
    public static final int ALPHA = 0;
    public static final int RED = 1;
    public static final int GREEN = 2;
    public static final int BLUE = 3;
    protected static final int MODE_INT = 0;
    protected static final int MODE_BYTE = 1;
    protected static final int MODE_BIT = 2;
    protected static final int MODE_CHANNELED = 3;
    protected int mode;
    protected ColorModel cm;
    protected int hints = -1;
    protected int width;
    protected int height;
    protected JimiImageFactory factory;
    protected IntRasterImage intImage;
    protected ChanneledIntRasterImage channelImage;
    protected ByteRasterImage byteImage;
    protected BitRasterImage bitImage;
    protected JimiRasterImage rasterImage;
    protected MutableJimiRasterImage mutableImage;
    protected JimiDecoderBase decoder;
    protected boolean rgbDefault = false;
    protected Hashtable properties = new Hashtable();
    protected Boolean alphaSignificant;
    protected boolean waitForOptions;
    protected FormatOptionSet options;

    public AdaptiveRasterImage(JimiImageFactory factory) {
        this.factory = factory;
    }

    public AdaptiveRasterImage(JimiImageFactory factory, JimiDecoderBase decoder) {
        this(factory);
        this.setDecoder(decoder);
        this.setWaitForOptions(decoder.mustWaitForOptions());
    }

    public AdaptiveRasterImage(JimiRasterImage ji) {
        this.rasterImage = ji;
        this.width = ji.getWidth();
        this.height = ji.getHeight();
        if (ji instanceof ChanneledIntRasterImage) {
            this.mode = 3;
            this.channelImage = (ChanneledIntRasterImage)ji;
            this.intImage = this.channelImage;
        } else if (ji instanceof IntRasterImage) {
            this.intImage = (IntRasterImage)ji;
            this.mode = 0;
        } else if (ji instanceof ByteRasterImage) {
            this.byteImage = (ByteRasterImage)ji;
            this.mode = 1;
        } else if (ji instanceof BitRasterImage) {
            this.bitImage = (BitRasterImage)ji;
            this.mode = 2;
        }
    }

    public JimiRasterImage getBackend() {
        return this.rasterImage;
    }

    public void setDecoder(JimiDecoderBase decoder) {
        this.decoder = decoder;
    }

    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public int getWidth() {
        return this.rasterImage == null ? this.width : this.rasterImage.getWidth();
    }

    public int getHeight() {
        return this.rasterImage == null ? this.height : this.rasterImage.getHeight();
    }

    public ColorModel getColorModel() {
        return this.rasterImage == null ? this.cm : this.rasterImage.getColorModel();
    }

    public void setColorModel(ColorModel cm) {
        this.cm = cm;
    }

    public void setOptions(FormatOptionSet options) {
        this.options = options;
        if (this.mutableImage != null) {
            this.mutableImage.setOptions(options);
        }
    }

    public FormatOptionSet getOptions() {
        return this.rasterImage.getOptions();
    }

    public void setHints(int hints) {
        this.hints = hints;
        if (this.mutableImage != null) {
            this.mutableImage.setImageConsumerHints(hints);
        }
    }

    public void setPixels() throws JimiException {
        this.createBackEnd();
    }

    protected void createBackEnd() throws JimiException {
        int pixelSize = this.cm.getPixelSize();
        if (pixelSize == 1) {
            this.bitImage = this.factory.createBitRasterImage(this.width, this.height, this.cm);
            this.mutableImage = this.bitImage;
            this.rasterImage = this.bitImage;
            this.mode = 2;
        } else if (pixelSize <= 8) {
            this.byteImage = this.factory.createByteRasterImage(this.width, this.height, this.cm);
            this.mutableImage = this.byteImage;
            this.rasterImage = this.byteImage;
            this.mode = 1;
        } else if (this.decoder != null && this.decoder.usesChanneledData()) {
            this.channelImage = this.factory.createChanneledIntRasterImage(this.width, this.height, this.cm);
            this.intImage = this.channelImage;
            this.mutableImage = this.channelImage;
            this.rasterImage = this.channelImage;
            this.mode = 3;
        } else {
            this.intImage = this.factory.createIntRasterImage(this.width, this.height, this.cm);
            this.mutableImage = this.intImage;
            this.rasterImage = this.intImage;
            this.mode = 0;
        }
        if (this.hints != -1) {
            this.mutableImage.setImageConsumerHints(this.hints);
        }
        Enumeration keys = this.properties.keys();
        while (keys.hasMoreElements()) {
            Hashtable props = this.mutableImage.getProperties();
            Object key = keys.nextElement();
            props.put(key, this.properties.get(key));
        }
        if (this.options != null) {
            this.mutableImage.setOptions(this.options);
        }
        if (this.decoder != null) {
            this.decoder.jimiImageCreated(this.mutableImage);
        }
    }

    public void setAbort() {
        this.setError();
    }

    public void setError() {
        this.mutableImage.setError();
    }

    public void setRGBDefault(boolean rgb) {
        this.rgbDefault = rgb;
    }

    public void addFullCoverage() {
        if (this.mutableImage != null) {
            this.mutableImage.setFinished();
        }
    }

    public synchronized void setChannel(int channel, int x, int y, int w, int h, byte[] pixels, int off, int scansize) throws JimiException {
        switch (this.mode) {
            case 3: {
                this.channelImage.setChannelRectangle(channel, x, y, w, h, pixels, off, scansize);
                break;
            }
            case 0: {
                throw new JimiException();
            }
            case 1: {
                this.byteImage.setRectangle(x, y, w, h, pixels, off, scansize);
                break;
            }
            case 2: {
                this.bitImage.setRectangle(x, y, w, h, pixels, off, scansize);
            }
        }
    }

    public void setChannel(int x, int y, int w, int h, int[] pixels, int off, int scansize) throws JimiException {
        switch (this.mode) {
            case 0: 
            case 3: {
                this.intImage.setRectangle(x, y, w, h, pixels, off, scansize);
                break;
            }
            default: {
                throw new JimiException();
            }
        }
    }

    public void setPackedChannel(int row, byte[] pixels, int off, int len) throws JimiException {
        switch (this.mode) {
            case 2: {
                this.bitImage.setRectanglePacked(0, row, this.width, 1, pixels, off, len);
                break;
            }
            default: {
                throw new JimiException();
            }
        }
    }

    public void setPackedChannel(int row, byte[] pixels) throws JimiException {
        this.setPackedChannel(row, pixels, 0, this.width);
    }

    public void setChannel(int channel, int row, byte[] pixels, int off, int len) throws JimiException {
        this.setChannel(channel, 0, row, this.width, 1, pixels, off, len);
    }

    public void setChannel(int channel, int row, byte[] pixels) throws JimiException {
        this.setChannel(channel, row, pixels, 0, this.width);
    }

    public void setChannel(int row, int[] pixels) throws JimiException {
        this.setChannel(0, row, this.width, 1, pixels, 0, this.width);
    }

    public void setChannel(long val) throws JimiException {
    }

    public void getChannel(int channel, int x, int y, int w, int h, byte[] pixels, int off, int scansize) throws JimiException {
        switch (this.mode) {
            case 0: {
                this.intImage.getChannelRectangle(channel, x, y, w, h, pixels, off, scansize);
                break;
            }
            case 3: {
                this.channelImage.getChannelRectangle(channel, x, y, w, h, pixels, off, scansize);
                break;
            }
            case 1: {
                this.byteImage.getRectangle(x, y, w, h, pixels, off, scansize);
                break;
            }
            case 2: {
                this.bitImage.getRectangle(x, y, w, h, pixels, off, scansize);
                break;
            }
            default: {
                throw new JimiException("");
            }
        }
    }

    public void getChannel(int x, int y, int w, int h, int[] pixels, int off, int scansize) throws JimiException {
        if (this.rgbDefault) {
            this.rasterImage.getRectangleRGB(x, y, w, h, pixels, off, scansize);
        } else {
            switch (this.mode) {
                case 0: 
                case 3: {
                    this.intImage.getRectangle(x, y, w, h, pixels, off, scansize);
                    break;
                }
                default: {
                    byte[] buf = new byte[this.getWidth()];
                    for (int row = 0; row < h; ++row) {
                        if (this.mode == 1) {
                            this.byteImage.getRow(y, buf, off);
                        } else if (this.mode == 2) {
                            this.bitImage.getRow(y, buf, off);
                        } else {
                            throw new JimiException("int[] getChannel on non-int image");
                        }
                        for (int column = 0; column < w; ++column) {
                            pixels[off + row * scansize + column] = buf[column] & 0xFF;
                        }
                    }
                }
            }
        }
    }

    public void getChannel(int channel, int row, byte[] pixels, int off) throws JimiException {
        this.getChannel(channel, 0, row, this.getWidth(), 1, pixels, off, 0);
    }

    public void getChannelRGB(int row, byte[] pixels, int off) throws JimiException {
        this.rasterImage.getRectangleRGBChannels(0, row, this.getWidth(), 1, pixels, off, this.getWidth());
    }

    public void getChannelRGBA(int row, byte[] pixels, int off) throws JimiException {
        this.rasterImage.getRectangleRGBAChannels(0, row, this.getWidth(), 1, pixels, off, this.getWidth());
    }

    public void getChannel(int row, int[] pixels, int off) throws JimiException {
        this.getChannel(0, row, this.width, 1, pixels, off, 0);
    }

    public long getChannel(int x, int y) throws JimiException {
        return this.rasterImage.getPixelRGB(x, y);
    }

    public void setChannel(int x, int y, long value) throws JimiException {
        switch (this.mode) {
            case 0: {
                this.intImage.setPixel(x, y, (int)value);
                break;
            }
            case 1: {
                this.byteImage.setPixel(x, y, (byte)value);
            }
        }
    }

    public void setProperty(String name, Object value) {
        if (this.mutableImage != null) {
            this.mutableImage.getProperties().put(name, value);
        } else {
            this.properties.put(name, value);
        }
    }

    public int getAlphaStatus() {
        if (this.alphaSignificant != null) {
            return this.alphaSignificant != false ? 1 : 0;
        }
        if (this.cm instanceof DirectColorModel && ((DirectColorModel)this.cm).getAlphaMask() != 0) {
            this.alphaSignificant = new Boolean(true);
            return this.getAlphaStatus();
        }
        if (this.cm instanceof IndexColorModel) {
            IndexColorModel icm = (IndexColorModel)this.cm;
            byte[] alphas = new byte[icm.getMapSize()];
            icm.getAlphas(alphas);
            for (int i = 0; i < alphas.length; ++i) {
                if (alphas[i] == 255) continue;
                this.alphaSignificant = new Boolean(true);
                return this.getAlphaStatus();
            }
        }
        this.alphaSignificant = new Boolean(false);
        return this.getAlphaStatus();
    }

    public void setWaitForOptions(boolean wait) {
        if (this.mutableImage != null) {
            this.mutableImage.setWaitForOptions(wait);
        }
        this.waitForOptions = wait;
    }
}

