/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.compat;

import com.sun.jimi.core.JimiEncoder;
import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.JimiImage;
import com.sun.jimi.core.JimiImageEnumeration;
import com.sun.jimi.core.JimiImageFactory;
import com.sun.jimi.core.compat.AdaptiveRasterImage;
import com.sun.jimi.core.raster.JimiRasterImage;
import com.sun.jimi.core.util.JimiImageColorReducer;
import com.sun.jimi.core.util.JimiUtil;
import com.sun.jimi.core.util.ProgressListener;
import com.sun.jimi.core.util.ProgressMonitorSupport;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.OutputStream;

public abstract class JimiEncoderBase
extends ProgressMonitorSupport
implements JimiEncoder {
    public static final int MULTIIMAGE = 1;
    public static final int ERROR = 1;
    public static final int DONE = 2;
    public static final int NEXTIMAGE = 4;
    protected AdaptiveRasterImage currentImage;
    protected JimiImageFactory factory;
    protected static final int MAX_COLORS_RGB = -1;

    public void encodeImage(JimiImage jimiImage, OutputStream output) throws JimiException {
        jimiImage.waitFinished();
        if (this.progressListener != null) {
            this.progressListener.setStarted();
        }
        try {
            AdaptiveRasterImage adaptiveImage;
            if (!(jimiImage instanceof JimiRasterImage)) {
                throw new JimiException("Only encodes RasterImages.");
            }
            JimiRasterImage r = JimiUtil.asJimiRasterImage(jimiImage);
            if (this.getMaxColors() != -1 && !(r.getColorModel() instanceof IndexColorModel)) {
                JimiImageColorReducer reducer = new JimiImageColorReducer(this.getMaxColors());
                r = reducer.colorReduceFS(r);
            }
            this.currentImage = adaptiveImage = new AdaptiveRasterImage(r);
            this.setNumberOfImages(1);
            this.initSpecificEncoder(output, adaptiveImage);
            this.setJimiImage(adaptiveImage);
            while (this.driveEncoder()) {
            }
            if (this.progressListener != null) {
                this.progressListener.setFinished();
            }
        }
        catch (JimiException je) {
            if (this.progressListener != null) {
                this.progressListener.setAbort();
            }
            throw je;
        }
    }

    public void encodeImage(JimiImage jimiImage, OutputStream output, ProgressListener listener) throws JimiException {
        this.progressListener = listener;
        this.encodeImage(jimiImage, output);
    }

    public void encodeImages(JimiImageEnumeration jimiImages, OutputStream output) throws JimiException {
        this.setNumberOfImages(jimiImages.countImages());
        if (this.progressListener != null) {
            this.progressListener.setStarted();
        }
        try {
            int state;
            AdaptiveRasterImage adaptiveImage;
            JimiRasterImage image = JimiUtil.asJimiRasterImage(jimiImages.getNextImage());
            if (this.getMaxColors() != -1 && !(image.getColorModel() instanceof IndexColorModel)) {
                JimiImageColorReducer reducer = new JimiImageColorReducer(this.getMaxColors());
                image = reducer.colorReduceFS(image);
            }
            this.currentImage = adaptiveImage = new AdaptiveRasterImage(image);
            this.factory = image.getFactory();
            this.initSpecificEncoder(output, adaptiveImage);
            this.setNumberOfImages(jimiImages.countImages());
            this.setJimiImage(adaptiveImage);
            do {
                this.driveEncoder();
                state = this.getState();
                if (state != 4) continue;
                adaptiveImage = new AdaptiveRasterImage(JimiUtil.asJimiRasterImage(jimiImages.getNextImage()));
                this.setJimiImage(adaptiveImage);
            } while ((state & 1) == 0 && (state & 2) == 0);
            if (state == 1) {
                throw new JimiException("Error during encoding.");
            }
            if (this.progressListener != null) {
                this.progressListener.setFinished();
            }
        }
        catch (JimiException je) {
            if (this.progressListener != null) {
                this.progressListener.setAbort();
            }
            throw je;
        }
    }

    public void encodeImages(JimiImageEnumeration jimiImages, OutputStream output, ProgressListener listener) throws JimiException {
    }

    public AdaptiveRasterImage createAdaptiveRasterImage() {
        return new AdaptiveRasterImage(this.factory);
    }

    public AdaptiveRasterImage createAdaptiveRasterImage(int w, int h, ColorModel cm) {
        AdaptiveRasterImage image = new AdaptiveRasterImage(this.factory);
        image.setSize(w, h);
        image.setColorModel(cm);
        return image;
    }

    public void setProgress(int progress) {
        if (this.progressListener != null) {
            this.progressListener.setProgressLevel(progress);
        }
    }

    public abstract boolean driveEncoder() throws JimiException;

    protected void setJimiImage(AdaptiveRasterImage ji) throws JimiException {
    }

    protected abstract void initSpecificEncoder(OutputStream var1, AdaptiveRasterImage var2) throws JimiException;

    protected void freeEncoder() throws JimiException {
    }

    public void setNumberOfImages(int imageCount) {
    }

    protected AdaptiveRasterImage getJimiImage() {
        return this.currentImage;
    }

    protected int getCapabilties() {
        return 0;
    }

    protected int getState() {
        return 0;
    }

    protected int getMaxColors() {
        return -1;
    }
}

