/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.component;

import com.sun.jimi.core.Jimi;
import com.sun.jimi.core.component.JimiCanvas;
import com.sun.jimi.core.component.JimiImageRenderer;
import com.sun.jimi.core.raster.JimiRasterImage;
import com.sun.jimi.core.util.GraphicsUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.ImageProducer;

public abstract class AbstractRenderer
extends Panel
implements JimiImageRenderer {
    public JimiRasterImage raster;
    public Image image;
    public ImageProducer producer;
    public JimiCanvas canvas;

    public AbstractRenderer() {
        this.addComponentListener(new ResizeWatcher());
    }

    public void setRasterImage(JimiRasterImage raster) {
        if (raster == null) {
            this.setImage(null);
        } else {
            this.raster = raster;
            this.producer = raster.getImageProducer();
            this.image = null;
            this.render();
        }
    }

    public void setImageProducer(ImageProducer producer) {
        if (producer == null) {
            this.setImage(null);
        } else {
            this.image = null;
            this.producer = producer;
            this.raster = null;
            this.render();
        }
    }

    public void setImage(Image image) {
        if (image == null) {
            this.image = null;
            this.producer = null;
            this.raster = null;
        } else {
            this.image = image;
            this.producer = image.getSource();
        }
        this.render();
    }

    public Component getContentPane() {
        if (this.image != null) {
            this.render();
        }
        return this;
    }

    public void render() {
        this.repaint();
    }

    public Dimension getPreferredSize() {
        if (this.image != null) {
            return new Dimension(this.image.getWidth(this), this.image.getHeight(this));
        }
        return super.getPreferredSize();
    }

    public synchronized void paint(Graphics g) {
        this.blankBackground(g);
        if (this.producer == null) {
            return;
        }
        Image image = this.getImage();
        int xWidth = this.size().width;
        int yHeight = this.size().height;
        int yStart = 0;
        int xStart = 0;
        int imageWidth = image.getWidth(this);
        int imageHeight = image.getHeight(this);
        switch (this.canvas.getJustificationPolicy()) {
            case 0: {
                xStart = (xWidth - imageWidth) / 2;
                yStart = (yHeight - imageHeight) / 2;
                break;
            }
            case 18: {
                xStart = 0;
                yStart = 0;
                break;
            }
            case 10: {
                xStart = xWidth - imageWidth;
                yStart = 0;
                break;
            }
            case 2: {
                xStart = (xWidth - imageWidth) / 2;
                yStart = 0;
                break;
            }
            case 4: {
                xStart = (xWidth - imageWidth) / 2;
                yStart = yHeight - imageHeight;
                break;
            }
            case 20: {
                xStart = 0;
                yStart = yHeight - imageHeight;
                break;
            }
            case 12: {
                xStart = xWidth - imageWidth;
                yStart = yHeight - imageHeight;
                break;
            }
            case 8: {
                xStart = xWidth - imageWidth;
                yStart = (yHeight - imageHeight) / 2;
                break;
            }
            case 16: {
                xStart = 0;
                yStart = (yHeight - imageHeight) / 2;
            }
        }
        g.drawImage(image, xStart, yStart, this);
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public Image getImage() {
        if (this.image != null) {
            return this.image;
        }
        if (this.producer != null) {
            Image i = Toolkit.getDefaultToolkit().createImage(this.producer);
            GraphicsUtils.waitForImage(i);
            this.image = i;
            return i;
        }
        return null;
    }

    public JimiRasterImage getRasterImage() {
        if (this.raster != null) {
            return this.raster;
        }
        if (this.producer != null) {
            try {
                return Jimi.createRasterImage(this.producer);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public final void blankBackground(Graphics g) {
        g.setColor(this.getForeground());
        g.fillRect(0, 0, this.canvas.size().width, this.canvas.size().height);
    }

    public class ResizeWatcher
    extends ComponentAdapter {
        public void componentResized(ComponentEvent event) {
            AbstractRenderer.this.render();
        }
    }
}

