/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.component;

import com.sun.jimi.core.component.AbstractRenderer;
import com.sun.jimi.core.component.JimiCanvas;
import com.sun.jimi.core.filters.ReplicatingScaleFilter;
import com.sun.jimi.core.raster.JimiRasterImage;
import com.sun.jimi.core.util.GraphicsUtils;
import java.awt.Toolkit;
import java.awt.image.AreaAveragingScaleFilter;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;

public class BestFitRenderer
extends AbstractRenderer {
    public BestFitRenderer(JimiCanvas canvas) {
        this.canvas = canvas;
    }

    public void render() {
        int yDistance;
        int xDistance;
        int imageHeight;
        int height;
        float yRatio;
        JimiRasterImage image = this.getRasterImage();
        if (image == null) {
            return;
        }
        int width = this.canvas.size().width;
        int imageWidth = image.getWidth();
        float xRatio = (float)width / (float)imageWidth;
        if (xRatio < (yRatio = (float)(height = this.canvas.size().height) / (float)(imageHeight = image.getHeight()))) {
            xDistance = (int)((float)imageWidth * xRatio);
            yDistance = (int)((float)imageHeight * xRatio);
        } else {
            xDistance = (int)((float)imageWidth * yRatio);
            yDistance = (int)((float)imageHeight * yRatio);
        }
        ImageFilter filter = this.canvas.getScalingPolicy() == 0 ? new AreaAveragingScaleFilter(xDistance, yDistance) : new ReplicatingScaleFilter(xDistance, yDistance);
        FilteredImageSource prod = new FilteredImageSource(image.getImageProducer(), filter);
        this.image = Toolkit.getDefaultToolkit().createImage(prod);
        GraphicsUtils.waitForImage(this.image);
        super.render();
    }
}

