/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.component;

import com.sun.jimi.core.component.AbstractRenderer;
import com.sun.jimi.core.component.JimiCanvas;
import com.sun.jimi.core.component.JimiImageRenderer;
import com.sun.jimi.core.raster.JimiRasterImage;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.image.ImageProducer;

public class CompositeRenderer
extends AbstractRenderer {
    public JimiImageRenderer primary;
    public JimiImageRenderer secondary;

    public CompositeRenderer() {
        this.setLayout(new BorderLayout(0, 0));
    }

    public CompositeRenderer(JimiCanvas canvas, JimiImageRenderer primary, JimiImageRenderer secondary) {
        this();
        this.canvas = canvas;
        this.primary = primary;
        this.secondary = secondary;
    }

    public void setImage(Image image) {
        this.image = image;
        this.primary.setImage(image);
        this.secondary.setImage(image);
    }

    public void setRasterImage(JimiRasterImage raster) {
        this.raster = raster;
        this.primary.setRasterImage(raster);
        this.secondary.setRasterImage(raster);
    }

    public void setImageProducer(ImageProducer producer) {
        this.producer = producer;
        this.primary.setRasterImage(this.raster);
        this.secondary.setRasterImage(this.raster);
    }

    public void setPrimaryRenderer(JimiImageRenderer primary) {
        this.primary = primary;
    }

    public void setSecondaryRenderer(JimiImageRenderer secondary) {
        this.secondary = secondary;
    }

    public Component getContentPane() {
        this.add(this.primary.getContentPane(), "North");
        this.add(this.secondary.getContentPane(), "Center");
        return this;
    }

    public void render() {
        this.primary.render();
        this.secondary.render();
    }
}

