/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.component;

import com.sun.jimi.core.component.AbstractRenderer;
import com.sun.jimi.core.component.JimiCanvas;
import com.sun.jimi.core.raster.JimiRasterImage;
import com.sun.jimi.core.util.GraphicsUtils;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.ImageProducer;

public class CropRenderer
extends AbstractRenderer {
    protected Rectangle cachedArea = new Rectangle();
    protected Image cacheImage;

    public CropRenderer(JimiCanvas canvas) {
        this.canvas = canvas;
    }

    public void render() {
        this.repaint();
    }

    public void paint(Graphics g) {
        this.blankBackground(g);
        JimiRasterImage raster = this.getRasterImage();
        if (raster == null) {
            return;
        }
        raster.waitInfoAvailable();
        int imageWidth = raster.getWidth();
        int imageHeight = raster.getHeight();
        int width = this.canvas.size().width;
        int height = this.canvas.size().height;
        int xStart = 0;
        int yStart = 0;
        int xDiff = imageWidth - width;
        int yDiff = imageHeight - height;
        int cropWidth = Math.min(imageWidth, width);
        int cropHeight = Math.min(imageHeight, height);
        if (xDiff < 0) {
            xDiff = 0;
        }
        if (yDiff < 0) {
            yDiff = 0;
        }
        int xHalf = xDiff / 2;
        int yHalf = yDiff / 2;
        switch (this.canvas.getJustificationPolicy()) {
            case 0: {
                xStart = xHalf;
                yStart = yHalf;
                break;
            }
            case 18: {
                xStart = 0;
                yStart = 0;
                break;
            }
            case 16: {
                xStart = 0;
                yStart = yHalf;
                break;
            }
            case 20: {
                xStart = 0;
                yStart = yDiff;
                break;
            }
            case 4: {
                xStart = xHalf;
                yStart = yDiff;
                break;
            }
            case 12: {
                xStart = xDiff;
                yStart = yDiff;
                break;
            }
            case 8: {
                xStart = xDiff;
                yStart = yHalf;
                break;
            }
            case 10: {
                xStart = xDiff;
                yStart = 0;
                break;
            }
            case 2: {
                xStart = xHalf;
                yStart = 0;
            }
        }
        if (this.cacheImage == null || this.cachedArea.x != xStart || this.cachedArea.y != yStart || this.cachedArea.width != cropWidth || this.cachedArea.height != cropHeight) {
            ImageProducer prod = raster.getCroppedImageProducer(xStart, yStart, cropWidth, cropHeight);
            this.cacheImage = Toolkit.getDefaultToolkit().createImage(prod);
            GraphicsUtils.waitForImage(this.cacheImage);
            this.cachedArea.x = xStart;
            this.cachedArea.y = yStart;
            this.cachedArea.width = cropWidth;
            this.cachedArea.height = cropHeight;
        }
        this.image = this.cacheImage;
        super.paint(g);
    }
}

