/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.component;

import com.sun.jimi.core.raster.JimiRasterImage;
import com.sun.jimi.core.util.GraphicsUtils;
import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.ScrollPane;
import java.awt.image.ImageProducer;

public class CroppedPreviewCanvas
extends Canvas {
    protected int cropWidth;
    protected int cropHeight;
    protected JimiRasterImage rasterImage;
    protected Image previewImage;
    protected Image completeImage;

    public CroppedPreviewCanvas() {
    }

    public CroppedPreviewCanvas(int cropWidth, int cropHeight) {
        this.setCropDimensions(cropWidth, cropHeight);
    }

    public CroppedPreviewCanvas(int cropWidth, int cropHeight, JimiRasterImage image) {
        this(cropWidth, cropHeight);
        this.setImage(image);
    }

    public Dimension getPreferredSize() {
        if (this.rasterImage != null) {
            return new Dimension(this.rasterImage.getWidth(), this.rasterImage.getHeight());
        }
        return new Dimension(610, 410);
    }

    public synchronized void setImage(JimiRasterImage image) {
        image.waitInfoAvailable();
        this.rasterImage = image;
        if (this.previewImage != null) {
            this.previewImage.flush();
        }
        if (this.completeImage != null) {
            this.completeImage.flush();
        }
        this.previewImage = null;
        this.completeImage = null;
        this.update(this.getGraphics());
        this.getParent().invalidate();
    }

    public void setCropDimensions(int cropWidth, int cropHeight) {
        this.cropWidth = cropWidth;
        this.cropHeight = cropHeight;
        this.repaint();
    }

    public synchronized void paint(Graphics g) {
        if (this.rasterImage == null) {
            return;
        }
        int xoff = 0;
        int yoff = 0;
        if (this.rasterImage.getWidth() < this.cropWidth) {
            xoff = (this.cropWidth - this.rasterImage.getWidth()) / 2;
        }
        if (this.rasterImage.getHeight() < this.cropHeight) {
            yoff = (this.cropHeight - this.rasterImage.getHeight()) / 2;
        }
        if (this.rasterImage == null || this.rasterImage.isError()) {
            return;
        }
        Dimension size = this.getSize();
        if (this.completeImage != null) {
            if (this.getParent() instanceof ScrollPane) {
                this.getParent().enable();
            }
            g.drawImage(this.completeImage, xoff, yoff, null);
        } else if (this.previewImage != null) {
            if (this.getParent() instanceof ScrollPane) {
                this.getParent().disable();
            }
            g.drawImage(this.previewImage, xoff, yoff, null);
            this.getToolkit().sync();
            if (this.completeImage == null) {
                this.createCompleteImage();
            }
            this.paint(g);
        } else {
            this.createPreviewImage();
            this.paint(g);
        }
    }

    protected void createPreviewImage() {
        int width = Math.min(this.cropWidth, this.rasterImage.getWidth());
        int height = Math.min(this.cropHeight, this.rasterImage.getHeight());
        if (width != this.rasterImage.getWidth() || height != this.rasterImage.getHeight()) {
            ImageProducer prod = this.rasterImage.getCroppedImageProducer(0, 0, width, height);
            this.previewImage = this.createImage(prod);
            GraphicsUtils.waitForImage(this, this.previewImage);
        }
        if (width == this.rasterImage.getWidth() && height == this.rasterImage.getHeight()) {
            this.previewImage = this.createImage(this.rasterImage.getImageProducer());
            GraphicsUtils.waitForImage(this, this.previewImage);
            this.completeImage = this.previewImage;
        }
    }

    protected void createCompleteImage() {
        this.completeImage = this.createImage(this.rasterImage.getImageProducer());
        GraphicsUtils.waitForImage(this, this.completeImage);
    }
}

