/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.component;

import com.sun.jimi.core.component.AspectScaler;
import com.sun.jimi.core.component.JimiCanvas;
import com.sun.jimi.core.util.GraphicsUtils;
import java.awt.Canvas;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageProducer;

public class FitToWidthPanel
extends Canvas {
    protected ImageProducer producer;
    protected Image cache;
    protected int position;
    protected boolean needsRedraw;
    protected JimiCanvas canvas;

    public FitToWidthPanel(JimiCanvas canvas) {
        this.canvas = canvas;
    }

    public void setImageProducer(ImageProducer producer) {
        this.producer = producer;
        this.cache = null;
        this.position = 0;
        this.redraw();
    }

    public void setPosition(int pos) {
        this.position = pos;
        this.repaint();
    }

    public synchronized void redraw() {
        this.needsRedraw = true;
        this.repaint();
    }

    public synchronized void paint(Graphics g) {
        int ystart;
        int leftover;
        if (this.cache == null || this.needsRedraw) {
            g.fillRect(0, 0, this.getSize().width, this.getSize().height);
            this.needsRedraw = false;
        }
        if (this.producer == null) {
            return;
        }
        if (this.cache == null || this.getSize().width != this.cache.getWidth(null)) {
            this.updateCache();
        }
        if ((leftover = Math.max(0, this.getSize().height - this.cache.getHeight(null))) > 0) {
            this.position = 0;
        }
        if (leftover <= 0) {
            ystart = -this.position;
        } else {
            int anchor = this.canvas.getJustificationPolicy();
            if ((anchor & 2) != 0) {
                ystart = 0;
                g.fillRect(0, this.getSize().height - leftover, this.getSize().width, leftover);
            } else if ((anchor & 4) != 0) {
                ystart = leftover;
                g.fillRect(0, 0, this.getSize().width, ystart);
            } else {
                ystart = leftover / 2;
                g.fillRect(0, 0, this.getSize().width, ystart);
                g.fillRect(0, this.getSize().height - ystart, this.getSize().width, ystart);
            }
        }
        g.drawImage(this.cache, 0, ystart, this);
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    protected void updateCache() {
        AspectScaler filter = new AspectScaler(this.getSize().width, Integer.MAX_VALUE);
        FilteredImageSource prod = new FilteredImageSource(this.producer, filter);
        this.cache = this.createImage(prod);
        GraphicsUtils.waitForImage(this.cache);
        this.position = 0;
    }
}

