/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.component;

import com.sun.jimi.core.component.AbstractRenderer;
import com.sun.jimi.core.component.JimiCanvas;
import com.sun.jimi.core.filters.ReplicatingScaleFilter;
import com.sun.jimi.core.raster.JimiRasterImage;
import com.sun.jimi.core.util.GraphicsUtils;
import java.awt.Component;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.ScrollPane;
import java.awt.image.AreaAveragingScaleFilter;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;

public class FitToWidthRenderer
extends AbstractRenderer {
    private ScrollPane jsp;
    private Rectangle cachedArea;
    private Image cachedImage;
    private int cachedWidth;

    public FitToWidthRenderer(JimiCanvas canvas) {
        this.canvas = canvas;
        this.jsp = new ScrollPane(0);
        this.jsp.setBackground(this.getBackground());
        this.jsp.setForeground(this.getForeground());
        this.jsp.add(this);
    }

    public Component getContentPane() {
        return this;
    }

    public synchronized void render() {
        JimiRasterImage image = this.getRasterImage();
        if (image == null) {
            return;
        }
        int fitWidth = this.canvas.getFitWidth();
        int imageWidth = image.getWidth();
        int imageHeight = image.getHeight();
        int width = this.jsp.getSize().width - this.jsp.getVScrollbarWidth() * 2;
        int w = fitWidth == -1 ? width : fitWidth;
        float ratio = (float)w / (float)imageWidth;
        int ySize = (int)((float)imageHeight * ratio);
        if (this.cachedImage != null && this.cachedWidth == w) {
            this.repaint();
            return;
        }
        if (this.cachedImage != null) {
            this.cachedImage.flush();
        }
        ImageFilter filter = this.canvas.getScalingPolicy() == 0 ? new AreaAveragingScaleFilter(w, ySize) : new ReplicatingScaleFilter(w, ySize);
        FilteredImageSource prod = new FilteredImageSource(image.getImageProducer(), filter);
        this.cachedImage = this.image = this.createImage(prod);
        this.cachedWidth = w;
        GraphicsUtils.waitForImage(this, this.image);
        this.invalidate();
        this.jsp.validate();
    }
}

