/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.component;

import com.sun.jimi.core.Jimi;
import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.component.FitToWidthPanel;
import com.sun.jimi.core.component.JimiCanvas;
import com.sun.jimi.core.component.JimiImageRenderer;
import com.sun.jimi.core.raster.JimiRasterImage;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.ImageProducer;

public class FitWidthRenderer
extends Panel
implements JimiImageRenderer,
AdjustmentListener {
    protected JimiRasterImage rasterImage;
    protected Scrollbar scroller;
    protected FitToWidthPanel panel;
    protected JimiCanvas canvas;

    public FitWidthRenderer(JimiCanvas canvas) {
        this.canvas = canvas;
        this.panel = new FitToWidthPanel(canvas);
        this.scroller = new Scrollbar(1, 0, 10, 0, 100);
        this.scroller.setUnitIncrement(10);
        this.scroller.addAdjustmentListener(this);
        this.scroller.setVisible(false);
        this.scroller.addAdjustmentListener(this);
        this.addComponentListener(new ResizeListener());
        this.setLayout(new BorderLayout());
        this.add((Component)this.panel, "Center");
        this.add((Component)this.scroller, "East");
        this.setBackground(canvas.getBackground());
        this.panel.setBackground(canvas.getBackground());
    }

    public void calibrateScrolling() {
        if (this.rasterImage == null || this.rasterImage.getWidth() == 0 || this.rasterImage.getHeight() == 0) {
            return;
        }
        int width = this.panel.getSize().width;
        int height = this.panel.getSize().height;
        if (width == 0 || height == 0) {
            return;
        }
        int imageWidth = this.rasterImage.getWidth();
        int imageHeight = this.rasterImage.getHeight();
        int adjustedHeight = imageHeight * width / imageWidth;
        if (adjustedHeight > height) {
            this.scroller.setValues(0, height, 0, adjustedHeight);
            this.scroller.setBlockIncrement(height);
            this.scroller.setPageIncrement(height);
            this.scroller.setVisible(true);
        } else {
            this.scroller.setVisible(false);
        }
        this.validate();
    }

    public void setImage(Image image) {
        if (image == null) {
            return;
        }
        try {
            this.setRasterImage(Jimi.createRasterImage(image.getSource()));
        }
        catch (JimiException jimiException) {
            // empty catch block
        }
    }

    public void setImageProducer(ImageProducer producer) {
        if (producer == null) {
            return;
        }
        try {
            this.setRasterImage(Jimi.createRasterImage(producer));
        }
        catch (JimiException jimiException) {
            // empty catch block
        }
    }

    public void setRasterImage(JimiRasterImage raster) {
        if (raster == null) {
            return;
        }
        raster.waitFinished();
        this.rasterImage = raster;
        this.panel.setImageProducer(raster.getImageProducer());
        this.calibrateScrolling();
    }

    public Component getContentPane() {
        return this;
    }

    public void render() {
        this.panel.redraw();
    }

    public void adjustmentValueChanged(AdjustmentEvent e) {
        this.panel.setPosition(this.scroller.getValue());
    }

    class ResizeWatcher
    extends ComponentAdapter {
        ResizeWatcher() {
        }

        public void componentResized(ComponentEvent event) {
            FitWidthRenderer.this.calibrateScrolling();
            FitWidthRenderer.this.panel.redraw();
        }
    }

    class ResizeListener
    extends ComponentAdapter {
        ResizeListener() {
        }

        public void componentResized(ComponentEvent e) {
            FitWidthRenderer.this.calibrateScrolling();
        }
    }
}

