/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.component;

import com.sun.jimi.core.JimiReader;
import com.sun.jimi.core.raster.JimiRasterImage;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;

public class ImageCache {
    public Enumeration rasterImages;
    public Vector cachedImages = new Vector();
    public int cacheSize;
    public boolean wrap;
    public boolean seriesFinished = false;
    public int currentIndex = -1;

    public ImageCache(JimiReader reader, boolean wrap) {
        this.rasterImages = reader.getRasterImageEnumeration();
        this.wrap = wrap;
    }

    public JimiRasterImage getImage(int index) throws NoSuchElementException {
        if (this.cacheSize <= index) {
            int imagesToRead = index - (this.cacheSize - 1);
            JimiRasterImage image = null;
            if (this.seriesFinished) {
                return this.getCachedImage(index);
            }
            while (imagesToRead-- > 0 && this.rasterImages.hasMoreElements()) {
                image = (JimiRasterImage)this.rasterImages.nextElement();
                if (image == null) {
                    this.seriesFinished = true;
                    return this.getCachedImage(index);
                }
                image.waitInfoAvailable();
                if (image.isError()) {
                    this.seriesFinished = true;
                    return this.getCachedImage(index);
                }
                ++this.cacheSize;
                this.cachedImages.addElement(image);
            }
            return image;
        }
        return this.getCachedImage(index);
    }

    public boolean allImagesCached() {
        return this.seriesFinished;
    }

    public JimiRasterImage getCachedImage(int index) throws NoSuchElementException {
        if (this.cacheSize == 0) {
            throw new NoSuchElementException();
        }
        if (!this.wrap) {
            if (this.cachedImages.size() < index) {
                throw new NoSuchElementException();
            }
            JimiRasterImage raster = (JimiRasterImage)this.cachedImages.elementAt(index);
            raster.waitFinished();
            return raster;
        }
        JimiRasterImage raster = (JimiRasterImage)this.cachedImages.elementAt(index % this.cacheSize);
        raster.waitFinished();
        return raster;
    }

    public JimiRasterImage getNextImage() {
        return this.getImage(++this.currentIndex);
    }

    public JimiRasterImage getPreviousImage() {
        return this.getImage(--this.currentIndex);
    }

    public boolean hasNextImage() {
        try {
            return this.getImage(this.currentIndex + 1) != null;
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    public boolean hasPreviousImage() {
        return this.currentIndex > 0;
    }
}

