/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.component;

import com.sun.jimi.core.Jimi;
import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.JimiReader;
import com.sun.jimi.core.JimiUtils;
import com.sun.jimi.core.component.AreaRenderer;
import com.sun.jimi.core.component.BestFitRenderer;
import com.sun.jimi.core.component.CropRenderer;
import com.sun.jimi.core.component.FitWidthRenderer;
import com.sun.jimi.core.component.ImageCache;
import com.sun.jimi.core.component.JimiImageRenderer;
import com.sun.jimi.core.component.ScaleRenderer;
import com.sun.jimi.core.component.ScrollRenderer;
import com.sun.jimi.core.component.SmartScrollingRenderer;
import com.sun.jimi.core.raster.JimiRasterImage;
import com.sun.jimi.core.util.GraphicsUtils;
import com.sun.jimi.core.util.ProgressListener;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.ImageProducer;
import java.net.URL;

public class JimiCanvas
extends Container {
    public static final int NORTH = 2;
    public static final int SOUTH = 4;
    public static final int EAST = 8;
    public static final int WEST = 16;
    public static final int NORTHEAST = 10;
    public static final int NORTHWEST = 18;
    public static final int SOUTHEAST = 12;
    public static final int SOUTHWEST = 20;
    public static final int CENTER = 0;
    public static final int BEST_FIT = 0;
    public static final int CROP = 1;
    public static final int SCALE = 2;
    public static final int SCROLL = 3;
    public static final int FIT_WIDTH = 4;
    public static final int AREA = 5;
    public static final int MULTIPAGE = 6;
    public static final int PAGED = 7;
    public static final int CROP_AS_NECESSARY = 1;
    public static final int FIT_TO_WIDTH = 4;
    public static final int AREA_AVERAGING = 0;
    public static final int REPLICATE = 1;
    protected transient Image myImage;
    protected transient ImageProducer myImageProducer;
    protected transient URL myImageLocation;
    protected boolean willSizeToFit = true;
    protected int fitWidth = -1;
    protected JimiImageRenderer renderer;
    protected int justificationPolicy = 0;
    protected int resizePolicy = 7;
    protected int scalingPolicy = 1;
    protected ProgressListener progressListener;
    protected int loadingFlags;
    protected boolean aspectAdjust = false;
    protected ImageCache imageCache;

    public JimiCanvas() {
        this.setLayout(new BorderLayout());
        this.setResizePolicy(7);
    }

    public JimiCanvas(Image myImage) {
        this();
        this.setImage(myImage);
    }

    public JimiCanvas(URL myImageLocation) {
        this();
        this.myImageLocation = myImageLocation;
        this.setImageLocation(myImageLocation);
    }

    public JimiCanvas(String path) {
        this();
        this.setImagePath(path);
    }

    public JimiCanvas(int resizePolicy) {
        this.setLayout(new BorderLayout());
        this.setResizePolicy(resizePolicy);
    }

    public void setRenderer(JimiImageRenderer renderer) {
        this.renderer = renderer;
        if (this.myImage != null) {
            renderer.setImage(this.myImage);
        } else if (this.myImageProducer != null) {
            renderer.setImageProducer(this.myImageProducer);
        }
        this.removeAll();
        this.add(renderer.getContentPane(), "Center");
        this.invalidate();
        this.validate();
    }

    public JimiImageRenderer getRenderer() {
        return this.renderer;
    }

    protected JimiImageRenderer getRenderer(int resizePolicy) {
        if (resizePolicy == 3) {
            this.renderer = new ScrollRenderer(this);
        } else if (resizePolicy == 1) {
            this.renderer = new CropRenderer(this);
        } else if (resizePolicy == 2) {
            this.renderer = new ScaleRenderer(this);
        } else if (resizePolicy == 0) {
            this.renderer = new BestFitRenderer(this);
        } else if (resizePolicy == 4) {
            this.renderer = new FitWidthRenderer(this);
        } else if (resizePolicy == 5) {
            this.renderer = new AreaRenderer(this);
        } else if (resizePolicy == 7) {
            this.renderer = new SmartScrollingRenderer(this);
        }
        return this.renderer;
    }

    public void setProgressListener(ProgressListener listener) {
        this.progressListener = listener;
    }

    public void setLoadingFlags(int flags) {
        this.loadingFlags = flags;
        this.loadingFlags &= 0xFFFFFFFD;
    }

    protected ImageProducer loadImageProducer(JimiReader reader) {
        if (this.progressListener != null) {
            reader.setProgressListener(this.progressListener);
        }
        this.imageCache = new ImageCache(reader, false);
        return this.imageCache.getNextImage().getImageProducer();
    }

    protected ImageProducer loadImageProducer(URL location) {
        try {
            return this.loadImageProducer(Jimi.createJimiReader(location, this.loadingFlags));
        }
        catch (Exception e) {
            this.showError(e.toString());
            return null;
        }
    }

    protected ImageProducer loadImageProducer(String filename) {
        try {
            return this.loadImageProducer(Jimi.createJimiReader(filename, this.loadingFlags));
        }
        catch (Exception e) {
            this.showError(e.toString());
            return null;
        }
    }

    protected void showError(String message) {
        if (this.progressListener != null) {
            this.progressListener.setAbort(message);
        }
    }

    private synchronized void doResize() {
        if (this.myImage == null) {
            return;
        }
        this.resize(new Dimension(this.myImage.getWidth(this), this.myImage.getHeight(this)));
        Container p = this.getParent();
        if (p != null) {
            p.invalidate();
            p.layout();
        }
    }

    public void setFitWidth(int width) {
        this.fitWidth = width;
    }

    public int getFitWidth() {
        return this.fitWidth;
    }

    public synchronized void setJustificationPolicy(int newPolicy) {
        this.justificationPolicy = newPolicy;
        if (this.renderer != null) {
            this.renderer.render();
        }
    }

    public int getJustificationPolicy() {
        return this.justificationPolicy;
    }

    public synchronized void setResizePolicy(int newPolicy) {
        this.resizePolicy = newPolicy;
        this.renderer = this.getRenderer(this.resizePolicy);
        this.renderer.getContentPane().setBackground(this.getBackground());
        this.renderer.getContentPane().setForeground(this.getForeground());
        this.setRenderer(this.renderer);
        if (this.myImage != null) {
            this.renderer.setImage(this.myImage);
        } else if (this.myImageProducer != null) {
            this.renderer.setImageProducer(this.myImageProducer);
        }
    }

    public int getResizePolicy() {
        return this.resizePolicy;
    }

    public synchronized void setScalingPolicy(int newPolicy) {
        this.scalingPolicy = newPolicy;
    }

    public int getScalingPolicy() {
        return this.scalingPolicy;
    }

    public synchronized void setWillSizeToFit(boolean newPolicy) {
        this.willSizeToFit = newPolicy;
    }

    public boolean getWillSizeToFit() {
        return this.willSizeToFit;
    }

    public synchronized void setImageLocation(URL newLocation) {
        this.setImageProducer(this.loadImageProducer(newLocation));
    }

    public URL getImageLocation() {
        return this.myImageLocation;
    }

    public synchronized void setImage(Image myImage) {
        this.myImage = myImage;
        if (this.renderer != null) {
            this.renderer.setImage(myImage);
        }
        this.validate();
    }

    public synchronized void setImagePath(String path) {
        this.setImageProducer(this.loadImageProducer(path));
    }

    public Image getImage() {
        if (this.myImage != null) {
            return this.myImage;
        }
        if (this.myImageProducer != null) {
            this.myImage = this.createImage(this.myImageProducer);
            GraphicsUtils.waitForImage(this.myImage);
            return this.myImage;
        }
        return null;
    }

    public void setImageProducer(ImageProducer producer) {
        this.myImage = null;
        if (this.renderer != null) {
            if (producer != null && this.aspectAdjust) {
                try {
                    producer = JimiUtils.aspectAdjust(Jimi.createRasterImage(producer));
                }
                catch (JimiException e) {
                    producer = null;
                }
            }
            this.myImageProducer = producer;
            this.renderer.setImageProducer(producer);
            this.invalidate();
            this.validate();
        }
    }

    public void setRasterImage(JimiRasterImage raster) {
        this.setImageProducer(raster == null ? null : raster.getImageProducer());
    }

    public void nextImage() {
        try {
            this.setRasterImage(this.imageCache.getNextImage());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void previousImage() {
        try {
            this.setRasterImage(this.imageCache.getPreviousImage());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void firstImage() {
        if (this.imageCache == null) {
            return;
        }
        JimiRasterImage image = null;
        while (this.imageCache.hasPreviousImage()) {
            image = this.imageCache.getPreviousImage();
        }
        if (image != null) {
            this.setRasterImage(image);
        }
    }

    public void lastImage() {
        if (this.imageCache == null) {
            return;
        }
        JimiRasterImage image = null;
        while (this.imageCache.hasNextImage()) {
            image = this.imageCache.getNextImage();
        }
        if (image != null) {
            this.setRasterImage(image);
        }
    }

    public boolean hasNextImage() {
        return this.imageCache == null ? false : this.imageCache.hasNextImage();
    }

    public boolean hasPreviousImage() {
        return this.imageCache == null ? false : this.imageCache.hasPreviousImage();
    }

    public void setAspectAdjust(boolean flag) {
        this.aspectAdjust = flag;
    }
}

