/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.component;

import com.sun.jimi.core.Jimi;
import com.sun.jimi.core.filters.ReplicatingScaleFilter;
import com.sun.jimi.core.util.GraphicsUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.AreaAveragingScaleFilter;
import java.awt.image.CropImageFilter;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.net.URL;

public class JimiCanvasLW
extends Component {
    public static final int EAST = 0;
    public static final int NORTH = 1;
    public static final int NORTHEAST = 2;
    public static final int NORTHWEST = 3;
    public static final int SOUTH = 4;
    public static final int SOUTHEAST = 5;
    public static final int SOUTHWEST = 6;
    public static final int WEST = 7;
    public static final int CENTER = 8;
    public static final int BEST_FIT = 0;
    public static final int CROP_AS_NECESSARY = 1;
    public static final int SCALE = 2;
    public static final int SCROLL = 3;
    public static final int FIT_TO_WIDTH = 4;
    public static final int AREA_AVERAGING = 0;
    public static final int REPLICATE = 1;
    protected transient Image myImage;
    protected URL myImageLocation;
    protected boolean willSizeToFit = false;
    protected int justificationPolicy = 8;
    protected int resizePolicy = 3;
    protected int scalingPolicy = 1;
    private transient Image cacheImage;
    private int lastWidth;
    private int lastHeight;
    private int lastResizePolicy;
    private int lastScalingPolicy;
    private int lastJustificationPolicy;
    private int fitWidth = -1;

    public JimiCanvasLW() {
    }

    public JimiCanvasLW(Image anImage) {
        this();
        this.myImage = anImage;
        this.myImageLocation = null;
    }

    public JimiCanvasLW(URL aLocation) {
        this();
        this.myImage = null;
        this.myImageLocation = aLocation;
    }

    protected void LoadImage() {
        if (this.myImageLocation == null) {
            return;
        }
        Image tempImage = Jimi.getImage(this.myImageLocation);
        MediaTracker mt = new MediaTracker(this);
        mt.addImage(tempImage, 0);
        try {
            mt.waitForAll();
            if (!mt.isErrorAny()) {
                this.setImage(tempImage);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private synchronized void doResize() {
        if (this.myImage == null) {
            return;
        }
        this.setSize(new Dimension(this.myImage.getWidth(this), this.myImage.getHeight(this)));
        Container p = this.getParent();
        if (p != null) {
            p.invalidate();
            p.layout();
        }
    }

    public void setFitWidth(int width) {
        this.fitWidth = width;
    }

    Image getResizedImage(Image which, int width, int height, int resizePolicy, int justificationPolicy) {
        int imageWidth = which.getWidth(this);
        int imageHeight = which.getHeight(this);
        if (resizePolicy == 3) {
            return which;
        }
        if (resizePolicy == 1) {
            int xStart = 0;
            int yStart = 0;
            int xDiff = imageWidth - width;
            int yDiff = imageHeight - height;
            if (xDiff < 0) {
                xDiff = 0;
            }
            if (yDiff < 0) {
                yDiff = 0;
            }
            if (xDiff == 0 && yDiff == 0) {
                return which;
            }
            int xHalf = xDiff / 2;
            int yHalf = yDiff / 2;
            int doneWidth = width < imageWidth ? width : imageWidth;
            int doneHeight = height < imageHeight ? height : imageHeight;
            switch (justificationPolicy) {
                case 8: {
                    xStart = xHalf;
                    yStart = yHalf;
                    break;
                }
                case 3: {
                    xStart = 0;
                    yStart = 0;
                    break;
                }
                case 7: {
                    xStart = 0;
                    yStart = yHalf;
                    break;
                }
                case 6: {
                    xStart = 0;
                    yStart = yDiff;
                    break;
                }
                case 4: {
                    xStart = xHalf;
                    yStart = yDiff;
                    break;
                }
                case 5: {
                    xStart = xDiff;
                    yStart = yDiff;
                    break;
                }
                case 0: {
                    xStart = xDiff;
                    yStart = yHalf;
                    break;
                }
                case 2: {
                    xStart = xDiff;
                    yStart = 0;
                    break;
                }
                case 1: {
                    xStart = xHalf;
                    yStart = 0;
                }
            }
            CropImageFilter filter = new CropImageFilter(xStart, yStart, imageWidth, imageHeight);
            FilteredImageSource prod = new FilteredImageSource(which.getSource(), filter);
            Image result = Toolkit.getDefaultToolkit().createImage(prod);
            which.flush();
            GraphicsUtils.waitForImage(this, result);
            return result;
        }
        if (resizePolicy == 2) {
            ImageFilter filter = this.getScalingPolicy() == 0 ? new AreaAveragingScaleFilter(width, height) : new ReplicatingScaleFilter(width, height);
            FilteredImageSource prod = new FilteredImageSource(which.getSource(), filter);
            return Toolkit.getDefaultToolkit().createImage(prod);
        }
        if (resizePolicy == 0) {
            int yDistance;
            int xDistance;
            float xRatio = (float)width / (float)imageWidth;
            float yRatio = (float)height / (float)imageHeight;
            if (xRatio < yRatio) {
                xDistance = (int)((float)imageWidth * xRatio);
                yDistance = (int)((float)imageHeight * xRatio);
            } else {
                xDistance = (int)((float)imageWidth * yRatio);
                yDistance = (int)((float)imageHeight * yRatio);
            }
            ImageFilter filter = this.getScalingPolicy() == 0 ? new AreaAveragingScaleFilter(xDistance, yDistance) : new ReplicatingScaleFilter(xDistance, yDistance);
            FilteredImageSource prod = new FilteredImageSource(which.getSource(), filter);
            return Toolkit.getDefaultToolkit().createImage(prod);
        }
        if (imageWidth < this.fitWidth) {
            return which;
        }
        int w = this.fitWidth == -1 ? width : this.fitWidth;
        float ratio = (float)w / (float)imageWidth;
        int ySize = (int)((float)imageHeight * ratio);
        if (this.cacheImage != null && this.cacheImage.getWidth(null) == w && this.cacheImage.getHeight(null) == ySize) {
            return this.cacheImage;
        }
        ImageFilter filter = this.getScalingPolicy() == 0 ? new AreaAveragingScaleFilter(w, ySize) : new ReplicatingScaleFilter(w, ySize);
        FilteredImageSource prod = new FilteredImageSource(which.getSource(), filter);
        return Toolkit.getDefaultToolkit().createImage(prod);
    }

    public synchronized void setJustificationPolicy(int newPolicy) {
        this.justificationPolicy = newPolicy;
    }

    public int getJustificationPolicy() {
        return this.justificationPolicy;
    }

    public synchronized void setResizePolicy(int newPolicy) {
        this.resizePolicy = newPolicy;
    }

    public int getResizePolicy() {
        return this.resizePolicy;
    }

    public synchronized void setScalingPolicy(int newPolicy) {
        this.scalingPolicy = newPolicy;
    }

    public int getScalingPolicy() {
        return this.scalingPolicy;
    }

    public synchronized void setWillSizeToFit(boolean newPolicy) {
        this.willSizeToFit = newPolicy;
    }

    public boolean getWillSizeToFit() {
        return this.willSizeToFit;
    }

    public synchronized void setImageLocation(URL newLocation) {
        this.myImageLocation = newLocation;
        this.LoadImage();
    }

    public URL getImageLocation() {
        return this.myImageLocation;
    }

    public synchronized void setImage(Image anImage) {
        if (this.cacheImage != null) {
            this.cacheImage.flush();
            this.cacheImage = null;
        }
        if (this.myImage != null) {
            this.myImage.flush();
        }
        this.myImage = anImage;
        if (this.willSizeToFit || this.getResizePolicy() == 4) {
            this.doResize();
        }
        this.repaint();
    }

    public Image getImage() {
        return this.myImage;
    }

    public Dimension getPreferredSize() {
        if (this.myImage != null && this.getWillSizeToFit()) {
            if (this.getResizePolicy() == 4) {
                Image cache = this.getCacheImage();
                if (cache != null) {
                    return new Dimension(cache.getWidth(null), cache.getHeight(null));
                }
            } else {
                return new Dimension(this.myImage.getWidth(null), this.myImage.getHeight(null));
            }
        }
        return super.getPreferredSize();
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    protected Image getCacheImage() {
        if (this.cacheImage == null) {
            this.cacheImage = this.getResizedImage(this.myImage, this.size().width, this.size().height, this.resizePolicy, this.justificationPolicy);
        }
        return this.cacheImage;
    }

    public synchronized void paint(Graphics g) {
        if (this.myImage == null) {
            g.setColor(this.getForeground());
            g.fillRect(0, 0, this.size().width, this.size().height);
            return;
        }
        int xStart = 0;
        int yStart = 0;
        int xWidth = this.size().width;
        int yHeight = this.size().height;
        if (this.cacheImage == null || xWidth != this.lastWidth || yHeight != this.lastHeight || this.resizePolicy != this.lastResizePolicy || this.justificationPolicy != this.lastJustificationPolicy) {
            this.cacheImage = this.getResizedImage(this.myImage, xWidth, yHeight, this.resizePolicy, this.justificationPolicy);
            this.lastWidth = xWidth;
            this.lastHeight = yHeight;
            this.lastResizePolicy = this.resizePolicy;
            this.lastJustificationPolicy = this.justificationPolicy;
        }
        int imageWidth = this.cacheImage.getWidth(this);
        int imageHeight = this.cacheImage.getHeight(this);
        switch (this.justificationPolicy) {
            case 8: {
                xStart = (xWidth - imageWidth) / 2;
                yStart = (yHeight - imageHeight) / 2;
                break;
            }
            case 3: {
                xStart = 0;
                yStart = 0;
                break;
            }
            case 2: {
                xStart = xWidth - imageWidth;
                yStart = 0;
                break;
            }
            case 1: {
                xStart = (xWidth - imageWidth) / 2;
                yStart = 0;
                break;
            }
            case 4: {
                xStart = (xWidth - imageWidth) / 2;
                yStart = yHeight - imageHeight;
                break;
            }
            case 6: {
                xStart = 0;
                yStart = yHeight - imageHeight;
                break;
            }
            case 5: {
                xStart = xWidth - imageWidth;
                yStart = yHeight - imageHeight;
                break;
            }
            case 0: {
                xStart = xWidth - imageWidth;
                yStart = (yHeight - imageHeight) / 2;
                break;
            }
            case 7: {
                xStart = 0;
                yStart = (yHeight - imageHeight) / 2;
            }
        }
        g.setColor(this.getForeground());
        g.fillRect(0, 0, xWidth, yHeight);
        g.drawImage(this.cacheImage, xStart, yStart, imageWidth, imageHeight, this);
    }
}

