/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.component;

import com.sun.jimi.core.component.ScrollPaneLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Scrollbar;

public class JimiScrollPane
extends Container {
    public static final int SCROLL_HORIZONTAL = 0;
    public static final int SCROLL_VERTICAL = 1;
    public static final int SCROLL_AS_NEEDED = 2;
    public static final int SCROLL_ALWAYS = 3;
    private static final int DEFAULT_POLICY = 2;
    private int policy = 2;
    private Scrollbar horizontal;
    private Scrollbar vertical;
    private Component comp;
    private Button box;
    private int compHeight;
    private int compWidth;
    private int paintX;
    private int paintY;

    public JimiScrollPane() {
        this.setLayout(new ScrollPaneLayout());
        this.horizontal = new Scrollbar(0);
        this.horizontal.setLineIncrement(10);
        this.vertical = new Scrollbar(1);
        this.vertical.setLineIncrement(10);
        this.box = new Button();
    }

    public JimiScrollPane(int policy) {
        this();
        this.policy = policy;
    }

    public JimiScrollPane(Component comp, int policy) {
        this(policy);
        this.comp = comp;
        super.add(comp, 0);
    }

    public JimiScrollPane(Component comp) {
        this(comp, 2);
    }

    public Component add(Component comp) {
        this.comp = comp;
        return super.add(comp, 0);
    }

    public Dimension preferredSize() {
        return super.preferredSize();
    }

    public int getVerticalPosition() {
        return this.paintY;
    }

    public int getHorizontalPosition() {
        return this.paintX;
    }

    public int getVBarOffset() {
        int max = Math.max(this.vertical.size().width, this.vertical.preferredSize().width);
        return max;
    }

    public int getHBarOffset() {
        int max = Math.max(this.horizontal.size().height, this.horizontal.preferredSize().height);
        return max;
    }

    public Scrollbar getVerticalBar() {
        return this.vertical;
    }

    public Scrollbar getHorizontalBar() {
        return this.horizontal;
    }

    public void setScrollPolicy(int policy) {
        this.policy = policy;
    }

    public int getScrollPolicy() {
        return this.policy;
    }

    public void layout() {
        switch (this.policy) {
            case 0: {
                this.add("south", this.horizontal);
                this.add("center", this.comp);
                break;
            }
            case 1: {
                this.add("east", this.vertical);
                this.add("center", this.comp);
                break;
            }
            case 2: {
                boolean horizontalNeeded = false;
                boolean verticalNeeded = false;
                int compWidth = this.comp.preferredSize().width;
                int compHeight = this.comp.preferredSize().height;
                if (compHeight > this.size().height - this.vertical.preferredSize().height) {
                    this.add("east", this.vertical);
                    verticalNeeded = true;
                }
                if (compWidth > this.size().width - this.horizontal.preferredSize().width) {
                    this.add("south", this.horizontal);
                    horizontalNeeded = true;
                }
                if (horizontalNeeded && verticalNeeded) {
                    this.add("corner", this.box);
                }
                this.add("center", this.comp);
                break;
            }
            case 3: {
                this.add("east", this.vertical);
                this.add("south", this.horizontal);
                this.add("corner", this.box);
                this.add("center", this.comp);
                break;
            }
        }
        if (this.vertical != null) {
            this.compHeight = this.comp.preferredSize().height - this.getViewPort().height;
            this.vertical.setValues(0, 20, 0, this.compHeight + 20);
        }
        if (this.horizontal != null) {
            this.compWidth = this.comp.preferredSize().width - this.getViewPort().width;
            this.horizontal.setValues(0, 20, 0, this.compWidth + 20);
        }
        super.layout();
    }

    protected Dimension getViewPort() {
        int width = 0;
        int height = 0;
        if (this.policy == 1) {
            if (this.vertical != null) {
                width = this.size().width;
                height = this.size().height;
            }
        } else if (this.policy == 0) {
            width = this.size().width;
            height = this.size().height;
        } else if (this.policy == 3) {
            width = this.size().width - this.vertical.preferredSize().width;
            height = this.size().height - this.horizontal.preferredSize().height;
        } else if (this.policy == 2) {
            if (this.vertical != null) {
                width = this.size().width - this.vertical.preferredSize().width;
                height = this.horizontal != null ? this.size().height - this.horizontal.preferredSize().height : this.size().height;
            }
            if (this.horizontal != null) {
                height = this.size().height - this.horizontal.preferredSize().height;
                width = this.vertical != null ? this.size().width - this.vertical.preferredSize().width : this.size().width;
            }
        }
        return new Dimension(width, height);
    }

    public boolean handleEvent(Event e) {
        Object source = e.target;
        if (source instanceof Button) {
            this.comp.move(-this.compWidth / 2, -this.compHeight / 2);
            this.vertical.setValue(this.compHeight / 2);
            this.horizontal.setValue(this.compWidth / 2);
        } else if (source instanceof Scrollbar) {
            int value = (Integer)e.arg;
            if (this.policy == 1) {
                this.paintY = -value;
                this.paintX = 0;
                this.comp.move(this.paintX, this.paintY);
            } else if (this.policy == 0) {
                this.paintY = 0;
                this.paintX = -value;
                this.comp.move(this.paintX, this.paintY);
            } else if (this.policy == 3 || this.policy == 2) {
                if (source == this.horizontal) {
                    this.paintX = -value;
                    this.paintY = -this.vertical.getValue();
                } else if (source == this.vertical) {
                    this.paintY = -value;
                    this.paintX = -this.horizontal.getValue();
                }
                this.comp.move(this.paintX, this.paintY);
            }
        } else {
            return false;
        }
        return super.handleEvent(e);
    }
}

