/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.component;

import com.sun.jimi.core.JimiReader;
import com.sun.jimi.core.component.AbstractRenderer;
import com.sun.jimi.core.component.ImageCache;
import com.sun.jimi.core.component.JimiCanvas;
import com.sun.jimi.core.component.JimiImageRenderer;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Label;
import java.awt.Panel;
import java.awt.image.ImageProducer;

public class MultipageRenderer
extends AbstractRenderer {
    public int index;
    public JimiImageRenderer target;
    public Button next;
    public Button previous;
    public Label info;
    public ImageCache cache;

    public MultipageRenderer(JimiCanvas canvas, JimiImageRenderer target) {
        this.canvas = canvas;
        this.target = target;
        this.setLayout(new BorderLayout(0, 0));
        this.setFont(new Font("Arial", 0, 10));
        this.next = new Button("Next");
        this.previous = new Button("Previous");
        this.info = new Label("Image Page", 1);
        Panel p = new Panel();
        p.add(this.previous);
        p.add(this.info);
        p.add(this.next);
        this.add((Component)p, "North");
    }

    public Component getContentPane() {
        return this;
    }

    public void render() {
    }

    public void paint(Graphics g) {
    }

    public Dimension preferredSize() {
        return super.minimumSize();
    }

    public boolean action(Event e, Object o) {
        if (e.target == this.next) {
            this.nextImage();
            return true;
        }
        if (e.target == this.previous) {
            this.previousImage();
            return true;
        }
        return false;
    }

    public void setReader(JimiReader reader) {
        this.index = 1;
        this.previous.setEnabled(false);
        this.next.setEnabled(true);
        this.cache = new ImageCache(reader, true);
        this.nextImage();
    }

    public void nextImage() {
        if (this.cache != null) {
            ImageProducer ip;
            this.producer = ip = this.cache.getImage(this.index++).getImageProducer();
            this.target.setImageProducer(ip);
        }
        this.previous.setEnabled(this.index > 1);
        this.next.setEnabled(true);
    }

    public void previousImage() {
        if (this.cache != null) {
            ImageProducer ip;
            this.producer = ip = this.cache.getImage(--this.index - 1).getImageProducer();
            this.target.setImageProducer(ip);
        }
        this.previous.setEnabled(this.index > 1);
    }

    public ImageProducer getImageProducer() {
        return this.producer;
    }
}

