/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.component;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

public class ScrollPaneLayout
implements LayoutManager {
    Component south;
    Component east;
    Component corner;
    Component center;

    public void removeLayoutComponent(Component comp) {
        if (comp == this.corner) {
            this.corner = null;
        } else if (comp == this.south) {
            this.south = null;
        } else if (comp == this.center) {
            this.center = null;
        } else if (comp == this.east) {
            this.east = null;
        } else {
            comp = null;
        }
    }

    public Dimension minimumLayoutSize(Container target) {
        return new Dimension(50, 50);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension preferredLayoutSize(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Dimension d;
            Dimension dim = new Dimension(0, 0);
            if (this.center != null && this.center.isVisible()) {
                d = this.center.preferredSize();
                dim.width += d.width;
                dim.height = Math.max(d.height, dim.height);
            } else if (this.east != null && this.east.isVisible()) {
                d = this.east.preferredSize();
                dim.width += d.width;
                dim.height = Math.max(d.height, dim.height);
            } else if (this.south != null && this.south.isVisible()) {
                d = this.south.preferredSize();
                dim.width = Math.max(d.width, dim.width);
                dim.height += d.height;
            } else if (this.corner != null && this.corner.isVisible()) {
                d = this.corner.preferredSize();
                dim.width = Math.max(d.width, dim.width);
                dim.height += d.height;
            } else {
                dim.width = 100;
                dim.height = 100;
            }
            Insets insets = target.insets();
            dim.width += insets.left + insets.right;
            dim.height += insets.top + insets.bottom;
            return dim;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Dimension d;
            Insets inset = target.insets();
            int top = 0 - inset.top;
            int bottom = target.size().height - inset.bottom;
            int left = 0 - inset.left;
            int right = target.size().width - inset.right;
            if (this.east != null && this.east.isVisible()) {
                d = this.east.preferredSize();
                if (this.south != null) {
                    this.east.reshape(right - d.width, top, d.width, bottom - this.south.preferredSize().height);
                } else if (this.south == null) {
                    this.east.reshape(right - d.width, top, d.width, bottom);
                }
            }
            if (this.south != null && this.south.isVisible()) {
                d = this.south.preferredSize();
                if (this.east != null) {
                    this.south.reshape(left, bottom - d.height, right - this.east.preferredSize().width, d.height);
                } else if (this.east == null) {
                    this.south.reshape(left, bottom - d.height, right, d.height);
                }
            }
            if (this.east != null && this.south != null && this.corner != null && this.corner.isVisible() && this.south.isVisible() && this.east.isVisible()) {
                d = this.corner.preferredSize();
                int startX = right - this.east.size().width;
                int startY = bottom - this.south.size().height;
                int width = right - this.south.size().width;
                int height = bottom - this.east.size().height;
                this.corner.reshape(startX, startY, width, height);
                this.corner.setBackground(Color.lightGray);
                this.corner.setForeground(Color.gray);
            }
            if (this.center != null && this.center.isVisible()) {
                d = this.center.preferredSize();
                if (this.east != null && this.east.isVisible() && this.south == null) {
                    this.center.reshape(left, top, right - this.east.size().width, d.height);
                } else if (this.south != null && this.south.isVisible() && this.east == null) {
                    this.center.reshape(left, top, d.width, bottom - this.south.size().height);
                } else {
                    this.center.reshape(left, top, d.width, d.height);
                }
            }
        }
    }

    public void addLayoutComponent(String string, Component comp) {
        if (string.equals("corner")) {
            this.corner = comp;
        }
        if (string.equals("south")) {
            this.south = comp;
        }
        if (string.equals("east")) {
            this.east = comp;
        }
        if (string.equals("center")) {
            this.center = comp;
        }
    }
}

