/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.component;

import com.sun.jimi.core.component.JimiCanvas;
import com.sun.jimi.core.raster.JimiRasterImage;
import com.sun.jimi.core.util.GraphicsUtils;
import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;

public class SmartCroppingPanel
extends Canvas {
    public static final int HORIZONTAL_PADDING = 150;
    public static final int VERTICAL_PADDING = 150;
    protected JimiRasterImage raster;
    protected Image cached;
    protected Rectangle cachedArea;
    protected Point position = new Point(0, 0);
    protected Rectangle viewingArea = new Rectangle();
    protected JimiCanvas canvas;
    protected boolean needsRedraw = true;
    private Point offset = new Point();

    public SmartCroppingPanel(JimiCanvas canvas) {
        this.canvas = canvas;
    }

    public void setPosition(int x, int y) {
        this.position.x = x;
        this.position.y = y;
        this.repaint();
    }

    public void setImage(JimiRasterImage raster) {
        this.raster = raster;
        this.updateCache();
        this.setPosition(0, 0);
        this.redraw();
    }

    protected void updateCache() {
        if (this.cached != null) {
            this.cached.flush();
        }
        Dimension size = this.getSize();
        int leftBoundry = Math.max(0, this.position.x - 150);
        int rightBoundry = Math.min(this.raster.getWidth(), this.position.x + size.width + 150);
        int topBoundry = Math.max(0, this.position.y - 150);
        int bottomBoundry = Math.min(this.raster.getHeight(), this.position.y + size.height + 150);
        this.cachedArea = new Rectangle(leftBoundry, topBoundry, rightBoundry - leftBoundry, bottomBoundry - topBoundry);
        this.cached = this.createImage(this.raster.getCroppedImageProducer(this.cachedArea.x, this.cachedArea.y, this.cachedArea.width, this.cachedArea.height));
        GraphicsUtils.waitForImage(this.cached);
    }

    protected boolean isCacheValid() {
        Dimension size = this.getSize();
        return this.position.x >= this.cachedArea.x && this.position.y >= this.cachedArea.y && this.position.x + size.width < this.cachedArea.x + this.cachedArea.width && this.position.y + size.height < this.cachedArea.y + this.cachedArea.height;
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void redraw() {
        this.needsRedraw = true;
        this.repaint();
    }

    public synchronized void paint(Graphics g) {
        if (this.raster == null || this.needsRedraw) {
            g.fillRect(0, 0, this.size().width, this.size().height);
            this.needsRedraw = false;
        }
        if (this.raster != null) {
            if (this.cached == null || !this.isCacheValid()) {
                this.updateCache();
            }
            int xWidth = this.size().width;
            int yHeight = this.size().height;
            int yStart = 0;
            int xStart = 0;
            int imageWidth = this.raster.getWidth();
            int imageHeight = this.raster.getHeight();
            switch (this.canvas.getJustificationPolicy()) {
                case 0: {
                    xStart = (xWidth - imageWidth) / 2;
                    yStart = (yHeight - imageHeight) / 2;
                    break;
                }
                case 18: {
                    xStart = 0;
                    yStart = 0;
                    break;
                }
                case 10: {
                    xStart = xWidth - imageWidth;
                    yStart = 0;
                    break;
                }
                case 2: {
                    xStart = (xWidth - imageWidth) / 2;
                    yStart = 0;
                    break;
                }
                case 4: {
                    xStart = (xWidth - imageWidth) / 2;
                    yStart = yHeight - imageHeight;
                    break;
                }
                case 20: {
                    xStart = 0;
                    yStart = yHeight - imageHeight;
                    break;
                }
                case 12: {
                    xStart = xWidth - imageWidth;
                    yStart = yHeight - imageHeight;
                    break;
                }
                case 8: {
                    xStart = xWidth - imageWidth;
                    yStart = (yHeight - imageHeight) / 2;
                    break;
                }
                case 16: {
                    xStart = 0;
                    yStart = (yHeight - imageHeight) / 2;
                }
            }
            if (xWidth > imageWidth && yHeight > imageHeight) {
                g.fillRect(0, 0, xWidth, yHeight);
            } else {
                int anchor;
                if (yHeight > imageHeight) {
                    anchor = this.canvas.getJustificationPolicy();
                    if ((anchor & 2) != 0) {
                        g.fillRect(0, imageHeight, xWidth, yHeight - imageHeight);
                    } else if ((anchor & 4) != 0) {
                        g.fillRect(0, 0, xWidth, yHeight - imageHeight);
                    } else {
                        g.fillRect(0, 0, xWidth, (yHeight - imageHeight) / 2);
                        g.fillRect(0, imageHeight + (yHeight - imageHeight) / 2, xWidth, (yHeight - imageHeight) / 2);
                    }
                }
                if (xWidth > imageWidth) {
                    anchor = this.canvas.getJustificationPolicy();
                    if ((anchor & 8) != 0) {
                        g.fillRect(0, 0, xWidth - imageWidth, yHeight);
                    } else if ((anchor & 0x10) != 0) {
                        g.fillRect(imageWidth, 0, xWidth - imageWidth, yHeight);
                    } else {
                        g.fillRect(0, 0, (xWidth - imageWidth) / 2, yHeight);
                        g.fillRect(imageWidth + (xWidth - imageWidth) / 2, 0, (xWidth - imageWidth) / 2, yHeight);
                    }
                }
            }
            if (xWidth < imageWidth) {
                xStart = this.cachedArea.x - this.position.x;
            }
            if (yHeight < imageHeight) {
                yStart = this.cachedArea.y - this.position.y;
            }
            g.drawImage(this.cached, xStart, yStart, null);
        }
    }

    protected Point calculatePosition() {
        int xWidth = this.size().width;
        int yHeight = this.size().height;
        int yStart = 0;
        int xStart = 0;
        int imageWidth = this.raster.getWidth();
        int imageHeight = this.raster.getHeight();
        switch (this.canvas.getJustificationPolicy()) {
            case 0: {
                xStart = (xWidth - imageWidth) / 2;
                yStart = (yHeight - imageHeight) / 2;
                break;
            }
            case 18: {
                xStart = 0;
                yStart = 0;
                break;
            }
            case 10: {
                xStart = xWidth - imageWidth;
                yStart = 0;
                break;
            }
            case 2: {
                xStart = (xWidth - imageWidth) / 2;
                yStart = 0;
                break;
            }
            case 4: {
                xStart = (xWidth - imageWidth) / 2;
                yStart = yHeight - imageHeight;
                break;
            }
            case 20: {
                xStart = 0;
                yStart = yHeight - imageHeight;
                break;
            }
            case 12: {
                xStart = xWidth - imageWidth;
                yStart = yHeight - imageHeight;
                break;
            }
            case 8: {
                xStart = xWidth - imageWidth;
                yStart = (yHeight - imageHeight) / 2;
                break;
            }
            case 16: {
                xStart = 0;
                yStart = (yHeight - imageHeight) / 2;
            }
        }
        this.offset.x = xStart;
        this.offset.y = yStart;
        if (xWidth < imageWidth) {
            this.offset.x = this.cachedArea.x - this.position.x;
        }
        if (yHeight < imageHeight) {
            this.offset.y = this.cachedArea.y - this.position.y;
        }
        return this.offset;
    }
}

