/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.component;

import com.sun.jimi.core.Jimi;
import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.component.JimiCanvas;
import com.sun.jimi.core.component.JimiImageRenderer;
import com.sun.jimi.core.component.SmartCroppingPanel;
import com.sun.jimi.core.raster.JimiRasterImage;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.ImageProducer;

public class SmartScrollingRenderer
extends Panel
implements JimiImageRenderer,
AdjustmentListener {
    protected JimiRasterImage rasterImage;
    protected Scrollbar vsb;
    protected Scrollbar hsb;
    protected SmartCroppingPanel cropper;
    protected JimiCanvas canvas;
    static int count = 0;

    public SmartScrollingRenderer(JimiCanvas canvas) {
        this.canvas = canvas;
        this.vsb = new Scrollbar(1, 0, 10, 0, 100);
        this.hsb = new Scrollbar(0, 0, 10, 0, 100);
        this.vsb.setUnitIncrement(10);
        this.hsb.setUnitIncrement(10);
        this.vsb.addAdjustmentListener(this);
        this.hsb.addAdjustmentListener(this);
        this.addComponentListener(new ResizeListener());
        this.cropper = new SmartCroppingPanel(canvas);
        this.setLayout(new BorderLayout());
        this.add("Center", this.cropper);
        this.add("East", this.vsb);
        this.add("South", this.hsb);
        this.vsb.setVisible(false);
        this.hsb.setVisible(false);
        this.addComponentListener(new ResizeWatcher());
    }

    protected void calibrateScrolling() {
        if (this.rasterImage != null) {
            int imageWidth = this.rasterImage.getWidth();
            int imageHeight = this.rasterImage.getHeight();
            int componentWidth = this.cropper.getSize().width;
            int componentHeight = this.cropper.getSize().height;
            if (imageWidth <= componentWidth && imageHeight <= componentHeight) {
                this.hsb.setVisible(false);
                this.vsb.setVisible(false);
            } else {
                int offscreenWidth = imageWidth - componentWidth;
                int offscreenHeight = imageHeight - componentHeight;
                this.vsb.setValues(0, componentHeight, 0, imageHeight);
                this.hsb.setValues(0, componentWidth, 0, imageWidth);
                this.vsb.setBlockIncrement(componentHeight);
                this.vsb.setPageIncrement(componentHeight);
                this.hsb.setBlockIncrement(componentHeight);
                this.hsb.setPageIncrement(componentHeight);
                this.hsb.setVisible(true);
                this.vsb.setVisible(true);
            }
            this.validate();
        }
    }

    public void setImage(Image image) {
        if (image == null) {
            return;
        }
        try {
            this.setRasterImage(Jimi.createRasterImage(image.getSource()));
        }
        catch (JimiException jimiException) {
            // empty catch block
        }
    }

    public void setImageProducer(ImageProducer producer) {
        if (producer == null) {
            return;
        }
        try {
            this.setRasterImage(Jimi.createRasterImage(producer));
        }
        catch (JimiException jimiException) {
            // empty catch block
        }
    }

    public void setRasterImage(JimiRasterImage raster) {
        if (raster == null) {
            return;
        }
        raster.waitFinished();
        this.rasterImage = raster;
        this.cropper.setImage(raster);
        this.calibrateScrolling();
    }

    public Component getContentPane() {
        return this;
    }

    public void render() {
        this.cropper.redraw();
    }

    public void adjustmentValueChanged(AdjustmentEvent e) {
        switch (e.getID()) {
            case 601: {
                break;
            }
        }
        this.cropper.setPosition(this.hsb.getValue(), this.vsb.getValue());
    }

    class ResizeWatcher
    extends ComponentAdapter {
        ResizeWatcher() {
        }

        public void componentResized(ComponentEvent event) {
            SmartScrollingRenderer.this.calibrateScrolling();
        }
    }

    class ResizeListener
    extends ComponentAdapter {
        ResizeListener() {
        }

        public void componentResized(ComponentEvent e) {
            SmartScrollingRenderer.this.calibrateScrolling();
        }
    }
}

