/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.decoder.apf;

import com.sun.jimi.core.ImageAccessException;
import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.JimiImageFactory;
import com.sun.jimi.core.JimiSingleImageRasterDecoder;
import com.sun.jimi.core.decoder.apf.APFDecoderFactory;
import com.sun.jimi.core.raster.IntRasterImage;
import com.sun.jimi.core.raster.MutableJimiRasterImage;
import java.awt.image.ColorModel;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class APFDecoder
extends JimiSingleImageRasterDecoder {
    protected int width;
    protected int height;
    protected DataInputStream dataInput;
    protected IntRasterImage jimiImage;

    public MutableJimiRasterImage doInitDecoding(JimiImageFactory factory, InputStream input) throws JimiException, IOException {
        this.readHeader();
        this.createJimiImage();
        return this.jimiImage;
    }

    public void doImageDecode() throws JimiException, IOException {
        this.readData();
        this.jimiImage.setFinished();
    }

    protected void readHeader() throws JimiException, IOException {
        byte[] formatSignature = APFDecoderFactory.FORMAT_SIGNATURES[0];
        byte[] inputBytes = new byte[formatSignature.length];
        this.getInput().read(inputBytes);
        for (int i = 0; i < formatSignature.length; ++i) {
            if (formatSignature[i] == inputBytes[i]) continue;
            throw new JimiException("Invalid format signature.");
        }
        this.dataInput = new DataInputStream(this.getInput());
        this.width = this.dataInput.readInt();
        this.height = this.dataInput.readInt();
    }

    protected void createJimiImage() throws JimiException {
        this.jimiImage = this.getJimiImageFactory().createIntRasterImage(this.width, this.height, ColorModel.getRGBdefault());
    }

    protected void readData() throws IOException, ImageAccessException {
        int[] buffer = new int[this.width];
        for (int row = 0; row < this.height; ++row) {
            for (int x = 0; x < this.width; ++x) {
                buffer[x] = this.dataInput.readInt();
            }
            this.jimiImage.setRow(row, buffer, 0);
            this.setProgress((row + 1) * 1000 / this.height);
        }
    }
}

