/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.decoder.bmp;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.compat.AdaptiveRasterImage;
import com.sun.jimi.core.compat.JimiDecoderBase;
import com.sun.jimi.core.decoder.bmp.BMPColorMap;
import com.sun.jimi.core.decoder.bmp.BMPFileHeader;
import com.sun.jimi.core.util.JimiUtil;
import com.sun.jimi.core.util.LEDataInputStream;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class BMPDecoder
extends JimiDecoderBase {
    private AdaptiveRasterImage ji_;
    private InputStream in_;
    private LEDataInputStream leInput;
    private int state;
    private BMPFileHeader bmpHeader;
    private BMPColorMap bmpColorMap;
    private ColorModel model;
    byte[] rawScanLine;
    int[] intScanLine;
    byte[] byteScanLine;

    public void initDecoder(InputStream in, AdaptiveRasterImage ji) throws JimiException {
        this.bmpHeader = null;
        this.bmpColorMap = null;
        this.in_ = in;
        this.leInput = new LEDataInputStream(new BufferedInputStream(this.in_));
        this.ji_ = ji;
        this.state = 0;
    }

    public boolean driveDecoder() throws JimiException {
        try {
            this.bmpHeader = new BMPFileHeader(this.leInput);
            this.bmpColorMap = new BMPColorMap(this.leInput, this.bmpHeader);
            this.initJimiImage();
            this.state |= 2;
            this.loadImage(this.leInput);
            this.ji_.addFullCoverage();
            this.state |= 4;
        }
        catch (IOException e) {
            this.state |= 1;
            throw new JimiException("IO error reading BMP file");
        }
        catch (JimiException e) {
            this.state |= 1;
            throw e;
        }
        return false;
    }

    public void freeDecoder() throws JimiException {
        this.in_ = null;
        this.ji_ = null;
    }

    public int getState() {
        return this.state;
    }

    public AdaptiveRasterImage getJimiImage() {
        return this.ji_;
    }

    private void initJimiImage() throws JimiException {
        this.ji_.setSize(this.bmpHeader.width, this.bmpHeader.height);
        if (this.bmpHeader.bitsPerPixel == 32) {
            this.model = ColorModel.getRGBdefault();
        } else if (this.bmpHeader.bitsPerPixel == 24) {
            this.model = new DirectColorModel(24, 0xFF0000, 65280, 255);
        } else if (this.bmpHeader.bitsPerPixel == 16) {
            this.model = new DirectColorModel(16, this.bmpHeader.redMask, this.bmpHeader.greenMask, this.bmpHeader.blueMask, this.bmpHeader.alphaMask);
        } else {
            if (this.bmpColorMap.noOfEntries <= 0) {
                throw new JimiException("8 bit or less bitsperpixel requies pallete");
            }
            this.model = new IndexColorModel(8, this.bmpColorMap.noOfEntries, this.bmpColorMap.r, this.bmpColorMap.g, this.bmpColorMap.b);
        }
        this.ji_.setColorModel(this.model);
        this.ji_.setPixels();
        if (this.bmpHeader.bitsPerPixel == 32) {
            this.intScanLine = new int[this.bmpHeader.scanLineSize / 4];
        }
        if (this.bmpHeader.bitsPerPixel == 24) {
            this.intScanLine = new int[this.bmpHeader.scanLineSize / 3];
        }
        if (this.bmpHeader.bitsPerPixel == 16) {
            this.intScanLine = new int[this.bmpHeader.scanLineSize / 2];
        } else {
            this.byteScanLine = new byte[this.bmpHeader.width];
        }
        this.rawScanLine = new byte[this.bmpHeader.scanLineSize];
    }

    private void loadImage(LEDataInputStream leInput) throws JimiException, IOException {
        switch (this.bmpHeader.compression) {
            case 0: {
                break;
            }
            case 1: {
                this.ji_.setChannel(0L);
                this.unpackRLE8(leInput);
                return;
            }
            case 2: {
                this.ji_.setChannel(0L);
                this.unpackRLE4(leInput);
                return;
            }
            case 3: {
                break;
            }
            default: {
                throw new JimiException("Unsupported compression " + this.bmpHeader.compression);
            }
        }
        for (int i = this.bmpHeader.height - 1; i >= 0; --i) {
            leInput.readFully(this.rawScanLine, 0, this.bmpHeader.scanLineSize);
            if (this.bmpHeader.bitsPerPixel == 32) {
                this.pack32ToInt(this.rawScanLine, 0, this.intScanLine, 0, this.bmpHeader.width);
                this.ji_.setChannel(i, this.intScanLine);
            } else if (this.bmpHeader.bitsPerPixel == 24) {
                this.pack24ToInt(this.rawScanLine, 0, this.intScanLine, 0, this.bmpHeader.width);
                this.ji_.setChannel(i, this.intScanLine);
            } else if (this.bmpHeader.bitsPerPixel == 16) {
                this.pack16ToInt(this.rawScanLine, 0, this.intScanLine, 0, this.bmpHeader.width);
                this.ji_.setChannel(i, this.intScanLine);
            } else if (this.bmpHeader.bitsPerPixel < 8) {
                JimiUtil.expandPixels(this.bmpHeader.bitsPerPixel, this.rawScanLine, this.byteScanLine, this.bmpHeader.width);
                this.ji_.setChannel(0, i, this.byteScanLine);
            } else {
                this.ji_.setChannel(0, i, this.rawScanLine, 0, this.bmpHeader.width);
            }
            this.setProgress((this.bmpHeader.height - i - 1) * 100 / (this.bmpHeader.height - 1));
        }
    }

    private void pack16ToInt(byte[] rawData, int rawOffset, int[] intData, int intOffset, int w) {
        int j = intOffset;
        int k = rawOffset;
        int mask = 255;
        for (int i = 0; i < w; ++i) {
            int b0 = rawData[k++] & mask;
            int b1 = (rawData[k++] & mask) << 8;
            intData[j] = b0 | b1;
            ++j;
        }
    }

    private void pack24ToInt(byte[] rawData, int rawOffset, int[] intData, int intOffset, int w) {
        int j = intOffset;
        int k = rawOffset;
        int mask = 255;
        for (int i = 0; i < w; ++i) {
            int b0 = rawData[k++] & mask;
            int b1 = (rawData[k++] & mask) << 8;
            int b2 = (rawData[k++] & mask) << 16;
            intData[j] = 0xFF000000 | b0 | b1 | b2;
            ++j;
        }
    }

    private void pack32ToInt(byte[] rawData, int rawOffset, int[] intData, int intOffset, int w) {
        int j = intOffset;
        int k = rawOffset;
        int mask = 255;
        for (int i = 0; i < w; ++i) {
            int b0 = rawData[k++] & mask;
            int b1 = (rawData[k++] & mask) << 8;
            int b2 = (rawData[k++] & mask) << 16;
            int b3 = (rawData[k++] & mask) << 24;
            intData[j] = 0xFF000000 | b0 | b1 | b2;
            ++j;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void unpackRLE8(InputStream in) throws JimiException, IOException {
        int row = this.bmpHeader.height - 1;
        int col = 0;
        byte[] buf = new byte[this.bmpHeader.width];
        int o = 0;
        block5: while (true) {
            boolean oddSkip;
            int flagB;
            int b;
            if ((b = in.read()) < 0) {
                throw new EOFException();
            }
            if (b == 0) {
                flagB = in.read();
                if (flagB < 0) {
                    throw new EOFException();
                }
                switch (flagB) {
                    case 0: {
                        if (o > col) {
                            this.ji_.setChannel(0, col, row, o - col, 1, buf, col, buf.length);
                        }
                        o = 0;
                        col = 0;
                        this.setProgress((this.bmpHeader.height - 1 - --row) * 100 / (this.bmpHeader.height - 1));
                        continue block5;
                    }
                    case 1: {
                        return;
                    }
                    case 2: {
                        this.ji_.setChannel(0, col, row, o - col, 1, buf, col, buf.length);
                        int xDelta = in.read();
                        int yDelta = in.read();
                        o = col += xDelta;
                        row += yDelta;
                        continue block5;
                    }
                }
                oddSkip = false;
                if ((flagB & 1) != 0) {
                    oddSkip = true;
                }
            } else {
                int repB = in.read();
                if (repB < 0) {
                    throw new EOFException();
                }
                while (true) {
                    if (--b < 0) continue block5;
                    if (o == buf.length) {
                        this.ji_.setChannel(0, col, row, o - col, 1, buf, col, buf.length);
                        o = 0;
                        col = 0;
                        --row;
                    }
                    buf[o++] = (byte)repB;
                }
            }
            while (--flagB >= 0) {
                int b2 = in.read();
                if (b2 < 0) {
                    throw new EOFException();
                }
                if (o == buf.length) {
                    this.ji_.setChannel(0, col, row, o - col, 1, buf, col, buf.length);
                    o = 0;
                    col = 0;
                    this.setProgress((this.bmpHeader.height - 1 - --row) * 100 / (this.bmpHeader.height - 1));
                }
                buf[o++] = (byte)b2;
            }
            if (!oddSkip) continue;
            in.read();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void unpackRLE4(InputStream in) throws JimiException, IOException {
        int row = this.bmpHeader.height - 1;
        int col = 0;
        byte[] buf = new byte[this.bmpHeader.width];
        int o = 0;
        block5: while (true) {
            byte[] nybles;
            int nybI;
            boolean oddSkip;
            int flagB;
            int b;
            if ((b = in.read()) < 0) {
                throw new EOFException();
            }
            if (b == 0) {
                flagB = in.read();
                if (flagB < 0) {
                    throw new EOFException();
                }
                switch (flagB) {
                    case 0: {
                        if (o > col) {
                            this.ji_.setChannel(0, col, row, o - col, 1, buf, col, buf.length);
                        }
                        o = 0;
                        col = 0;
                        --row;
                        continue block5;
                    }
                    case 1: {
                        return;
                    }
                    case 2: {
                        if (o > col) {
                            this.ji_.setChannel(0, col, row, o - col, 1, buf, col, buf.length);
                        }
                        int xDelta = in.read();
                        int yDelta = in.read();
                        o = col += xDelta;
                        row += yDelta;
                        continue block5;
                    }
                }
                oddSkip = false;
                if ((flagB & 3) == 1 || (flagB & 3) == 2) {
                    oddSkip = true;
                }
                nybI = 0;
                nybles = new byte[2];
            } else {
                int repB = in.read();
                if (repB < 0) {
                    throw new EOFException();
                }
                byte[] nybles2 = new byte[]{(byte)((repB & 0xF0) >> 4), (byte)(repB & 0xF)};
                int nybI2 = 0;
                while (true) {
                    if (--b < 0) continue block5;
                    if (o == buf.length) {
                        if (o > col) {
                            this.ji_.setChannel(0, col, row, o - col, 1, buf, col, buf.length);
                        }
                        o = 0;
                        col = 0;
                        --row;
                    }
                    buf[o++] = nybles2[nybI2];
                    nybI2 ^= 1;
                }
            }
            while (--flagB >= 0) {
                if (nybI == 0) {
                    int b2 = in.read();
                    if (b2 < 0) {
                        throw new EOFException();
                    }
                    nybles[0] = (byte)((b2 & 0xF0) >> 4);
                    nybles[1] = (byte)(b2 & 0xF);
                }
                if (o == buf.length) {
                    if (o > col) {
                        this.ji_.setChannel(0, col, row, o - col, 1, buf, col, buf.length);
                    }
                    o = 0;
                    col = 0;
                    --row;
                }
                buf[o++] = nybles[nybI];
                nybI ^= 1;
            }
            if (!oddSkip) continue;
            in.read();
        }
    }

    public boolean usesChanneledData() {
        return true;
    }
}

