/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.decoder.cur;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.compat.AdaptiveRasterImage;
import com.sun.jimi.core.compat.JimiDecoderBase;
import com.sun.jimi.core.decoder.ico.IconDir;
import com.sun.jimi.core.decoder.ico.IconImage;
import com.sun.jimi.core.decoder.ico.RGBQuad;
import com.sun.jimi.core.util.LEDataInputStream;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

public class CURDecoder
extends JimiDecoderBase {
    private AdaptiveRasterImage ji_;
    private InputStream in_;
    private LEDataInputStream din_;
    private int state;
    private IconDir curDir_;
    private byte[] byteScanLine;
    private ColorModel model_;

    public void initDecoder(InputStream in, AdaptiveRasterImage ji) throws JimiException {
        this.curDir_ = null;
        this.in_ = in;
        this.din_ = new LEDataInputStream(new BufferedInputStream(this.in_));
        this.din_.mark(4096);
        this.ji_ = ji;
        this.state = 0;
    }

    public boolean driveDecoder() throws JimiException {
        try {
            int i;
            this.curDir_ = new IconDir(this.din_);
            this.state |= 2;
            IconImage[] ii = new IconImage[this.curDir_.getCount()];
            for (i = 0; i < ii.length; ++i) {
                this.din_.reset();
                this.din_.skip(this.curDir_.getEntry(i).getImageOffset());
                ii[i] = new IconImage(this.din_);
            }
            this.initJimiImage(ii[0]);
            this.ji_.setChannel(0L);
            for (i = 0; i < ii[0].getHeight(); ++i) {
                this.ji_.setChannel(0, ii[0].getHeight() - 1 - i, ii[0].getXORMap(), i * ii[0].getWidth(), ii[0].getWidth());
                this.setProgress(i * 100 / ii[0].getHeight());
            }
            this.ji_.addFullCoverage();
            this.state |= 4;
        }
        catch (IOException e) {
            this.state |= 1;
            throw new JimiException("IO error reading CUR file");
        }
        catch (JimiException e) {
            this.state |= 1;
            throw e;
        }
        return false;
    }

    public void freeDecoder() throws JimiException {
        this.in_ = null;
        this.din_ = null;
        this.ji_ = null;
    }

    public int getState() {
        return this.state;
    }

    public AdaptiveRasterImage getJimiImage() {
        return this.ji_;
    }

    private void initJimiImage(IconImage ii) throws JimiException {
        this.ji_.setSize(ii.getWidth(), ii.getHeight());
        RGBQuad[] colors = ii.getColors();
        byte[] red = new byte[colors.length];
        byte[] green = new byte[colors.length];
        byte[] blue = new byte[colors.length];
        for (int i = 0; i < colors.length; ++i) {
            red[i] = (byte)colors[i].getRed();
            green[i] = (byte)colors[i].getGreen();
            blue[i] = (byte)colors[i].getBlue();
        }
        this.model_ = new IndexColorModel(8, red.length, red, green, blue);
        this.ji_.setColorModel(this.model_);
        this.ji_.setPixels();
    }
}

