/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.decoder.gif;

import com.sun.jimi.core.util.LEDataInputStream;
import java.io.IOException;

public class GIFColorTable {
    byte[] red;
    byte[] green;
    byte[] blue;

    public GIFColorTable(LEDataInputStream in, int numBitsColorTable) throws IOException {
        int numColors = 1 << numBitsColorTable;
        this.red = new byte[numColors];
        this.green = new byte[numColors];
        this.blue = new byte[numColors];
        for (int i = 0; i < numColors; ++i) {
            this.red[i] = in.readByte();
            this.green[i] = in.readByte();
            this.blue[i] = in.readByte();
        }
    }

    public GIFColorTable(int numBitsColorTable) throws IOException {
        int numColors = 1 << numBitsColorTable;
        this.red = new byte[numColors];
        this.green = this.red;
        this.blue = this.red;
        this.red[0] = -1;
        for (int i = 1; i < numColors; ++i) {
            this.red[i] = (byte)((i - 1) * 255 / (numColors - 1));
        }
    }
}

