/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.decoder.gif;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.compat.AdaptiveRasterImage;
import com.sun.jimi.core.compat.JimiDecoderBase;
import com.sun.jimi.core.decoder.gif.GIFColorTable;
import com.sun.jimi.core.decoder.gif.GIFFileHeader;
import com.sun.jimi.core.decoder.gif.GIFGraphicExt;
import com.sun.jimi.core.decoder.gif.GIFImageDescriptor;
import com.sun.jimi.core.options.GIFOptions;
import com.sun.jimi.core.util.LEDataInputStream;
import com.sun.jimi.core.util.lzw.LZWDecompressor;
import java.awt.image.IndexColorModel;
import java.io.IOException;
import java.io.InputStream;

public class GIFDecoder
extends JimiDecoderBase {
    static final byte IMAGE_SEPERATOR = 44;
    static final byte EXTENSION_INTRODUCER = 33;
    static final byte GRAPHIC_CONTROL_EXTENSION = -7;
    static final byte COMMENT_EXTENSION = -2;
    static final byte APPLICATION_EXTENSION = -1;
    static final byte PLAINTEXT_EXTENSION = 1;
    static final byte TRAILER = 59;
    private AdaptiveRasterImage ji_;
    private InputStream in_;
    private LEDataInputStream dIn_;
    private volatile int state_;
    GIFFileHeader gifFH_;
    GIFGraphicExt gifGraphicExt_;
    protected int numberOfLoops_ = 1;
    boolean gotPrevImageSeperator_;
    String comment_;
    AdaptiveRasterImage baseJI_;
    GIFImageDescriptor imageDescriptor_;
    int disposal_ = 0;
    int xOffset_ = 0;
    int yOffset_ = 0;
    int dWidth_ = 0;
    int dHeight_ = 0;
    byte[] prevSaved_;
    int imageDelay_ = 0;

    public void initDecoder(InputStream in, AdaptiveRasterImage ji) throws JimiException {
        this.in_ = in;
        this.dIn_ = new LEDataInputStream(in);
        this.ji_ = ji;
        this.state_ = 8;
        this.gifFH_ = null;
        this.gifGraphicExt_ = null;
        this.gotPrevImageSeperator_ = false;
        this.baseJI_ = null;
    }

    public synchronized boolean driveDecoder() throws JimiException {
        try {
            if (this.gifFH_ == null) {
                this.gifFH_ = new GIFFileHeader(this.dIn_);
            }
            this.getNextImage(this.dIn_, this.ji_);
            this.ji_.addFullCoverage();
            this.state_ |= 6;
        }
        catch (IOException e) {
            this.state_ &= 0xFFFFFFF7;
            throw new JimiException(e.getMessage());
        }
        catch (JimiException e) {
            this.state_ &= 0xFFFFFFF7;
            throw new JimiException(e.getMessage());
        }
        return false;
    }

    void setOptions(AdaptiveRasterImage ji) throws JimiException {
        GIFOptions options = new GIFOptions();
        options.setInterlaced(this.imageDescriptor_.interlace);
        options.setNumberOfLoops(this.numberOfLoops_);
        if (this.gifGraphicExt_ != null) {
            options.setFrameDelay(this.gifGraphicExt_.delayTime);
            if ((this.gifGraphicExt_.packed & 1) != 0) {
                options.setTransparentIndex(this.gifGraphicExt_.colorIndex);
            }
            if ((this.imageDescriptor_.packed & 0x80) != 0) {
                options.setUseLocalPalettes(true);
            }
        }
        ji.setOptions(options);
    }

    public void freeDecoder() throws JimiException {
        this.in_ = null;
        this.dIn_ = null;
        this.ji_ = null;
    }

    public int getState() {
        return this.state_;
    }

    public AdaptiveRasterImage getJimiImage() {
        return this.ji_;
    }

    public int getNumberOfImages() {
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void getNextImage(LEDataInputStream in, AdaptiveRasterImage ji) throws JimiException, IOException {
        boolean imageDecoded = false;
        AdaptiveRasterImage loadingJI = this.createAdaptiveRasterImage();
        block10: while (true) {
            int b = this.gotPrevImageSeperator_ ? 44 : (int)in.readByte();
            switch (b) {
                case 44: {
                    GIFImageDescriptor gifImageD;
                    if (imageDecoded) {
                        this.gotPrevImageSeperator_ = true;
                        return;
                    }
                    this.imageDescriptor_ = gifImageD = new GIFImageDescriptor(in);
                    this.initJimiImage(gifImageD, loadingJI);
                    this.decodeImage(in, gifImageD, loadingJI);
                    loadingJI.addFullCoverage();
                    this.addImageDelta(gifImageD, loadingJI, this.ji_);
                    this.gifGraphicExt_ = null;
                    imageDecoded = true;
                    this.gotPrevImageSeperator_ = false;
                    break;
                }
                case 59: {
                    this.state_ &= 0xFFFFFFF7;
                    this.gotPrevImageSeperator_ = false;
                    this.gifGraphicExt_ = null;
                    return;
                }
                case 33: {
                    b = this.dIn_.readByte();
                    switch (b) {
                        case -1: 
                        case 1: {
                            int len;
                            byte blockSize = in.readByte();
                            byte[] block = new byte[blockSize];
                            in.readFully(block);
                            String blockString = new String(block);
                            if (blockString.equals("NETSCAPE2.0")) {
                                int subBlockSize = in.read();
                                byte[] subBlock = new byte[subBlockSize];
                                for (int i = 0; i < subBlock.length; ++i) {
                                    subBlock[i] = (byte)in.read();
                                }
                                if (subBlockSize == 3 && subBlock[0] == 1) {
                                    this.numberOfLoops_ = (subBlock[2] & 0xFF) << 8;
                                    this.numberOfLoops_ |= subBlock[1] & 0xFF;
                                    if (this.numberOfLoops_ != 0) {
                                        ++this.numberOfLoops_;
                                    }
                                }
                            }
                            while ((len = in.readUnsignedByte()) != 0) {
                                in.skip(len);
                            }
                            break;
                        }
                        case -2: {
                            int len;
                            if (this.comment_ == null) {
                                while (true) {
                                    if ((len = in.readUnsignedByte()) == 0) continue block10;
                                    byte[] tmp = new byte[len];
                                    in.readFully(tmp);
                                    this.comment_ = this.comment_ + new String(tmp, 0);
                                }
                            }
                            while ((len = in.readUnsignedByte()) != 0) {
                                in.skip(len);
                            }
                            break;
                        }
                        case -7: {
                            this.gifGraphicExt_ = new GIFGraphicExt(in);
                        }
                    }
                    continue block10;
                }
            }
        }
    }

    void disposePreviousDelta() throws JimiException {
        switch (this.disposal_) {
            case 0: 
            case 1: {
                break;
            }
            case 2: {
                int i;
                byte[] buf = new byte[this.dWidth_];
                if (this.gifGraphicExt_ != null && (this.gifGraphicExt_.packed & 1) != 0) {
                    for (i = 0; i < buf.length; ++i) {
                        buf[i] = (byte)this.gifGraphicExt_.colorIndex;
                    }
                }
                if ((this.gifFH_.packed & 0x80) != 0) {
                    if (this.gifGraphicExt_ != null && (this.gifGraphicExt_.packed & 1) != 0) {
                        for (i = 0; i < buf.length; ++i) {
                            buf[i] = (byte)this.gifGraphicExt_.colorIndex;
                        }
                    } else {
                        i = this.dWidth_;
                        while (--i >= 0) {
                            buf[i] = this.gifFH_.backgroundColor;
                        }
                    }
                }
                for (int row = this.yOffset_; row < this.yOffset_ + this.dHeight_; ++row) {
                    this.baseJI_.setChannel(0, this.xOffset_, row, this.dWidth_, 1, buf, 0, 0);
                }
                break;
            }
            case 3: {
                if (this.prevSaved_ == null) {
                    throw new RuntimeException("Internal GIFDecoder Error");
                }
                this.baseJI_.setChannel(0, this.xOffset_, this.yOffset_, this.dWidth_, this.dHeight_, this.prevSaved_, 0, this.dWidth_);
            }
        }
    }

    void saveForNextDelta() throws JimiException {
        switch (this.disposal_) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                this.prevSaved_ = new byte[this.dWidth_ * this.dHeight_];
                int savedOffset = 0;
                byte[] buf = new byte[this.baseJI_.getWidth()];
                for (int row = this.yOffset_; row < this.yOffset_ + this.dHeight_; ++row) {
                    this.baseJI_.getChannel(0, row, buf, 0);
                    System.arraycopy(buf, this.xOffset_, this.prevSaved_, savedOffset, this.dWidth_);
                    savedOffset += this.dWidth_;
                }
                break;
            }
        }
    }

    void addImageDelta(GIFImageDescriptor gifID, AdaptiveRasterImage in, AdaptiveRasterImage out) throws JimiException {
        boolean first;
        this.setOptions(out);
        boolean bl = first = this.baseJI_ == null;
        if (this.baseJI_ == null) {
            this.baseJI_ = this.createAdaptiveRasterImage(this.gifFH_.screenWidth, this.gifFH_.screenHeight, in.getColorModel());
            this.setOptions(this.baseJI_);
            this.baseJI_.setPixels();
            if ((this.gifFH_.packed & 0x80) != 0) {
                this.baseJI_.setChannel(this.gifFH_.backgroundColor);
            }
            this.baseJI_.addFullCoverage();
        }
        this.disposePreviousDelta();
        if (this.gifGraphicExt_ != null) {
            this.disposal_ = (this.gifGraphicExt_.packed & 0x1C) >> 2;
            this.imageDelay_ = this.gifGraphicExt_.delayTime;
        }
        this.xOffset_ = gifID.left;
        this.yOffset_ = gifID.top;
        this.dWidth_ = gifID.width;
        this.dHeight_ = gifID.height;
        this.saveForNextDelta();
        byte[] buf = new byte[this.dWidth_];
        int rowOut = this.yOffset_;
        for (int rowIn = 0; rowIn < this.dHeight_; ++rowIn) {
            in.getChannel(0, rowIn, buf, 0);
            if (first || this.gifGraphicExt_ == null || (this.gifGraphicExt_.packed & 1) == 0) {
                this.baseJI_.setChannel(0, this.xOffset_, rowOut, this.dWidth_, 1, buf, 0, 0);
            } else {
                int transIndex = this.gifGraphicExt_.colorIndex;
                int lastIndex = 0;
                boolean hasPixels = false;
                for (int currentIndex = 0; currentIndex < buf.length; ++currentIndex) {
                    if (buf[currentIndex] == transIndex || currentIndex == buf.length - 1) {
                        if (!hasPixels) continue;
                        this.baseJI_.setChannel(0, this.xOffset_ + lastIndex, rowOut, currentIndex - lastIndex, 1, buf, lastIndex, 0);
                        hasPixels = false;
                        continue;
                    }
                    if (hasPixels) continue;
                    lastIndex = currentIndex;
                    hasPixels = true;
                }
            }
            ++rowOut;
        }
        this.baseJI_.setColorModel(in.getColorModel());
        if (this.comment_ != null) {
            this.comment_ = null;
        }
        buf = new byte[this.baseJI_.getWidth()];
        out.setSize(this.baseJI_.getWidth(), this.baseJI_.getHeight());
        out.setColorModel(this.baseJI_.getColorModel());
        this.setOptions(out);
        out.setPixels();
        for (int row = 0; row < this.baseJI_.getHeight(); ++row) {
            this.baseJI_.getChannel(0, row, buf, 0);
            out.setChannel(0, row, buf);
        }
    }

    private void initJimiImage(GIFImageDescriptor gifImageD, AdaptiveRasterImage ji) throws JimiException {
        GIFColorTable ct;
        if ((gifImageD.packed & 0x80) != 0) {
            ct = gifImageD.colorTable;
            int colorTableNumBits = gifImageD.colorTableNumBits;
        } else {
            ct = this.gifFH_.colorTable;
            int colorTableNumBits = this.gifFH_.colorTableNumBits;
        }
        IndexColorModel cm = this.gifGraphicExt_ != null && (this.gifGraphicExt_.packed & 1) != 0 ? new IndexColorModel(8, ct.red.length, ct.red, ct.green, ct.blue, this.gifGraphicExt_.colorIndex) : new IndexColorModel(8, ct.red.length, ct.red, ct.green, ct.blue);
        ji.setColorModel(cm);
        ji.setSize(gifImageD.width, gifImageD.height);
        this.setOptions(ji);
        ji.setPixels();
    }

    private void decodeImage(LEDataInputStream in, GIFImageDescriptor gifID, AdaptiveRasterImage ji) throws JimiException, IOException {
        int height = gifID.height;
        byte codeSize = in.readByte();
        LZWDecompressor lzwD = new LZWDecompressor(in, codeSize, false);
        byte[] buf = new byte[gifID.width];
        int rowProgress = 0;
        if (gifID.interlace) {
            int row;
            ji.setHints(22);
            for (row = 0; row < height; row += 8) {
                lzwD.decompress(buf);
                ji.setChannel(0, row, buf);
                this.setProgress(rowProgress++ * 100 / gifID.height);
            }
            for (row = 4; row < height; row += 8) {
                lzwD.decompress(buf);
                ji.setChannel(0, row, buf);
                this.setProgress(rowProgress++ * 100 / gifID.height);
            }
            for (row = 2; row < height; row += 4) {
                lzwD.decompress(buf);
                ji.setChannel(0, row, buf);
                this.setProgress(rowProgress++ * 100 / gifID.height);
            }
            for (row = 1; row < height; row += 2) {
                lzwD.decompress(buf);
                ji.setChannel(0, row, buf);
                this.setProgress(rowProgress++ * 100 / gifID.height);
            }
            this.setProgress(100);
        } else {
            for (int row = 0; row < height; ++row) {
                lzwD.decompress(buf);
                ji.setChannel(0, row, buf);
                this.setProgress(row * 100 / height);
            }
        }
        lzwD.gifFinishBlocks();
    }

    public int getCapabilities() {
        return 1;
    }

    public void setJimiImage(AdaptiveRasterImage ji) {
        this.ji_ = ji;
    }

    public void skipImage() throws JimiException {
        AdaptiveRasterImage ji = this.createAdaptiveRasterImage();
        try {
            if (this.gifFH_ == null) {
                this.gifFH_ = new GIFFileHeader(this.dIn_);
            }
            this.getNextImage(this.dIn_, ji);
        }
        catch (IOException e) {
            throw new JimiException(e.getMessage());
        }
    }

    public boolean usesChanneledData() {
        return true;
    }

    public boolean mustWaitForOptions() {
        return true;
    }
}

