/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.decoder.ico;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.compat.AdaptiveRasterImage;
import com.sun.jimi.core.compat.JimiDecoderBase;
import com.sun.jimi.core.decoder.ico.IconDir;
import com.sun.jimi.core.decoder.ico.IconImage;
import com.sun.jimi.core.decoder.ico.RGBQuad;
import com.sun.jimi.core.util.LEDataInputStream;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class ICODecoder
extends JimiDecoderBase {
    protected static final int STREAM_BUFFER_SIZE = 10240;
    private AdaptiveRasterImage ji_;
    private InputStream in_;
    private LEDataInputStream din_;
    private int state;
    private int numberOfImages_ = -1;
    private int currentImage_;
    private IconDir iconDir_;
    private byte[] byteScanLine;
    private ColorModel model_;
    private IconImage[] ii_;

    public void initDecoder(InputStream in, AdaptiveRasterImage ji) throws JimiException {
        this.state = 8;
        this.in_ = in;
        BufferedInputStream bin = new BufferedInputStream(in, 2048);
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        byte[] buf = new byte[10240];
        try {
            while (bin.read(buf) != -1) {
                byteOut.write(buf);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        this.din_ = new LEDataInputStream(new ByteArrayInputStream(byteOut.toByteArray()));
        this.din_.mark(buf.length);
        this.ji_ = ji;
        try {
            this.iconDir_ = new IconDir(this.din_);
            this.numberOfImages_ = this.iconDir_.getCount();
            this.ii_ = new IconImage[this.numberOfImages_];
            this.state |= 2;
            this.currentImage_ = 0;
            if (this.numberOfImages_ > 0) {
                this.state |= 8;
            }
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public int getNumberOfImages() {
        return this.numberOfImages_;
    }

    public int getCapabilities() {
        return 1;
    }

    public void setJimiImage(AdaptiveRasterImage ji) {
        this.ji_ = ji;
    }

    public void skipImage() throws JimiException {
        ++this.currentImage_;
        if (this.currentImage_ >= this.numberOfImages_) {
            this.state ^= 8;
        }
    }

    protected void loadImage() throws JimiException {
        try {
            if (this.ii_[this.currentImage_] == null) {
                try {
                    this.din_.reset();
                    this.din_.skip(this.iconDir_.getEntry(this.currentImage_).getImageOffset());
                    this.ii_[this.currentImage_] = new IconImage(this.din_);
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            this.initJimiImage(this.ii_[this.currentImage_]);
            this.ji_.setChannel(0L);
            for (int i = 0; i < this.ii_[this.currentImage_].getHeight(); ++i) {
                this.ji_.setChannel(0, this.ii_[this.currentImage_].getHeight() - 1 - i, this.ii_[this.currentImage_].getXORMap(), i * this.ii_[this.currentImage_].getWidth(), this.ii_[this.currentImage_].getWidth());
                this.setProgress(i * 100 / this.ii_[this.currentImage_].getHeight());
            }
            this.state |= 4;
            ++this.currentImage_;
            if (this.currentImage_ >= this.numberOfImages_) {
                this.state ^= 8;
            }
        }
        catch (IndexOutOfBoundsException e) {
            this.state |= 1;
            throw new JimiException("No more images");
        }
        catch (JimiException e) {
            this.state |= 1;
            throw e;
        }
    }

    public boolean driveDecoder() throws JimiException {
        try {
            this.loadImage();
            this.ji_.addFullCoverage();
            this.state |= 6;
        }
        catch (JimiException e) {
            this.state |= 1;
            throw e;
        }
        return false;
    }

    public void freeDecoder() throws JimiException {
        this.in_ = null;
        this.din_ = null;
        this.ji_ = null;
    }

    public int getState() {
        return this.state;
    }

    public AdaptiveRasterImage getJimiImage() {
        return this.ji_;
    }

    private void initJimiImage(IconImage ii) throws JimiException {
        this.ji_.setSize(ii.getWidth(), ii.getHeight());
        RGBQuad[] colors = ii.getColors();
        byte[] red = new byte[colors.length];
        byte[] green = new byte[colors.length];
        byte[] blue = new byte[colors.length];
        for (int i = 0; i < colors.length; ++i) {
            red[i] = (byte)colors[i].getRed();
            green[i] = (byte)colors[i].getGreen();
            blue[i] = (byte)colors[i].getBlue();
        }
        this.model_ = new IndexColorModel(8, red.length, red, green, blue);
        this.ji_.setColorModel(this.model_);
        this.ji_.setPixels();
    }
}

