/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.decoder.ico;

import com.sun.jimi.core.decoder.ico.BitmapInfoHeader;
import com.sun.jimi.core.decoder.ico.RGBQuad;
import com.sun.jimi.core.util.LEDataInputStream;
import java.io.IOException;

public class IconImage {
    private static final boolean DEBUG = false;
    private BitmapInfoHeader header_;
    private RGBQuad[] colors_;
    private byte[] xorMap_;
    private byte[] andMap_;

    public IconImage(LEDataInputStream dis) throws IOException {
        try {
            int i;
            this.header_ = new BitmapInfoHeader(dis);
            int colorcount = (int)Math.pow(2.0, this.getBitCount());
            this.colors_ = new RGBQuad[colorcount];
            for (int i2 = 0; i2 < this.colors_.length; ++i2) {
                this.colors_[i2] = new RGBQuad(dis);
            }
            int length = (int)(this.header_.getWidth() * this.header_.getHeight() / 2L);
            this.xorMap_ = new byte[length];
            byte[] tempMap = new byte[length / (8 / this.getBitCount())];
            for (int i3 = 0; i3 < tempMap.length; ++i3) {
                byte xor;
                tempMap[i3] = xor = (byte)dis.readUnsignedByte();
            }
            int pixels_per_byte = this.getBitCount();
            switch (pixels_per_byte) {
                case 1: {
                    i = 0;
                    int j = 0;
                    while (i < tempMap.length) {
                        this.xorMap_[j] = (byte)((tempMap[i] & 0x80) >>> 7);
                        this.xorMap_[j + 1] = (byte)((tempMap[i] & 0x40) >>> 6);
                        this.xorMap_[j + 2] = (byte)((tempMap[i] & 0x20) >>> 5);
                        this.xorMap_[j + 3] = (byte)((tempMap[i] & 0x10) >>> 4);
                        this.xorMap_[j + 4] = (byte)((tempMap[i] & 8) >>> 3);
                        this.xorMap_[j + 5] = (byte)((tempMap[i] & 4) >>> 2);
                        this.xorMap_[j + 6] = (byte)((tempMap[i] & 2) >>> 1);
                        this.xorMap_[j + 7] = (byte)(tempMap[i] & 1);
                        ++i;
                        j += 8;
                    }
                    break;
                }
                case 3: {
                    i = 0;
                    int j = 0;
                    while (i < tempMap.length) {
                        this.xorMap_[j] = (byte)((tempMap[i] & 0xC0) >>> 6);
                        this.xorMap_[j + 1] = (byte)((tempMap[i] & 0x30) >>> 4);
                        this.xorMap_[j + 2] = (byte)((tempMap[i] & 0xC) >>> 2);
                        this.xorMap_[j + 3] = (byte)(tempMap[i] & 3);
                        ++i;
                        j += 4;
                    }
                    break;
                }
                case 4: {
                    i = 0;
                    int j = 0;
                    while (i < tempMap.length) {
                        this.xorMap_[j] = (byte)((tempMap[i] & 0xF0) >>> 4);
                        this.xorMap_[j + 1] = (byte)(tempMap[i] & 0xF);
                        ++i;
                        j += 2;
                    }
                    break;
                }
                case 8: {
                    this.xorMap_ = tempMap;
                }
            }
            this.andMap_ = new byte[length / 8];
            for (i = 0; i < this.andMap_.length; ++i) {
                byte and;
                this.andMap_[i] = and = (byte)dis.readUnsignedByte();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getBitCount() {
        return this.header_.getBitCount();
    }

    public int getWidth() {
        return (int)this.header_.getWidth();
    }

    public int getHeight() {
        return (int)this.header_.getHeight() / 2;
    }

    public RGBQuad[] getColors() {
        return this.colors_;
    }

    public byte[] getXORMap() {
        return this.xorMap_;
    }

    public byte[] getANDMap() {
        return this.andMap_;
    }
}

