/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.decoder.pcx;

import com.sun.jimi.core.decoder.pcx.PCXHeader;
import com.sun.jimi.core.util.LEDataInputStream;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;

public class PCXColorMap {
    private byte[] red;
    private byte[] green;
    private byte[] blue;
    private ColorModel colorModel;

    public PCXColorMap(LEDataInputStream dis, int fileLength, byte version) {
        if (version == PCXHeader.V3_0p) {
            try {
                dis.mark(fileLength);
                dis.skip(fileLength - 16 - 769);
                byte control = dis.readByte();
                if (control == 12) {
                    this.red = new byte[256];
                    this.green = new byte[256];
                    this.blue = new byte[256];
                    for (int i = 0; i < 256; ++i) {
                        this.red[i] = dis.readByte();
                        this.green[i] = dis.readByte();
                        this.blue[i] = dis.readByte();
                    }
                    this.colorModel = new IndexColorModel(8, 256, this.red, this.green, this.blue);
                    dis.reset();
                    dis.skip(48L);
                } else {
                    dis.reset();
                    this.red = new byte[16];
                    this.green = new byte[16];
                    this.blue = new byte[16];
                    for (int i = 0; i < 16; ++i) {
                        this.red[i] = dis.readByte();
                        this.green[i] = dis.readByte();
                        this.blue[i] = dis.readByte();
                    }
                    this.colorModel = new IndexColorModel(4, 16, this.red, this.green, this.blue);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public ColorModel getColorModel() {
        return this.colorModel;
    }
}

