/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.decoder.pcx;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.compat.AdaptiveRasterImage;
import com.sun.jimi.core.compat.JimiDecoderBase;
import com.sun.jimi.core.decoder.pcx.PCXHeader;
import com.sun.jimi.core.decoder.pcx.PCXImage;
import com.sun.jimi.core.util.LEDataInputStream;
import java.awt.image.ColorModel;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class PCXDecoder
extends JimiDecoderBase {
    private AdaptiveRasterImage ji_;
    private InputStream in_;
    private LEDataInputStream din_;
    private int state;
    private int fileLength;
    private PCXHeader header_;
    private byte[] byteScanLine;
    private ColorModel model_;
    private PCXImage pi;

    public void initDecoder(InputStream in, AdaptiveRasterImage ji) throws JimiException {
        this.in_ = in;
        BufferedInputStream bin = new BufferedInputStream(in, 2048);
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        int length = 0;
        try {
            int readBytes;
            while ((readBytes = bin.read(buf)) != -1) {
                length += readBytes;
                byteOut.write(buf);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        this.din_ = new LEDataInputStream(new ByteArrayInputStream(byteOut.toByteArray()));
        this.fileLength = length;
        this.ji_ = ji;
        this.state = 0;
    }

    protected void loadImage() throws JimiException {
        try {
            this.initJimiImage(this.pi);
            this.ji_.setChannel(0L);
            for (int i = 0; i < this.pi.getHeight(); ++i) {
                int offset = i * this.pi.getWidth();
                this.ji_.setChannel(0, i, this.pi.getImageData(), offset, this.pi.getWidth());
                this.setProgress(i * 100 / this.pi.getHeight());
            }
            this.state |= 4;
        }
        catch (IndexOutOfBoundsException e) {
            this.state |= 1;
            throw new JimiException("No more images");
        }
        catch (JimiException e) {
            this.state |= 1;
            throw e;
        }
    }

    public boolean driveDecoder() throws JimiException {
        try {
            this.header_ = new PCXHeader(this.din_, this.fileLength);
            this.state |= 2;
            this.pi = new PCXImage(this.din_, this.header_);
            this.loadImage();
            this.ji_.addFullCoverage();
        }
        catch (IOException e) {
            this.state |= 1;
            throw new JimiException("IO error reading PCX file");
        }
        catch (JimiException e) {
            this.state |= 1;
            throw e;
        }
        return false;
    }

    public void freeDecoder() throws JimiException {
        this.in_ = null;
        this.din_ = null;
        this.ji_ = null;
    }

    public int getState() {
        return this.state;
    }

    public AdaptiveRasterImage getJimiImage() {
        return this.ji_;
    }

    private void initJimiImage(PCXImage pi) throws JimiException {
        this.ji_.setSize(pi.getWidth(), pi.getHeight());
        this.ji_.setColorModel(this.header_.getColorModel());
        this.ji_.setPixels();
    }
}

