/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.decoder.pcx;

import com.sun.jimi.core.decoder.pcx.PCXColorMap;
import com.sun.jimi.core.util.LEDataInputStream;
import java.awt.image.ColorModel;
import java.io.IOException;

public class PCXHeader {
    public static byte PC_PAINTBRUSH = (byte)10;
    public static byte V2_5 = 0;
    public static byte V2_8p = (byte)2;
    public static byte V2_8 = (byte)3;
    public static byte V3_0p = (byte)5;
    public static byte RLE_ENCODING = 1;
    private byte manufacturer_;
    private byte version_;
    private byte encoding_;
    private byte depth_;
    private int width_;
    private int height_;
    private int xmin_;
    private int ymin_;
    private int xmax_;
    private int ymax_;
    private int hres_;
    private int vres_;
    private int nPlanes;
    private int bytesPerLine;
    private int paletteInfo;
    private PCXColorMap pcxColorMap;

    public PCXHeader(LEDataInputStream dis, int fileLength) throws IOException {
        this.manufacturer_ = (byte)dis.readUnsignedByte();
        this.version_ = (byte)dis.readUnsignedByte();
        this.encoding_ = (byte)dis.readUnsignedByte();
        this.depth_ = (byte)dis.readUnsignedByte();
        this.xmin_ = dis.readShort();
        this.ymin_ = dis.readShort();
        this.xmax_ = dis.readShort();
        this.ymax_ = dis.readShort();
        this.hres_ = dis.readShort();
        this.vres_ = dis.readShort();
        this.width_ = this.xmax_ - this.xmin_ + 1;
        this.height_ = this.ymax_ - this.ymin_ + 1;
        this.pcxColorMap = new PCXColorMap(dis, fileLength, this.version_);
        dis.skip(1L);
        this.nPlanes = dis.readByte();
        this.bytesPerLine = dis.readShort();
        this.paletteInfo = dis.readShort();
        dis.skip(58L);
    }

    public ColorModel getColorModel() {
        return this.pcxColorMap.getColorModel();
    }

    public int getDepth() {
        return this.depth_;
    }

    public int getPlanes() {
        return this.nPlanes;
    }

    public int getWidth() {
        if (this.width_ % 2 == 0) {
            return this.width_;
        }
        return this.width_ + 1;
    }

    public int getHeight() {
        return this.height_;
    }

    public int getBytesPerLine() {
        return this.bytesPerLine;
    }
}

