/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.decoder.pcx;

import com.sun.jimi.core.decoder.pcx.PCXHeader;
import com.sun.jimi.core.util.LEDataInputStream;
import java.io.IOException;

public class PCXImage {
    private PCXHeader header_;
    private byte[] imageData_;
    private int bytesPerLine_;
    private int bitCount_;
    private int planes_;
    private int count = 0;
    private int c = 0;

    public PCXImage(LEDataInputStream dis, PCXHeader header) throws IOException {
        this.header_ = header;
        this.planes_ = header.getPlanes();
        this.bytesPerLine_ = header.getBytesPerLine();
        this.bitCount_ = this.getBitCount();
        this.imageData_ = new byte[this.getHeight() * this.getWidth()];
        boolean col = false;
        block0 : switch (this.bitCount_) {
            case 1: {
                if (this.planes_ < 1 || this.planes_ > 4) break;
                this.get16ColorPCX(dis);
                break;
            }
            case 2: 
            case 4: {
                if (this.planes_ == 1) {
                    this.get16ColorPCX(dis);
                }
            }
            case 8: {
                switch (this.planes_) {
                    case 1: {
                        this.get256ColorPCX(dis);
                        break block0;
                    }
                    case 3: 
                    case 4: {
                        this.getTrueColorPCX(dis);
                    }
                }
            }
        }
    }

    public void get16ColorPCX(LEDataInputStream dis) throws IOException {
        int cols = this.getWidth();
        int rows = this.getHeight();
        int rawcols = this.bytesPerLine_ * 8 / this.bitCount_;
        if (cols > rawcols) {
            cols = rawcols;
        }
        byte[] rawrow = new byte[rawcols];
        byte[] pcxrow = new byte[this.planes_ * this.bytesPerLine_];
        for (int row = 0; row < rows; ++row) {
            this.getPCXRow(dis, pcxrow, this.planes_ * this.bytesPerLine_);
            if (this.planes_ == 1) {
                this.pcxUnpackPixels(rawrow, pcxrow);
            } else {
                this.pcxPlanesToPixels(rawrow, pcxrow);
            }
            for (int col = 0; col < cols; ++col) {
                this.imageData_[row * this.getWidth() + col] = rawrow[col];
            }
        }
    }

    public void getPCXRow(LEDataInputStream dis, byte[] pcxRow, int bytesPerLineTotal) {
        try {
            this.count = 0;
            int i = 0;
            boolean j = false;
            while (i < bytesPerLineTotal) {
                if (this.count > 0) {
                    pcxRow[i++] = (byte)this.c;
                    --this.count;
                    continue;
                }
                this.c = dis.readByte();
                if ((this.c & 0xC0) != 192) {
                    pcxRow[i++] = (byte)this.c;
                    continue;
                }
                this.count = this.c & 0x3F;
                this.c = dis.readByte();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void pcxUnpackPixels(byte[] unpacked, byte[] source) {
        block5: {
            int s_i;
            int bytesPerLine;
            block7: {
                block6: {
                    block4: {
                        bytesPerLine = this.bytesPerLine_;
                        int u_i = 0;
                        s_i = 0;
                        if (this.bitCount_ != 8) break block4;
                        while (--bytesPerLine >= 0) {
                            unpacked[u_i++] = source[s_i++];
                        }
                        break block5;
                    }
                    if (this.bitCount_ != 4) break block6;
                    while (--bytesPerLine >= 0) {
                        byte bits = source[s_i++];
                        unpacked[u_i++] = (byte)(bits >> 4 & 0xF);
                        unpacked[u_i++] = (byte)(bits & 0xF);
                    }
                    break block5;
                }
                if (this.bitCount_ != 2) break block7;
                while (--bytesPerLine >= 0) {
                    byte bits = source[s_i++];
                    unpacked[u_i++] = (byte)(bits >> 6 & 3);
                    unpacked[u_i++] = (byte)(bits >> 4 & 3);
                    unpacked[u_i++] = (byte)(bits >> 2 & 3);
                    unpacked[u_i++] = (byte)(bits & 3);
                }
                break block5;
            }
            if (this.bitCount_ != 1) break block5;
            while (--bytesPerLine >= 0) {
                byte bits = source[s_i++];
                unpacked[u_i++] = (byte)(bits >> 7 & 1);
                unpacked[u_i++] = (byte)(bits >> 6 & 1);
                unpacked[u_i++] = (byte)(bits >> 5 & 1);
                unpacked[u_i++] = (byte)(bits >> 4 & 1);
                unpacked[u_i++] = (byte)(bits >> 3 & 1);
                unpacked[u_i++] = (byte)(bits >> 2 & 1);
                unpacked[u_i++] = (byte)(bits >> 1 & 1);
                unpacked[u_i++] = (byte)(bits & 1);
            }
        }
    }

    public void pcxPlanesToPixels(byte[] pixels, byte[] bitplanes) {
        int p_i = 0;
        int b_i = 0;
        for (int i = 0; i < this.planes_; ++i) {
            p_i = 0;
            int pixbit = 1 << i;
            for (int j = 0; j < this.bytesPerLine_; ++j) {
                byte bits = bitplanes[b_i++];
                int mask = 128;
                while (mask != 0) {
                    if ((bits & mask) > 0) {
                        int n = p_i;
                        pixels[n] = (byte)(pixels[n] | pixbit);
                    }
                    mask >>= 1;
                    ++p_i;
                }
            }
        }
    }

    public void get256ColorPCX(LEDataInputStream dis) {
        try {
            for (int row = 0; row < this.getHeight(); ++row) {
                int col = 0;
                while (col < this.bytesPerLine_) {
                    byte control = dis.readByte();
                    int rlelength = 0;
                    if ((control & 0xC0) == 192) {
                        byte data = dis.readByte();
                        rlelength = control & 0x3F;
                        for (int i = 0; i < rlelength; ++i) {
                            this.imageData_[col + row * this.bytesPerLine_] = data;
                            ++col;
                        }
                        continue;
                    }
                    this.imageData_[col + row * this.bytesPerLine_] = control;
                    ++col;
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void getTrueColorPCX(LEDataInputStream dis) {
    }

    public int getBytesPerLine() {
        return this.bytesPerLine_;
    }

    public byte[] getImageData() {
        return this.imageData_;
    }

    public int getBitCount() {
        return this.header_.getDepth();
    }

    public int getWidth() {
        return this.header_.getWidth();
    }

    public int getHeight() {
        return this.header_.getHeight();
    }
}

