/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.decoder.pict;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.decoder.pict.PICTPixmap;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.DataInputStream;
import java.io.IOException;

class PICTColorTable {
    int id;
    short flags;
    short count;
    short[] red;
    short[] blue;
    short[] green;

    PICTColorTable(DataInputStream dIn) throws IOException {
        this.id = dIn.readInt();
        this.flags = dIn.readShort();
        this.count = dIn.readShort();
        this.count = (short)(this.count + 1);
        this.red = new short[this.count];
        this.green = new short[this.count];
        this.blue = new short[this.count];
        for (int i = 0; i < this.count; ++i) {
            int index = dIn.readShort();
            if ((this.flags & 0x8000) != 0) {
                index = i;
            }
            this.red[index] = dIn.readShort();
            this.green[index] = dIn.readShort();
            this.blue[index] = dIn.readShort();
        }
    }

    ColorModel createColorModel(PICTPixmap pxmap) throws JimiException {
        if (this.count < 2) {
            throw new JimiException("color count < 2");
        }
        byte[] red = new byte[this.count];
        byte[] green = new byte[this.count];
        byte[] blue = new byte[this.count];
        for (int i = 0; i < this.count; ++i) {
            red[i] = (byte)(this.red[i] >> 8);
            green[i] = (byte)(this.green[i] >> 8);
            blue[i] = (byte)(this.blue[i] >> 8);
        }
        IndexColorModel icm = new IndexColorModel(8, (int)this.count, red, green, blue);
        return icm;
    }
}

