/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.decoder.pict;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.compat.AdaptiveRasterImage;
import com.sun.jimi.core.compat.JimiDecoderBase;
import com.sun.jimi.core.decoder.pict.PICTBitmap;
import com.sun.jimi.core.decoder.pict.PICTColorTable;
import com.sun.jimi.core.decoder.pict.PICTFileHeader;
import com.sun.jimi.core.decoder.pict.PICTPixmap;
import com.sun.jimi.core.decoder.pict.PICTPixmap9A;
import com.sun.jimi.core.decoder.pict.PICTRectangle;
import com.sun.jimi.core.util.JimiUtil;
import com.sun.jimi.core.util.Packbits;
import com.sun.jimi.util.ByteCountInputStream;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class PICTDecoder
extends JimiDecoderBase {
    private AdaptiveRasterImage ji;
    private InputStream in;
    private ByteCountInputStream bcis;
    private DataInputStream dIn;
    private int state;
    PICTFileHeader pictFH;
    public static final int PICT_CLIP_RGN = 1;
    public static final int PICT_BITSRECT = 144;
    public static final int PICT_BITSRGN = 145;
    public static final int PICT_PACKBITSRECT = 152;
    public static final int PICT_PACKBITSRGN = 153;
    public static final int PICT_9A = 154;
    public static final int PICT_HEADER = 3072;
    public static final int PICT_END = 255;
    public static final int PICT_LONGCOMMENT = 161;
    int rowBytes;
    static final int INITIAL = 1;
    static final int STATE2 = 2;
    int pictState;

    public void initDecoder(InputStream in, AdaptiveRasterImage ji) throws JimiException {
        this.in = in;
        this.bcis = new ByteCountInputStream(new BufferedInputStream(in));
        this.dIn = new DataInputStream(this.bcis);
        this.ji = ji;
        this.state = 0;
        this.pictState = 1;
    }

    public boolean driveDecoder() throws JimiException {
        switch (this.pictState) {
            case 1: {
                try {
                    this.pictFH = new PICTFileHeader(this.dIn);
                }
                catch (IOException e) {
                    throw new JimiException("IO error reading PICT file");
                }
                this.pictState = 2;
                this.state |= 2;
                return true;
            }
            case 2: {
                try {
                    int opcode;
                    if (this.pictFH.ver1) {
                        opcode = this.dIn.readUnsignedByte();
                    } else {
                        if ((this.bcis.getCount() & 1L) != 0L) {
                            this.dIn.readByte();
                        }
                        opcode = this.dIn.readUnsignedShort();
                    }
                    boolean pictDecoderReturn = this.drivePictDecoder(opcode);
                    return pictDecoderReturn;
                }
                catch (IOException e) {
                    this.state |= 1;
                    throw new JimiException("reading opcode/version");
                }
                catch (JimiException e) {
                    this.state |= 1;
                    throw e;
                }
            }
        }
        return true;
    }

    public void freeDecoder() throws JimiException {
        this.in = null;
        this.dIn = null;
        this.pictState = 1;
        this.ji = null;
    }

    public int getState() {
        return this.state;
    }

    public AdaptiveRasterImage getJimiImage() {
        return this.ji;
    }

    public boolean usesChanneledData() {
        return true;
    }

    boolean drivePictDecoder(int opcode) throws JimiException, IOException {
        boolean catchall = false;
        switch (opcode) {
            case 145: {
                this.handlePackBits(opcode);
                break;
            }
            case 153: {
                this.handlePackBits(opcode);
                break;
            }
            case 1: {
                this.skip_01();
                break;
            }
            case 144: {
                this.handlePackBits(opcode);
                break;
            }
            case 152: {
                this.handlePackBits(opcode);
                break;
            }
            case 154: {
                this.handlePackBits(opcode);
                break;
            }
            case 161: {
                this.skip_06();
                break;
            }
            case 255: {
                this.state |= 4;
                return false;
            }
        }
        if (catchall) {
            this.skipPictOpcode(opcode);
        }
        return true;
    }

    void handlePackBits(int opcode) throws IOException, JimiException {
        if (opcode == 154) {
            this.handlePixmap(opcode);
        } else {
            this.rowBytes = this.dIn.readUnsignedShort();
            if (this.pictFH.ver1 || (this.rowBytes & 0x8000) == 0) {
                this.handleBitmap(opcode);
            } else {
                this.handlePixmap(opcode);
            }
        }
        this.ji.addFullCoverage();
    }

    void handleBitmap(int opcode) throws IOException, JimiException {
        this.rowBytes &= 0x3FFF;
        DirectColorModel cm = new DirectColorModel(1, 1, 1, 1);
        PICTBitmap bitmap = new PICTBitmap(this.dIn);
        int width = bitmap.bounding.brX - bitmap.bounding.tlX;
        int height = bitmap.bounding.brY - bitmap.bounding.tlY;
        this.ji.setSize(width, height);
        this.ji.setColorModel(cm);
        this.ji.setPixels();
        byte[] buf = new byte[this.rowBytes + 1 + this.rowBytes / 128];
        byte[] uBuf = new byte[this.rowBytes];
        byte[] outBuf = new byte[width];
        for (int row = 0; row < height; ++row) {
            if (this.rowBytes < 8) {
                this.dIn.readFully(buf, 0, this.rowBytes);
                int j = buf.length;
                while (--j >= 0) {
                    buf[j] = ~buf[j];
                }
                JimiUtil.expandPixels(1, buf, outBuf, outBuf.length);
            } else {
                int rawLen = this.rowBytes > 250 ? this.dIn.readUnsignedShort() : this.dIn.readUnsignedByte();
                this.dIn.readFully(buf, 0, rawLen);
                Packbits.unpackbits(buf, uBuf);
                int j = uBuf.length;
                while (--j >= 0) {
                    uBuf[j] = ~uBuf[j];
                }
                JimiUtil.expandPixels(1, uBuf, outBuf, outBuf.length);
            }
            this.ji.setChannel(0, row, outBuf);
            this.setProgress(row * 100 / (height - 1));
        }
    }

    void handlePixmap(int opcode) throws IOException, JimiException {
        short compCount;
        short pixelSize;
        int height;
        int width;
        ColorModel cm;
        block6: {
            PICTColorTable colorTable;
            PICTPixmap pxmap;
            block5: {
                pxmap = null;
                PICTPixmap9A pxmap9A = null;
                colorTable = null;
                cm = null;
                if (opcode != 154) break block5;
                pxmap9A = new PICTPixmap9A(this.dIn);
                width = pxmap9A.bounding.brX - pxmap9A.bounding.tlX;
                height = pxmap9A.bounding.brY - pxmap9A.bounding.tlY;
                pixelSize = pxmap9A.pixelSize;
                compCount = pxmap9A.compCount;
                switch (pixelSize) {
                    case 32: {
                        this.rowBytes = width * pxmap9A.compCount;
                        cm = new DirectColorModel(24, 0xFF0000, 65280, 255);
                        break block6;
                    }
                    case 16: {
                        this.rowBytes = width * 2;
                        cm = new DirectColorModel(16, 31744, 992, 31);
                        break block6;
                    }
                    default: {
                        throw new JimiException("Opcode 9a has pixelSize of " + pixelSize);
                    }
                }
            }
            this.rowBytes &= 0x3FFF;
            pxmap = new PICTPixmap(this.dIn);
            colorTable = new PICTColorTable(this.dIn);
            cm = colorTable.createColorModel(pxmap);
            width = pxmap.bounding.brX - pxmap.bounding.tlX;
            height = pxmap.bounding.brY - pxmap.bounding.tlY;
            pixelSize = pxmap.pixelSize;
            compCount = pxmap.compCount;
        }
        PICTRectangle source = new PICTRectangle(this.dIn);
        PICTRectangle dest = new PICTRectangle(this.dIn);
        short mode = this.dIn.readShort();
        if (opcode == 145 || opcode == 153) {
            this.skip_01();
        }
        this.ji.setSize(width, height);
        this.ji.setColorModel(cm);
        this.ji.setPixels();
        this.handlePixmap(this.ji, this.rowBytes, pixelSize, compCount);
    }

    private void handlePixmap(AdaptiveRasterImage ji, int rowBytes, int pixelSize, short compCount) throws IOException, JimiException {
        boolean compressed = rowBytes >= 8 || pixelSize == 32;
        int bufSize = rowBytes;
        byte[] uBuf = null;
        byte[] outBuf = null;
        int[] uBufI = null;
        int width = ji.getWidth();
        int height = ji.getHeight();
        int outBufSize = width;
        switch (pixelSize) {
            case 32: {
                if (!compressed) {
                    uBufI = new int[width];
                    break;
                }
                uBuf = new byte[bufSize];
                break;
            }
            case 16: {
                uBufI = new int[width];
                break;
            }
            case 8: {
                uBuf = new byte[bufSize];
                break;
            }
            default: {
                outBuf = new byte[outBufSize];
                uBuf = new byte[bufSize];
            }
        }
        if (!compressed) {
            byte[] buf = new byte[bufSize];
            for (int row = 0; row < height; ++row) {
                this.dIn.readFully(buf, 0, rowBytes);
                switch (pixelSize) {
                    case 16: {
                        for (int i = 0; i < width; ++i) {
                            uBufI[i] = ((buf[i * 2] & 0xFF) << 8) + (buf[i * 2 + 1] & 0xFF);
                        }
                        ji.setChannel(row, uBufI);
                        break;
                    }
                    case 8: {
                        ji.setChannel(0, row, buf);
                        break;
                    }
                    default: {
                        JimiUtil.expandPixels(pixelSize, buf, outBuf, outBuf.length);
                        ji.setChannel(0, row, outBuf);
                    }
                }
                this.setProgress(row * 100 / height);
            }
        } else {
            int row;
            byte[] buf = new byte[bufSize + 1 + bufSize / 128];
            for (row = 0; row < height; ++row) {
                int rawLen = rowBytes > 250 ? this.dIn.readUnsignedShort() : this.dIn.readUnsignedByte();
                if (rawLen > bufSize + 1 + bufSize / 128) {
                    throw new JimiException("**** rawLen " + rawLen + " bufSize " + bufSize);
                }
                this.dIn.readFully(buf, 0, rawLen);
                if (pixelSize == 16) {
                    Packbits.unpackbits(buf, uBufI);
                    ji.setChannel(row, uBufI);
                    continue;
                }
                try {
                    Packbits.unpackbitsLimit(buf, rawLen, uBuf);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new JimiException("Error unpacking data");
                }
                if (pixelSize < 8) {
                    JimiUtil.expandPixels(pixelSize, uBuf, outBuf, outBuf.length);
                    ji.setChannel(0, row, outBuf);
                    continue;
                }
                if (pixelSize == 8) {
                    ji.setChannel(0, row, uBuf);
                    continue;
                }
                if (pixelSize != 24 && pixelSize != 32) continue;
                int offset = 0;
                if (compCount == 4) {
                    ji.setChannel(24, row, uBuf, offset, width);
                    offset += width;
                }
                ji.setChannel(16, row, uBuf, offset, width);
                ji.setChannel(8, row, uBuf, offset += width, width);
                ji.setChannel(0, row, uBuf, offset += width, width);
            }
            this.setProgress(row * 100 / height);
        }
    }

    void skipPictOpcode(int opcode) {
    }

    void skip_01() throws IOException {
        short size = this.dIn.readShort();
        this.dIn.skip(size - 2);
    }

    void skip_02() throws IOException {
        this.dIn.skip(4L);
        this.skip_03();
    }

    void skip_03() throws IOException {
        int size = this.dIn.readUnsignedByte();
        this.dIn.skip(size);
    }

    void skip_04() throws IOException {
        this.dIn.skip(1L);
        this.skip_03();
    }

    void skip_05() throws IOException {
    }

    void skip_06() throws IOException {
        this.dIn.skip(2L);
        int size = this.dIn.readUnsignedShort();
        this.dIn.skip(size);
    }
}

