/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.decoder.pict;

import com.sun.jimi.core.decoder.pict.PICT2Header;
import com.sun.jimi.core.decoder.pict.PICTRectangle;
import java.io.DataInputStream;
import java.io.IOException;

public class PICTFileHeader {
    short fileSize;
    PICTRectangle frame;
    byte verOpcode;
    byte verNumber;
    short verOpcode2;
    short verNumber2;
    PICT2Header pict2Header;
    boolean ver1;

    public PICTFileHeader(DataInputStream in) throws IOException {
        in.skip(512L);
        this.fileSize = in.readShort();
        this.frame = new PICTRectangle(in);
        this.verOpcode = in.readByte();
        this.verNumber = in.readByte();
        if (this.verOpcode == 17 && this.verNumber == 1) {
            this.ver1 = true;
        } else if (this.verOpcode == 0 && this.verNumber == 17) {
            this.ver1 = false;
            this.verOpcode2 = (short)17;
            this.verNumber2 = in.readShort();
            if (this.verNumber2 != 767) {
                throw new IOException("Invalid PICT file format");
            }
            this.pict2Header = new PICT2Header(in);
        } else {
            throw new IOException("Invalid PICT file format");
        }
    }

    public String toString() {
        String s = "PICT Header ";
        s = this.ver1 ? s + "v1" : s + "v2";
        return s + this.pict2Header.toString();
    }
}

