/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.decoder.pict;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.decoder.pict.PICTRectangle;
import java.io.DataInputStream;
import java.io.IOException;

class PICTPixmap {
    PICTRectangle bounding;
    short version;
    short packType;
    int packSize;
    int hRes;
    int vRes;
    short pixelType;
    short pixelSize;
    short compCount;
    short compSize;
    int planeBytes;
    int pmTable;
    int reserved;

    PICTPixmap(DataInputStream dIn) throws IOException, JimiException {
        this.bounding = new PICTRectangle(dIn);
        this.version = dIn.readShort();
        this.packType = dIn.readShort();
        this.packSize = dIn.readInt();
        this.hRes = dIn.readInt();
        this.vRes = dIn.readInt();
        this.pixelType = dIn.readShort();
        this.pixelSize = dIn.readShort();
        this.compCount = dIn.readShort();
        this.compSize = dIn.readShort();
        this.planeBytes = dIn.readInt();
        this.pmTable = dIn.readInt();
        this.reserved = dIn.readInt();
        if (this.pixelType != 0) {
            throw new JimiException("not a chunky format pixmap");
        }
        if (this.compCount != 1) {
            throw new JimiException("invalid component count");
        }
        if (this.pixelSize != this.compSize) {
            throw new JimiException("pixel size != component size");
        }
    }

    public String toString() {
        return " bounding " + this.bounding.toString() + " version " + this.version + " packType " + this.packType + " packSize " + this.packSize + " hRes " + this.hRes + " vRes " + this.vRes + " pixelType " + this.pixelType + " pixelSize " + this.pixelSize + " compCount " + this.compCount + " compSize " + this.compSize + " planeBytes " + this.planeBytes;
    }
}

