/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.decoder.png;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class MeteredInputStream
extends FilterInputStream {
    int bytesLeft;
    int marked;

    public MeteredInputStream(InputStream in, int size) {
        super(in);
        this.bytesLeft = size;
    }

    public final int read() throws IOException {
        if (this.bytesLeft > 0) {
            int val = this.in.read();
            if (val != -1) {
                --this.bytesLeft;
            }
            return val;
        }
        return -1;
    }

    public final int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public final int read(byte[] b, int off, int len) throws IOException {
        if (this.bytesLeft > 0) {
            int read = this.in.read(b, off, len = len > this.bytesLeft ? this.bytesLeft : len);
            if (read > 0) {
                this.bytesLeft -= read;
            }
            return read;
        }
        return -1;
    }

    public final long skip(long n) throws IOException {
        long skipped = this.in.skip(n = n > (long)this.bytesLeft ? (long)this.bytesLeft : n);
        if (skipped > 0L) {
            this.bytesLeft = (int)((long)this.bytesLeft - skipped);
        }
        return skipped;
    }

    public final int available() throws IOException {
        int n = this.in.available();
        return n > this.bytesLeft ? this.bytesLeft : n;
    }

    public final void close() throws IOException {
    }

    public final void mark(int readlimit) {
        this.marked = this.bytesLeft;
        this.in.mark(readlimit);
    }

    public final void reset() throws IOException {
        this.in.reset();
        this.bytesLeft = this.marked;
    }

    public final boolean markSupported() {
        return this.in.markSupported();
    }
}

